(*
  A good VGA Scroll.

  Author   : Jose Antonio Noda
             Urb: 80 viviendas, B-5, 1 izq.
             35620 - Gran Tarajal
             Fuerteventura - (Islas Canarias)
             Spain
             Compuserve ID      100667,2523
*)

program VgaScroll;

const
  GSeg   = $A000;
  Bits   : array[0..7] of byte = (128,64,32,16,8,4,2,1);
  ColTab : array[0..7] of byte =
    (1,9,3,11,11,3,9,1);
  ScrT   : string[31] = 'Hi, this is a scroller...      ';

type registers = record
       case byte of
         1 : (AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : Integer);
         2 : (AL,AH,BL,BH,CL,CH,DL,DH : Byte);
     end;

var
  Fseg,Fofs : integer;
  I,J : integer;
  CharPos,Pos,Color,Character : byte;
  regs : registers;
{----------------------------------------------------------------------------}

procedure Getfont;
 begin
  regs.ax:=$1130;
  regs.bh:=$1;
  intr($10,regs);
  Fseg:=regs.es;
  Fofs:=regs.bp;
 end;

{----------------------------------------------------------------------------}

procedure SetGraphics(Mode : integer);
 Begin
  regs.ax:=mode;
  intr($10,regs);
 end;

{----------------------------------------------------------------------------}

procedure Scroll;

begin
    Character := ord(ScrT[Pos]);
    for CharPos := 0 to 7 do begin
      for I := 0 to 7 do begin
        if mem[Fseg:Fofs+(Character*8)+I] and Bits[CharPos] <> 0 then Color :=
          ColTab[I]
        else Color := {black} 0;
        mem[GSeg:(((24*8)+I)*320)+319] := Color;
      end;
      while (port[$3DA] and 8) <> 0 do;
      while (port[$3DA] and 8) = 0 do;
      for J := 0 to 7 do for I := 0 to 318 do
        mem[GSeg:(((24*8)+J)*320)+I] := mem[GSeg:(((24*8)+J)*320)+1+I];
    end;
    Pos:=Pos+1{inc(Pos)}; if Pos = length(ScrT) then Pos := 1;

end;

{----------------------------------------------------------------------------}

begin
  {checkvga;}
  Pos := 1;
  clrscr;

  GetFont;
  write(chr(27)+'0');
  SetGraphics($13);
  repeat
    Scroll;
  until keypressed;
  SetGraphics($3);
  write(chr(27)+'1');
  {statuson;}
end.

