 /* Small-c Entab Program
  *
  * Copies a disk file and inserts tabs for blanks along the way.
  *	As of June 20, 1982
  *
  */

#define BLANK	32
#define EOF	-1
#define NULL	0
#define TAB	9
#define NL	13
#define MAXLINE	128

	char tabstop[MAXLINE];	/* defines tab stops */
	char infile[80],outfile[80];
	char *in,*out;
	int c, t;
	int col, newcol, lin;

main()
{
	/* Do initialization. */
	settabs(tabstop,8);	/* Set up tab stops. */
	puts("Input file?  ");	/* Get input file name. */
	gets(infile);
	in = fopen(infile,"r");	/* Open the input file. */
	if(in==NULL){
		puts("Can't read ");
		puts(infile);
		putchar('.');
		nl();
		return;
		}
	while(1){		/* Get the output file name. */
	 	puts("Output file? ");
	 	gets(outfile);
	 	out = fopen(outfile,"r");
	 	if(out==NULL)
			break;
		else {	puts(outfile);
	 		puts(" already exists.");
			nl();
	 		}
		}
	out = fopen(outfile,"w");
	if(out==NULL){
		puts("Can't write ");
		puts(outfile);
		putchar('.');
		nl();
		return;
		}
	
	
	/* Process the file. */
	col=0;
	while((c=getc(in))!=EOF){
		newcol=col;
		/*Scan all blanks putting tabs 
		  when necessary.*/
		while(c==BLANK){
			++newcol;
			if(tabpos(tabstop,newcol)){
				putc(TAB,out);
				col=newcol;
				}
			c=getc(in);
			}
		/*Add extra blanks if needed.*/
		while(col<newcol){
			putc(BLANK,out);
			++col;
			}
		/*Output non-blank character.*/
		if(c!=EOF){
			putc(c,out);
			if(c==NL){
				col=0;
				++lin;
				}
			else
				++col;
			}
		}	

	/* Do termination. */
	fclose(in);		/* Close all files. */
	fclose(out);
	puts("Line(s) copied = "); /* Indicate number 
				      of lines copied. */
	putnum(lin);
	nl();
/* end main */}


/* Start a new line on the screen. */
nl()
{
	putchar(NL);
/* end nl */}


/* Output a char 0-9. */
putnum(n)
int n;
{
	if(n>9)
		putnum(n/10);
	putchar('0'+(n%10));

/* end putnum */}


/* Set tab stops to given positions. */
settabs(tabstp,tabsize)
	char tabstp[];
	int tabsize;
{	int i;

	/* Set up the array. */
	i=0;
	while(i<MAXLINE)
		{tabstop[i]=((i%tabsize)==0);
		++i;
		}

	/* Print the tab stop array. */
	nl();
	i = 0;
	while(i<MAXLINE)
		putnum(tabstop[i++]);
	nl();

	}


/* Indicate if current position is a tab stop. */
tabpos(tabstp,tabcol)
	char tabstp[];
	int tabcol;
{
	if(tabcol>MAXLINE)
		return 1;
	else
		return tabstp[tabcol];
	}
