/*	>>>>>> start of cc9 <<<<<<<	*/

/* Call the specified subroutine name */
zcall(sname)
	char *sname;
{	ot("CALL ");
	outname(sname);
	nl();
}

/* Call a run-time library routine */
callrts(sname)
char *sname;
{
	ot("CALL ");
	outasm(sname);
	nl();
/*end callrts*/}

/* Return from subroutine */
zret()
{	ol("RET");
}

/* Perform subroutine call to value on top of stack */
callstk()
{	immed();
	outasm("(Offset $+3+2+2+2)");
	nl();
	ol("MOV DI,SP");
	ol("XCHG BX,[DI]");
	ol("JMP BX");
	Zsp=Zsp-2;
	}

/* Jump to specified internal label number */
jump(label)
	int label;
{	ot("JMP ");
	printlabel(label);
	nl();
	}

/* Test the primary register and jump if false to label */
testjump(label)
	int label;
{	ol("OR BX,BX");
	ol("JNZ $+5");
	ot("JMP ");
	printlabel(label);
	nl();
	}

/* Print pseudo-op to define a byte */
defbyte()
{	ot("DB ");
}

/*Print pseudo-op to define storage (Character). */
defstorchr()
{	ot("RB ");
}

/*Print pseudo-op to define storage (Integer). */
defstorint()
{	ot("RW ");
}

/*Print pseudo-op to define storage (Pointer). */
defstorptr()
{	ot("RW ");
}

/* Print pseudo-op to define a word */
defword()
{	ot("DW ");
}

/* Modify the stack pointer to the new value indicated */
modstk(newsp)
	int newsp;
 {	int k;
	k=newsp-Zsp;
	if(k==0)return newsp;
	ot("ADD SP,");
	outdec(k);
	nl();
	return newsp;
}

/* Modify the stack pointer to the new value indicated */
rtnstk(newsp)
	int newsp;
 {
	if(Msp!=0)
		{ot("ADD SP,");		/*Remove frame from stack.*/
		ostklbl();
		nl();
		}
	ol("POP BP");
	return newsp;
}

/* Double the primary register */
doublereg()
{	ol("SAL BX,1");
}

/* Add the primary and secondary registers */
/*	(results in primary) */
zadd()
{	ol("ADD BX,DX");
	}

/* Subtract the primary register from the secondary */
/*	(results in primary) */
zsub()
{	ol("SUB DX,BX");
	ol("MOV BX,DX");
	}

/* Multiply the primary and secondary registers */
/*	(results in primary) */
mult()
{	ol("MOV AX,BX");
	ol("PUSH DX");
	ol("MUL DX");
	ol("POP DX");
	ol("MOV BX,AX");
	}

/* Divide the secondary register by the primary */
/*	(quotient in primary, remainder in secondary) */
div()
{	ol("MOV AX,DX");
	ol("CWD");
	ol("DIV BX");
	ol("MOV BX,AX");
	}

/* Compute remainder (mod) of secondary register divided */
/*	by the primary */
/*	(remainder in primary, quotient in secondary) */
zmod()
{	div();
	swap();
	}

/* Inclusive 'or' the primary and the secondary registers */
/*	(results in primary) */
zor()
	{ol("OR BX,DX");}

/* Exclusive 'or' the primary and seconday registers */
/*	(results in primary) */
zxor()
	{ol("XOR BX,DX");}

/* 'And' the primary and secondary registers */
/*	(results in primary) */
zand()
	{ol("AND BX,DX");}

/* Arithmetic shift right the secondary register number of */
/* 	times in primary (results in primary) */
asr()
	{ol("MOV CX,BX");
	 ol("SAR DX,CL");
	 ol("MOV BX,DX");
	}

/* Arithmetic left shift the secondary register number of */
/*	times in primary (results in primary) */
asl()
	{ol("MOV CX,BX");
	 ol("SAL DX,CL");
	 ol("MOV BX,DX");
	}

/* Form two's complement of primary register */
neg()
	{ol("NEG BX");}

/* Form one's complement of primary register */
com()
	{ol("NOT BX");}

/* Increment the primary register by one */
inc()
	{ol("INC BX");}

/* Decrement the primary register by one */
dec()
	{ol("DEC BX");}

/* Following are the conditional operators */
/* They compare the secondary register against the primary */
/* and put a literal 1 in the primary if the condition is */
/* true, otherwise they clear the primary register */

/* Test for equal */
zeq()
	{callrts("cceq");
	}
/* Test for not equal */
zne()
	{callrts("ccne");
	}
/* Test for less than (signed) */
zlt()
	{callrts("cclt");
	}
/* Test for less than or equal to (signed) */
zle()
	{callrts("ccle");
	}
/* Test for greater than (signed) */
zgt()
	{callrts("ccgt");
	}
/* Test for greater than or equal to (signed) */
zge()
	{callrts("ccge");
	}
/* Test for less than (unsigned) */
ult()
	{callrts("ccult");
	}
/* Test for less than or equal to (unsigned) */
ule()
	{callrts("ccule");
	}
/* Test for greater than (unsigned) */
ugt()
	{callrts("ccugt");
	}
/* Test for greater than or equal to (unsigned) */
uge()
	{callrts("ccuge");
	}

