/*	>>>>>> start of cc2 <<<<<<<<	*/

/*					*/
/*	Get required array size		*/
/*					*/
/* invoked when declared variable is followed by "[" */
/*	this routine makes subscript the absolute */
/*	size of the array. */
needsub()
	{
	int num[1];
	if(match("]"))return 0;	/* null size */
	if (number(num)==0)	/* go after a number */
		{error("must be constant");	/* it isn't */
		num[0]=1;		/* so force one */
		}
	if (num[0]<0)
		{error("negative size illegal");
		num[0]=(-num[0]);
		}
	needbrack("]");		/* force single dimension */
	return num[0];		/* and return size */
	}
/*					*/
/*	Begin a function		*/
/*					*/
/* Called from "parse" this routine tries to make a function */
/*	out of what follows.	*/
newfunc()
	{
	char n[namesize];	/* ptr => currfn,  gtf 7/16/80 */
	int argtop;		/* max arg stack size */
	if (symname(n)==0)
		{error("illegal function or declaration");
		kill();	/* invalidate line */
		return;
		}
	fnstart=lineno;		/* remember where fn began	gtf 7/2/80 */
	infunc=1;		/* note, in function now.	gtf 7/16/80 */
	if(currfn=findglb(n))	/* already in symbol table ? */
		{if(currfn[ident]!=function)multidef(n);
			/* already variable by that name */
		else if(currfn[offset]==function)multidef(n);
			/* already function by that name */
		else currfn[offset]=function;
			/* otherwise we have what was earlier*/
			/*  assumed to be a function */
		}
	/* if not in table, define as a function now */
	else currfn=addglb(n,function,cint,function);

	/* Indicate to console what routine that we're in. */
	toconsole();					/* gtf 7/16/80 */
	outstr("====== "); outstr(currfn+name); outstr("()"); nl();
	tofile();

	/* we had better see open paren for args... */
	if(match("(")==0)error("missing open paren");
	outname(n);col();nl();	/* print function name */
	locptr=startloc;	/* "clear" local symbol table*/
	argstk=0;		/* init arg count */
	while(match(")")==0)	/* then count args */
		/* any legal name bumps arg count */
		{if(symname(n))
			{if(findloc(n))
				multidef(n);
			else
				{addloc(n,0,0,argstk);
				/* Add local symbol to be later */
				/* processed by getarg(). */
				argstk=argstk+2;
				}
			}
		else{error("illegal argument name");junk();}
		blanks();
		/* if not closing paren, should be comma */
		if(streq(line+lptr,")")==0)
			{if(match(",")==0)
			error("expected comma");
			}
		if(endst())break;
		}

	argtop=argstk;		/* Save max arg stack size. */
	while(argstk)
		/* now let user declare what types of things */
		/*	those arguments were */
		{if(amatch("char",4))
			{getarg(cchar,argtop);
			ns();
			continue;
			}
		else if(amatch("int",3))
			{getarg(cint,argtop);
			ns();
			continue;
			}
		else{error("wrong number args");break;}
		}

	Msp=00;			/* Preset local stack ptr. */
	Zsp=00;			/* preset stack ptr */
	funcbgn();		/* Do function initialization. */

	if(statement()!=streturn) /* do all statements, but if */
				/* last one is a return, skip */
				/* cleaning up the stack */
		{rtnstk(0);
		zret();
		}

	/* Handle function termination. */
	funcend();		/* Do function termination. */
	Msp=Zsp=0;		/* reset stack ptr again */
	dumplocs();		/* Dump the local symbol table. */
	locptr=startloc;	/* deallocate all locals */
	dumplits();		/* Dump the literal pool for the
				   function. */
	litlab=getlabel();	/* Now re-initialize the pool. */
	litptr=0;
	infunc=0;		/* not in fn. any more		gtf 7/2/80 */
	}
/*					*/
/*	Declare argument types		*/
/*					*/
/* called from "newfunc" this routine adds an entry in the */
/*	local symbol table for each named argument */
getarg(t,top)		/* t = cchar or cint, top = max arg stack */
	int t,top;

	/* top tells how the max arg stack size was found while
	   scanning arguments.  From this, we can calculate the
	   the actual stack offset and stuff it back into the
	   local symbol table.
	*/

	{
	char n[namesize],*argptr;
	int j, locaddr;
	while(1)
		{if(argstk==0)return;	/* no more args */
		if(match("*"))
			j=pointer;
		else
			j=variable;
		if(symname(n))
			{if(match("["))	/* pointer ? */
			/* it is a pointer, so skip all */
			/* stuff between "[]" */
				{while(inbyte()!=']')
					if(endst())break;
				j=pointer;
				/* add entry as pointer */
				}
			if(argptr=findloc(n))
				{argptr[ident]=j;
				/* save type info for arg just 
				   found. */
				argptr[type]=t;
				locaddr=top-(argptr[offset+1]<<8)
					-argptr[offset]+2;
				/*Calculate offset to arg taking
				  into account the return address
				  and the saved BP register left
				  on the stack. */
				argptr[offset]=locaddr;
				argptr[offset+1]=locaddr>>8;
				/*save offset back in local symbol
				  table entry. */
				}
			else
				error("expecting argument name");
			}
		else
			illname();
		argstk=argstk-2;	/* cnt down */
		if(endst())
			return;
		if(match(",")==0)
			error("expected comma");
		}
	}
/*					*/
/*	Statement parser		*/
/*					*/
/* called whenever syntax requires	*/
/*	a statement. 			 */
/*  this routine performs that statement */
/*  and returns a number telling which one */
statement()
{
	if(cpm(11,0) & 1)	/* check for ctrl-C		gtf 7/17/80 */
		if(getchar()==3)
			abort();

	if ((ch()==0) & (eof)) return;
	else if(amatch("char",4))
		{declloc(cchar);ns();}
	else if(amatch("int",3))
		{declloc(cint);ns();}
	else if(match("{"))compound();
	else if(amatch("if",2))
		{doif();lastst=stif;}
	else if(amatch("do",2))
		{dodo();lastst=stwhile;}
	else if(amatch("while",5))
		{dowhile();lastst=stwhile;}
	else if(amatch("return",6))
		{doreturn();ns();lastst=streturn;}
	else if(amatch("break",5))
		{dobreak();ns();lastst=stbreak;}
	else if(amatch("continue",8))
		{docont();ns();lastst=stcont;}
	else if(match(";"));
	else if(match("#asm"))
		{doasm();lastst=stasm;}
	/* if nothing else, assume it's an expression */
	else{expression();ns();lastst=stexp;}
	return lastst;
}
/*					*/
/*	Semicolon enforcer		*/
/*					*/
/* called whenever syntax requires a semicolon */
ns()	{if(match(";")==0)error("missing semicolon");}
/*					*/
/*	Compound statement		*/
/*					*/
/* allow any number of statements to fall between "{}" */
compound()
	{
	++ncmp;		/* new level open */
	while (match("}")==0) statement(); /* do one */
	--ncmp;		/* close current level */
	}
/*					*/
/*		"if" statement		*/
/*					*/
doif()
	{
	int flev,fsp,flab1,flab2;
	flev=locptr;	/* record current local level */
	fsp=Zsp;		/* record current stk ptr */
	flab1=getlabel(); /* get label for false branch */
	test(flab1);	/* get expression, and branch false */
	statement();	/* if true, do a statement */
	Zsp=modstk(fsp);	/* then clean up the stack */
	locptr=flev;	/* and deallocate any locals */
	if (amatch("else",4)==0)	/* if...else ? */
		/* simple "if"...print false label */
		{printlabel(flab1);col();nl();
		return;		/* and exit */
		}
	/* an "if...else" statement. */
	jump(flab2=getlabel());	/* jump around false code */
	printlabel(flab1);col();nl();	/* print false label */
	statement();		/* and do "else" clause */
	Zsp=modstk(fsp);		/* then clean up stk ptr */
	locptr=flev;		/* and deallocate locals */
	printlabel(flab2);col();nl();	/* print true label */
	}
/*					*/
/*	"do" statement "while" (expr)	*/
/*					*/
dodo()
	{
	int wq[wqsiz];		/* allocate local queue */
	wq[wqsym]=locptr;	/* record local level */
	wq[wqsp]=Zsp;		/* and stk ptr */
	wq[wqloop]=getlabel();	/* and looping label */
	wq[wqlab]=getlabel();	/* and exit label */
	wq[wqlab2]=getlabel();	/* and loop label */
	addwhile(wq);		/* add entry to queue */
				/* (for "break" statement) */
	printlabel(wq[wqlab2]);col();nl(); /* loop label */
	statement();		/* do a statement */
	if (amatch("while",5)==0)
		{error("'while' expected.");
		return;		/* and exit */
		}
	printlabel(wq[wqloop]);col();nl(); /* cont label */
	test(wq[wqlab]);	/* get expression and branch false */
	jump(wq[wqlab2]);	/* continue to loop */
	printlabel(wq[wqlab]);col();nl(); /* exit label */
	ns();			/* look for ending semi-colon. */
	locptr=wq[wqsym];	/* deallocate locals */
	Zsp=modstk(wq[wqsp]);	/* clean up stk ptr */
	delwhile();		/* delete queue entry */
	}
/*					*/
/*	"while" (expr) statement	*/
/*					*/
dowhile()
	{
	int wq[wqsiz];		/* allocate local queue */
	wq[wqsym]=locptr;	/* record local level */
	wq[wqsp]=Zsp;		/* and stk ptr */
	wq[wqloop]=getlabel();	/* and looping label */
	wq[wqlab]=getlabel();	/* and exit label */
	addwhile(wq);		/* add entry to queue */
				/* (for "break" statement) */
	printlabel(wq[wqloop]);col();nl(); /* loop label */
	test(wq[wqlab]);	/* see if true */
	statement();		/* if so, do a statement */
	jump(wq[wqloop]);	/* loop to label */
	printlabel(wq[wqlab]);col();nl(); /* exit label */
	locptr=wq[wqsym];	/* deallocate locals */
	Zsp=modstk(wq[wqsp]);	/* clean up stk ptr */
	delwhile();		/* delete queue entry */
	}
/*					*/
/*	"return" statement		*/
/*					*/
doreturn()
	{
	/* if not end of statement, get an expression */
	if(endst()==0)expression();
	rtnstk(0);	/* clean up stk */
	zret();		/* and exit function */
	}
/*					*/
/*	"break" statement		*/
/*					*/
dobreak()
	{
	int *ptr;
	/* see if any "whiles" are open */
	if ((ptr=readwhile())==0) return;	/* no */
	modstk((ptr[wqsp]));	/* else clean up stk ptr */
	jump(ptr[wqlab]);	/* jump to exit label */
	}
/*					*/
/*	"continue" statement		*/
/*					*/
docont()
	{
	int *ptr;
	/* see if any "whiles" are open */
	if ((ptr=readwhile())==0) return;	/* no */
	modstk((ptr[wqsp]));	/* else clean up stk ptr */
	jump(ptr[wqloop]);	/* jump to loop label */
	}
/*					*/
/*	"asm" pseudo-statement		*/
/*					*/
/* enters mode where assembly language statement are */
/*	passed intact through parser	*/
doasm()
	{
	cmode=0;		/* mark mode as "asm" */
	while (1)
		{inline();	/* get and print lines */
		if (match("#endasm")) break;	/* until... */
		if(eof)break;
		outstr(line);
		nl();
		}
	kill();		/* invalidate line */
	cmode=1;		/* then back to parse level */
	}
