program Reverse;

{
  Sample program demonstrating manipulation of the VGA (EGA?)
  alphanumeric character set using the 80x25 character mode.

  The only thing this program does is to copy the current character
  set from the video adapter, and restore it in such a way that all
  the characters appear upside-down.  To restore the characters,
  simply run the program again.  Not that this is a terribly useful
  thing to do, mind you...

  NOTE: This has not been tested on monochrome monitors or in
        other video modes.

  Written using Borland Pascal 7.0.

  For more information on character sets for other video modes and
  a whole bunch of good stuff on the EGA & VGA in general, you will
  want the following book:

   Title     - "Programmer's Guide to PC & PS/2 Video Systems"
   Author    - Richard Wilton, 1987
   Publisher - Microsoft Press
               16011 NE 36th Way
               Box 97017
               Redmond, Washington  98073-9717
}

  var
    I, J: integer;
    CBuf: array [0..8191] of byte; { Buffer for original character map }


  procedure CharGenModeOn;

  { I'm sorry that there is no explanation here, but I did this a while
    ago and I don't have the reference with me right now.   }

    begin
      Inline(
        $FA/                   {        cli}
        $BA/$C4/$03/           {        mov       dx,$03C4}
        $B8/$00/$01/           {        mov       ax,$0100}
        $EF/                   {        out       dx,ax}
        $B8/$02/$04/           {        mov       ax,$0402}
        $EF/                   {        out       dx,ax}
        $B8/$04/$07/           {        mov       ax,$0704}
        $EF/                   {        out       dx,ax}
        $B8/$00/$03/           {        mov       ax,$0300}
        $EF/                   {        out       dx,ax}
        $FB/                   {        sti}
        $B2/$CE/               {        mov       dl,$0CE}
        $B8/$04/$02/           {        mov       ax,$0204}
        $EF/                   {        out       dx,ax}
        $B8/$05/$00/           {        mov       ax,$0005}
        $EF/                   {        out       dx,ax}
        $B8/$06/$00/           {        mov       ax,$0006}
        $EF);                  {        out       dx,ax}
    end;


  procedure CharGenModeOff;

    begin
      Inline(
        $FA/                   {        cli}
        $BA/$C4/$03/           {        mov       dx,$03C4}
        $B8/$00/$01/           {        mov       ax,$0100}
        $EF/                   {        out       dx,ax}
        $B8/$02/$03/           {        mov       ax,$0302}
        $EF/                   {        out       dx,ax}
        $B8/$04/$03/           {        mov       ax,$0304}
        $EF/                   {        out       dx,ax}
        $B8/$00/$03/           {        mov       ax,$0300}
        $EF/                   {        out       dx,ax}
        $FB/                   {        sti}
        $B2/$CE/               {        mov       dl,$0CE}
        $B8/$04/$00/           {        mov       ax,$0004}
        $EF/                   {        out       dx,ax}
        $B8/$05/$10/           {        mov       ax,$1005}
        $EF/                   {        out       dx,ax}
        $B8/$06/$0E/           {        mov       ax,$0E06}
        $EF/                   {        out       dx,ax}
        $B4/$0F/               {        mov       ah,$0F}
        $CD/$10/               {        int       $10}
        $3C/$07/               {        cmp       al,7}
        $75/$04/               {        jne       skip}
        $B8/$06/$08/           {        mov       ax,$0806}
        $EF);                  {        out       dx,ax}
                         {      skip:}
    end;


  begin
    CharGenModeOn;  { Get access to character map }

    { Copy the current character map into the buffer }
    move( mem[$A000: 0], CBuf, 8192 );

    { Restore the map, inverting the top 16 scan lines.

      Characters are stored in a 8x32 pixel matrix, allowing
      for characters that are 32 scan lines high.  Each byte
      in the buffer represents one scan line of a single
      character.  In the 80x25 character mode only the first
      16 scan lines are displayed, so we need to be a little
      careful about what bytes are swapped. }

    for I := 0 to 255 do                { Each of the 256 characters }
      for J := 0 to 15 do               { Top 16 scan lines of each }
        mem[$a000:((I*32) + J)] := CBuf[(I*32) + (15 - J)];

    CharGenModeOff; { Restore normal video operations }
  end.
