{ Terminal Procedures used under CP/M-86 to be used under
  Turbo Pascal 3.x, Written By Ross Simpson  Ver 0.4}

{include this file with main Pascal program to use textcolor, textmode,
 textbackground, statuson, statusoff, Pause, ReadKey, WhereX, WhereY,
 Fastwrite, Sound & Nosound}

{ Description of commands:

    textcolor (col); ........Changes text foreground colour.
                             Acceptable values for (col) are:
                                 0 = black      8 = gray
                                 1 = blue       9 = bright blue
                                 2 = green     10 = bright green
                                 3 = cyan      11 = bright cyan
                                 4 = red       12 = bright red
                                 5 = magenta   13 = bright magenta
                                 6 = brown     14 = yellow
                                 7 = white     15 = bright white

    textbackground (col); ...Changes text background colour.
                             Acceptable values for (col) are:
                                 0 = black       4 = red
                                 1 = blue        5 = magenta
                                 2 = green       6 = brown
                                 3 = cyan        7 = white

    textmode (modenumber); ..Changes resolution of COLOR screen.
                                 textmode(1) for 40-column mode, and
                                 textmode(2) for 80-column mode
                             NOTE: Works only with =color= video systems.
                                   Do not use with Herc/MDA monochrome!

    statusoff; ..............Turns CP/M-86 status line off.

    statuson; ...............Turns CP/M-86 status line back on.

    CursorOff; ..............Turns Cursor Off.

    CursorOn; ...............Turns Curson On.

    pause; ..................Pauses the program until user presses a key.

    ReadKey; ................Function not included under TP3, Added for
                             more compatibility. ReadKey returns scancodes
                             from 0 keys as well as ASCII Values for
                             standard keys.

    WhereX; .................Returns the Columns Cursor Positon into a
                             variable. e.g.  col := whereX;

    WhereY; .................Returns the Rows Cursor Position into variable.
                              e.g. Row := WhereY;

    FastWrite(col,row,textcol,'text');. This little routine is an alternative
                             to the write & writeln. To use the column, row,
                             text colour as well as text are required. And
                             unlike write & writeln procedures handles 80x50
                             text display.
                             
    Sound(Hz);...............Makes a sound through the PC Speaker, Sound
                             produced depends on the value of Hz.
    
    NoSound;.................Simply turns the sound off from previous command.}

{ Special Thanks To All the People Who have Help to add to this list of
functions & procedures}

CONST PendingKey : BYTE = 0;
             c80 : BYTE = 3;

type string80 = string[80];
     Registers = Record
                 Case Integer Of
                    1 : ( AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : Integer );
                    2 : ( AL,AH,BL,BH,CL,CH,DL,DH : Byte );
                 END;

PROCEDURE textcolor (col: integer);
  BEGIN
   WRITE(CHR(27)+'b'+chr(col));
  END;

PROCEDURE textmode (mo: integer);
  BEGIN
   WRITE(CHR(27)+'a'+chr(mo));
  END;

PROCEDURE textbackground (bkgrnd: integer);
  BEGIN
   WRITE(CHR(27)+'c'+chr(bkgrnd));
  END;

PROCEDURE statusoff;
  BEGIN
    WRITE(CHR(27)+'0');
  END;

PROCEDURE statuson;
  BEGIN
    WRITE(CHR(27)+'1');
  END;

PROCEDURE cursoroff;
  BEGIN
    WRITE(CHR(27)+'n');
  END;

PROCEDURE cursoron;
  BEGIN
    WRITE(CHR(27)+'m');
  END;

PROCEDURE pause;
 var Regs : Registers;
  BEGIN
    Regs.AH:=$00;
    INTR($16,Regs);
  END;

FUNCTION ReadKey : CHAR;
  var Regs : Registers;
   BEGIN
    IF PendingKey<>0 THEN BEGIN
     ReadKey:=CHR(PendingKey);
     PendingKey:=0;
    END
   ELSE BEGIN
      Regs.AH:=0;
      INTR($16,Regs);
      IF Regs.AL=0 THEN PendingKey:=Regs.AH;
       ReadKey:=CHR(Regs.AL);
      END;
    END;

FUNCTION WhereX : Byte;
 Var Regs : Registers;
   Begin
    Regs.AH:=$03;
    Regs.BH:=$00;
    Intr ($10,Regs);
    WhereX:=Regs.DL+1;
   END;

FUNCTION WhereY : Byte;
 Var Regs : Registers;
   Begin
    Regs.AH:=$03;
    Regs.BH:=$00;
    Intr ($10,Regs);
    WhereY:=Regs.DH+1;
   END;

Procedure FastWrite(Col,Row,Attrib:Byte; Str:string80);
 begin
   inline
     ($1E/$1E/$8A/$86/row/$B3/$50/$F6/$E3/$2B/$DB/$8A/$9E/col/
     $03/$C3/$03/$C0/$8B/$F8/$be/$00/$00/$8A/$BE/attrib/
     $8a/$8e/str/$22/$c9/$74/$3e/$2b/$c0/$8E/$D8/$A0/$49/$04/
     $1F/$2C/$07/$74/$22/$BA/$00/$B8/$8E/$DA/$BA/$DA/$03/$46/
     $8a/$9A/str/$EC/$A8/$01/$75/$FB/$FA/$EC/$A8/$01/$74/$FB/
     $89/$1D/$47/$47/$E2/$Ea/$2A/$C0/$74/$10/$BA/$00/$B0/
     $8E/$DA/$46/$8a/$9A/str/$89/$1D/$47/$47/$E2/$F5/$1F/$FB);
 end;

procedure Sound(hz:integer);
begin
Inline(
  $8B/$5E/<HZ/           {  mov bx,[bp+<hz]}
  $B8/$DD/$34/           {  mov ax,$34dd}
  $BA/$12/$00/           {  mov dx,$0012}
  $39/$DA/               {  cmp dx,bx}
  $73/$1A/               {  jnc exit}
  $F7/$F3/               {  div bx}
  $89/$C3/               {  mov bx,ax}
  $E4/$61/               {  in al,$61}
  $A8/$03/               {  test al,3}
  $75/$08/               {  jnz loop1}
  $0C/$03/               {  or al,3}
  $E6/$61/               {  out $61,al}
  $B0/$B6/               {  mov al,$0b6}
  $E6/$43/               {  out $43,al}
                         { loop1:}
  $88/$D8/               {  mov al,bl}
  $E6/$42/               {  out $42,al}
  $88/$F8/               {  mov al,bh}
  $E6/$42);              {  out $42,al}
                         {exit:}
end;

procedure NoSound;
begin
Inline(
  $E4/$61/               {  in al,$61}
  $24/$FC/               {  and al,$0fc}
  $E6/$61);              {  out $61,al}
end;
