{Graphics Unit written for Turbo Pascal on CP/M-86 (in particular), however
 should work under DOS no worries. However this program requires 'Registers'
 included within the TERMINAL.INC (CP/M-86 specific). To enable the
 functions below insert {$I GRAF.INC}{ BELOW {$I TERMINAL.INC} {otherwise
 problems will result. Some of these functions have been written by me
 (Ross Simpson) to help support other features (e.g. Circle) & others
 (Line & SetMode) were picked out of other programs & figured they would help
 port more programs. Version 0.2

 SetMode(ModeNumber);..........Like textmode(mode); this does a mode change
                               via int 10h. Can be used for graphic modes,
                               untested for textmodes but should work fine.
                               Recomended Graphics Modes range from 4 ->
                               6, 13(0Dh) -> 19(13h). Use '$' if indicating a
                               Hexidecimal Num in Pascal.

 CheckVGA;.....................Handy if writing a program which uses 256
                               Graphics display (13h) to call this procedure
                               at the beginning to check a VGA card is being
                               used otherwise stops program with message
                               indicating this card is required.

 Line(x1,y1,x2,y2,col);........Draws a line from x1,y1 to x2,y2 in the
                               specified color very quickly.

 Plot(x,y,col);................Can be used by itself to draw a pixel at the
                               specified x,y co-ordinates in the specified
                               colour. Also used by circle to help draw a
                               circle.

 Circle(cx,cy,radius,col);.....Pretty straightford, radius tells the size of
                               the circle. If the radius is bigger than cx or
                               cy the circle will appear on the other side of
                               the screen (nothing damaging!)}


Procedure SetMode(Mode : Byte);
{ Interrupt $10, sub-Function 0 - Set video mode }
Var
  Regs : Registers;
begin
  With Regs do
  begin
    AH := 0;
    AL := Mode;
  end;
  Intr($10, Regs);
end; { SetMode }

Procedure CheckVGA;
Var
  Regs : Registers;
begin
  With Regs do
   begin
    AH := $1A;
    AL := 0;
   end;
   intr($10, Regs);
   if Regs.AL <> $1A THEN
    BEGIN
     TEXTMODE(3);
     WRITELN('VGA Required');
     Halt;
    END;
END;

procedure draw(x1,y1,x2,y2 : real; color,page : integer);

type
  result = record
    al,ah,bl,bh : byte;
    cx,dx,bp,si,di,ds,es,flags : integer;
  end;
var
  counter : real;
  int_result : result;
  dx,dy,ddx,ddy,newx,newy : real;
  b_page,b_color : byte;
  xmult,ymult : integer;

begin
  b_page := page;
  b_color := color;
  int_result.ah := $C;
  int_result.bh := b_page;  {active page}
  int_result.al := b_color;
  int_result.dx := round(y1);
  int_result.cx := round(x1);
  intr($10,int_result);

  dx := x2 - x1;
  if dx < 0.0 then xmult := -1 else xmult := 1; {increment can be negative}
  dy := y2 - y1;
  if dy < 0.0 then ymult := -1 else ymult := 1;

  {before getting ratios, check for zeros in dx and dy}
  if dy = 0.0 then begin
    {x will be incremented by 1 through every loop, y by 0}
    ddx := 1.0 * xmult;
    ymult := 0;
    dy := abs(dx);    {fool loop counter below}
  end
  else if dx = 0.0 then begin
    ddx := 2;
    ddy := 1 * ymult;
    xmult := 0;
    dx := abs(dy);    {fool loop counter}
  end
  else begin
    ddx := abs(dx/dy);  {get ratio}
    ddy := abs(dy/dx);
    ddx := ddx*xmult;
    ddy := ddy*ymult;
  end;

  {the following initializations are used in the proceeding loops}
  newy := y1;
  newx := x1;
  counter := 0.0;
  dy := abs(dy);
  dx := abs(dx);

  if abs(ddx) <= 1.0 then
  while counter < dy do begin
    counter := counter + 1.0;
    newx := newx + ddx;
    newy := newy + ymult;
    int_result.ah := $C;
    int_result.bh := b_page;  {active page}
    int_result.al := b_color;
    int_result.dx := round(newy);
    int_result.cx := round(newx);
    intr($10,int_result);
  end

  else while counter < dx do begin  {x will be incremented by 1}
    counter := counter + 1.0;
    newx := newx + xmult;
    newy := newy + ddy;
    int_result.ah := $C;
    int_result.bh := b_page;  {active page}
    int_result.al := b_color;
    int_result.dx := round(newy);
    int_result.cx := round(newx);
    intr($10,int_result);
  end;
end;

procedure plot(x,y : integer; col : byte);

var regs:registers;

begin
 regs.ah:=$0C;
 regs.bh:=$00;
 regs.al:=col;
 regs.cx:=x;
 regs.dx:=y;
 intr($10,regs);
end;

PROCEDURE switch(VAR first, second : INTEGER);
{Included here to help out circle has no real use for anything else}

VAR
   temp : INTEGER;
BEGIN
   temp := first;
   first := second;
   second := temp
END;


PROCEDURE circle( cx, cy, radius : INTEGER; col : byte);
VAR
   a, af, b, bf, target, r2 : INTEGER;
BEGIN
    target := 0;   a := radius;   b := 0;   r2 := sqr(radius);
    WHILE a >= b DO
       BEGIN
          b := ROUND(sqrt(r2 - sqr(a))); {**** Use Isqrt(r2 - sqr(a)) here
                                         if you do not have the 8087 chip.}
          switch( target, b);
          WHILE b < target DO {**** Inner loop takes care of straight lines
                                      at cardinal points.}
             BEGIN
                {**** Put in aspect correction and make use of the symmetry
                    of a circle by plotting 8 points for each calculation.}
                af := 120*a DIV 100;   bf := 120*b DIV 100;
                plot(cx + af, cy + b,col);  plot(cx + bf, cy + a,col);
                plot(cx - af, cy + b,col);  plot(cx - bf, cy + a,col);
                plot(cx - af, cy - b,col);  plot(cx - bf, cy - a,col);
                plot(cx + af, cy - b,col);  plot(cx + bf, cy - a,col);
                b := b + 1;
             END;
          a := a - 1;
       END
END;
