/**** nasm2hdr.c ***** s_dubrovich@yahoo.com
* init:  7-16-05  7:51:09 am
* last:  7-17-05  7:41:31 pm
* final review:  7-30-10  7:58:26 pm
* convert info in a nasm .MAP file
* into a valid CP/M-86 .CMD Header record
* so that nasm can be used for assembly.
* The resultant .BIN file is a binary byte
* record of 80h bytes in the form of a
* proper Header Record to be prepended to 
* the target .BIN file produce by nasm
*  -nasm sections-- the default .text is ignored
* don't put stuff in that section name. Section
* names must be same as DRI's; cseg,dseg,eseg,sseg.
* Also X1,X2,X3,X4 - however these four can only
* hold RS data, like .BSS sections, because cpm86
* loader reserves only their virtual size, but
* provides a ptr to them in DS:page zero.
* * * * * * * * * * * * * * * * * * * * * */
/**********************************************
 Compiled with mix software PowerC.
 also should compile as is with TC 2.01.
 ????????.HDR gets prepended to your nasm file
 ????????.TXT shows which lines were converted
**********************************************/
/***********************************
* .CMD Header Form, 128 byte Record.
* GD#1..4; Code, Data, Extra, Stack
* GD#5..8; X1, X2, X3, X4
* GD Format: G-Form,G-Length,A-base,G-min,G-max
*   8bit  G-Form xxxxnnnnb nnnn=G-type
*     1..4; code,data,extra,stack
*     5..8; X1..X4 Auxiliary Groups
*     9     Shared Code Group, N/A under cpm86
*     10..14; Unused, but reserved. for what?
*     15    Escape Codes for Additional types,
*           say Prot. Mode Descriptors.;-)
*   16bit G-Length; number of paragraphs in Grp.
*   16bit A-Base; defines a fixed load segment.
*	(not supported in this version)
*   16bit G-Min; defines minimum memory.
*	(this version forces G-Min==G-Length
*   16bit G-Max; defines maximum memory.
*       (not supported, AFAICT not Req'd)
*   AFAICT only G-Form & G-Length are req'd.
*   CPM.SYS uses A-Base==0051h, the system's
*    absolute loading segment.
*
- NASM Map file ---------------------------------------------------------------

Source file:  segm_cpm.asm
Output file:  segm_cpm

-- Program origin -------------------------------------------------------------

00000000

-- Sections (summary) ---------------------------------------------------------

Vstart    Start     Stop      Length    Class     Name
00000000  00000000  00000000  00000000  progbits  .text
00000000  00000000  00000002  00000002  progbits  .cseg
00000010  00000010  00000020  00000010  progbits  .dseg
00000020  00000020  00000060  00000040  progbits  .sseg
00000060  00000060  00000080  00000020  progbits  .eseg
00000080  00000080  000000A0  00000020  progbits  .x1
000000A0  000000A0  000000C0  00000020  progbits  .x2
000000C0  000000C0  000000E0  00000020  progbits  .x3
000000E0  000000E0  00000200  00000120  progbits  .x4
*                             |
123456789012345678901234567890123456789012345678901234567890
*
***********************/

#include <stdio.h>  /** "c:\powerc\stdio.h" **/
#include <stdlib.h> /** for convert() **/
#define BUFSIZE 81

main()
{
    FILE  *input_file, *output_file,*bin_file;

   union {  /** map descriptor field over 80h byte header record **/
    char header[128];
    struct Grp_Desc { /** Grp Descriptor **/
	char cgform;int cglen;int cabase;int cgmin;int cgmax;
	char dgform;int dglen;int dabase;int dgmin;int dgmax;
	char egform;int eglen;int eabase;int egmin;int egmax;
	char sgform;int sglen;int sabase;int sgmin;int sgmax;
	char x1gform;int x1glen;int x1abase;int x1gmin;int x1gmax;
	char x2gform;int x2glen;int x2abase;int x2gmin;int x2gmax;
	char x3gform;int x3glen;int x3abase;int x3gmin;int x3gmax;
	char x4gform;int x4glen;int x4abase;int x4gmin;int x4gmax;
	} hdr;
     }uni_hdr; /** end of union **/

    /***/
    size_t gd_len; /** struc sizes for data writes **/
    size_t hdr_len;
    /***/

    char  input_name[15], output_name[15]={"        .TXT"};
    char  output_bin[15]={"        .HDR"};
    char  fchr, lnbuffer[BUFSIZE];
    int   lncnt=0,lncnt2=0,ndx,lnndx;

	/** assure null fields in header **/
    for (ndx=0;ndx<128;ndx++) uni_hdr.header[ndx]=0; ndx=0;

    puts("*** NASM .MAP to CP/M-86 Header Record Conversion Program ***");

    printf("Enter the name of the input file  : ");
    scanf("%s", input_name);

    for (ndx=0;ndx<8;ndx++) {
	if ((fchr=input_name[ndx])=='.') break;
	else output_bin[ndx]=output_name[ndx]=fchr;
	}

    input_file = fopen(input_name, "r");
    if (input_file == NULL) {
        puts("*** Can't open input file ***");
        exit(0);
    }

    output_file = fopen(output_name, "w");
    if (output_file == NULL) {
        puts("*** Can't open output file ***");
        exit(0);
    }

    bin_file = fopen(output_bin, "wb");
    if (output_bin == NULL) {
        puts("!! Can't open output BIN file !!");
	exit(0);
    }

    while (fgets(lnbuffer,BUFSIZE,input_file) != NULL) {
	lncnt++;
        fputs(lnbuffer, stdout);
          /**process chng frm str to binary**/
          /* search linebuffer for group desc name */
	if (lncnt>14) { /** 1..14 lines na thru empty .text **/
	  if (lnbuffer[0]=='\n') break; /*trap empty ln*/
          lnndx=51;		/*lnbuffer[51]->section name*/
	  fchr=lnbuffer[lnndx]; /*lnbuffer[30]->section length*/
	  if (fchr=='c') {puts("CSEG Found");uni_hdr.hdr.cgform=1;
     uni_hdr.hdr.cgmin=uni_hdr.hdr.cglen=convert(&lnbuffer[30]);}
	  if (fchr=='d') {puts("DSEG Found");uni_hdr.hdr.dgform=2;
     uni_hdr.hdr.dgmin=uni_hdr.hdr.dglen=convert(&lnbuffer[30]);}
	  if (fchr=='e') {puts("ESEG Found");uni_hdr.hdr.egform=3;
     uni_hdr.hdr.egmin=uni_hdr.hdr.eglen=convert(&lnbuffer[30]);}
	  if (fchr=='s') {puts("SSEG Found");uni_hdr.hdr.sgform=4;
     uni_hdr.hdr.sgmin=uni_hdr.hdr.sglen=convert(&lnbuffer[30]);}
	  fchr=lnbuffer[lnndx+1];
	  if (fchr=='1') {puts("X1 Found");uni_hdr.hdr.x1gform=5;
		uni_hdr.hdr.x1glen=convert(&lnbuffer[30]);}
	  if (fchr=='2') {puts("X2 Found");uni_hdr.hdr.x2gform=6;
		uni_hdr.hdr.x2glen=convert(&lnbuffer[30]);}
	  if (fchr=='3') {puts("X3 Found");uni_hdr.hdr.x3gform=7;
		uni_hdr.hdr.x3glen=convert(&lnbuffer[30]);}
	  if (fchr=='4') {puts("X4 Found");uni_hdr.hdr.x4gform=8;
		uni_hdr.hdr.x4glen=convert(&lnbuffer[30]);}

/** Str output to a test .TXT shows which lines converted **/
          fputs(lnbuffer, output_file);
          lncnt2++;
	}/**lncnt**/

    }/**wh**/
	
  /** output struct to bin file **/
    gd_len=sizeof uni_hdr.hdr;
    hdr_len=sizeof uni_hdr.header;
    printf("Sizeof Grp Descriptor (9 is correct) : %d\n",gd_len/8);
    fwrite(&uni_hdr.header, hdr_len, 1, bin_file);
    printf("Number of lines in the input %s file  : %d\n",input_name,lncnt);
    printf("Number of lines converted, see %s outfile : %d\n",output_name,lncnt2);
    printf("Header Record put to file: %s\n",output_bin);
} /** eomain **/

/***--*** Subroutines ***--***/

/*** Convert ASCII String of numbers to Int Binary Val ***/
/** req's stdlib.h, 8 hex digits, need to prepend 0X?,no **/

int convert (char *numbstr) /** addr of str is passed to convert **/
{  int numb;long lnumb;

   lnumb=strtol(numbstr,NULL,16);
   numb=(int)lnumb;		/** recast long to int **/
   if ((numb & 15)>0) {numb=numb>>4;numb++;} /** round up **/
	else numb=numb>>4; /** make val a 16 byte page val **/
   return numb;
}

/*** eo nasm2hdr.c ***/
