@echo off
rem  MAKEFILE.BAT
rem
rem  Generates a CP/M-86 executable from NASM source code
rem  under DOS.
rem
rem  Syntax: MAKEFILE file_name (with no extension)
rem
rem  ----------------------------------------------------
rem
rem  First, we assemble the ASM file with NASM.
cls
echo.
echo Assembling %1.ASM
echo.
nasm -f bin %1.asm -o %1.bin -l %1.lst
rem
rem  Next, we generate a CP/M-86 header record file
rem  from the NASM .MAP file, using NASM2HDR.EXE.
rem
echo.
echo Creating CP/M-86 header file %1.HDR
echo.
echo %1.map >mapfile.txt
nasm2hdr.exe <mapfile.txt
rem
rem  Finally, we prepend the .HDR file to the NASM .BIN file
rem  to create the CP/M-86 executable .CMD file.
rem
echo.
echo Generating CP/M-86 executable %1.CMD.
echo.
copy /b %1.hdr+%1.bin /b %1.cmd >nul
del mapfile.txt >nul
rem
echo.
echo Process complete.
echo.
echo.
