CONST PendingKey : BYTE = 0;

TYPE Registers = Record
                   CASE Integer Of
                      1 : (AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : Integer);
                      2 : (AL,AH,BL,BH,CL,CH,DL,DH : Byte);
                   END;

FUNCTION ReadKey : Char;
VAR Regs : Registers;
BEGIN
 IF PendingKey<>0 THEN BEGIN
  ReadKey:=CHR(PendingKey);
  PendingKey:=0;
 END
ELSE BEGIN
  Regs.AH:=0;
  INTR($16,Regs);
  IF Regs.AL=0 THEN PendingKey:=Regs.AH;
  ReadKey:=CHR(Regs.AL);
  END;
END;

