Program SmallFastBrot;

{$I READKEY.INC}        { For Readkey Routine }
{$I mandel1.inf}        { Obtain Mandelbrot Data }

Const Colours=255;      { Number of colors to be on the image. }
      Width=80;         { Width of the image. }
      Height=50;        { Height of the image. }

Type Palette=Array[0..767] of Byte;  { MCGA/VGA palette type }

Var XPos,YPos:Integer;

{ Sets the desired video mode (13h) }
Procedure SetVideoMode(VideoMode:Byte);
BEGIN
Inline(
  $31/$C0/               {  xor ax,ax                 ; BIOS Function 00h: Set Video Mode.   }
  $8A/$86/>VIDEOMODE/    {  mov al,>VideoMode [BP]    ; Desired Video Mode.                  }
  $CD/$10);              {  int $10}
End;

{Creates a palette: Black --> red --> yellow                      }

Procedure MakePalette;
Var CPal:Palette;
    i:Byte;

  {Sets the palette.                                              }
  Procedure SetPalette(Pal:Palette);
  BEGIN
  Inline(
    $06/                   {    push es}
    $B8/$12/$10/           {    mov ax,$1012            ; BIOS function 10h, subfunction 12h.  }
    $31/$DB/               {    xor bx,bx               ; first color register.                }
    $B9/$20/$00/           {    mov cx,$20              ; number of color registers.           }
    $C4/$96/>PAL/          {    les dx,>Pal [BP]        ; ES:DX Segment:Offset of color table. }
    $CD/$10/               {    Int $10}
    $07);                  {    pop es}
  End;

Begin
  For i:=0 to 15 do
  Begin
    CPal[3*i]:=4*i+3; CPal[3*i+1]:=0; CPal[3*i+2]:=0;
    CPal[3*i+48]:=63; CPal[3*i+49]:=4*i+3; CPal[3*i+50]:=0;
  End;
   SetPalette(CPal);
End;

{Draws a Plot of the desired color on screen.                     }

Procedure DrawPixel(XPos,YPos:Integer; PlotColour:Byte);
Begin
  Mem[$A000:YPos*320+XPos]:=PlotColour;
End;

VAR dummy:char;
    count:integer;
    border : byte;

Begin
  write(chr(27)+'0'); { CP/M-86 terminal command turn off status bar }
  setvideomode(3);
  write(chr(27)+'n'); { CP/M-86 terminal command turn off text cursor }
  gotoxy(14,8); writeln('ͻ');
  border:=9;
  repeat
   gotoxy(14,border);
   write('');
   gotoxy(64,border);
   write('');
   border:=succ(border);
  until border=17;
  gotoxy(14,17); writeln('ͼ');
  gotoxy(22,10); Writeln('Small Fast Brot for Turbo Pascal 3.0');
  gotoxy(32,11); Writeln('By Ross Simpson.');
  gotoxy(16,13); Writeln('Based on Program to draw Fractals of Mandelbrot.');
  gotoxy(26,14); Writeln('Written by Miguel Martnez. ');
  gotoxy(26,16); Writeln('Press any key to continue...');

  If ReadKey=#0 Then dummy:=ReadKey;   { Skip double codes. }

  SetVideoMode(19);             { Set 320x200x256 graphics mode. }
  {MakePalette;}  { <- Uncomment & Compile for Original Palette }
  count:=0;
  For YPos:=0 to (Height-1) do
  For XPos:=0 to (Width-1) do
   begin
    DrawPixel(120+XPos,75+YPos,colorarry[count]);
    count:=succ(count);
   end;
  dummy:=ReadKey;
  SetVideoMode(3); { Restore text mode. }
  write(chr(27)+'1'); { Restore CP/M-86 Status Bar }
  write(chr(27)+'m'); { Restore CP/M-86 Text Cursor }
End.