	page	,132

;------
; CVVPREP.ASM - version 1.0
;
; Date   : 17Jun2001
; Author : Freek Heite
; Email  : fheite@knoware.nl
;
;------
;
; CVV for CP/M-86.
;
; The CVV software package enables "CP/M-86 for the IBM PC and IBM PC XT
; Version 1.1" to use up to 120 MB of harddisk storage, subdivided in chunks
; of 8 MB each, the so-called CVV's or "CP/M Virtual Volumes".

; In this program, "CP/M-86" is used as a shorthand notation for 
; "CP/M-86 for the IBM PC and IBM PC XT  Version 1.1", which is
; "Copyright (C) 1983, Digital Research".


;============== MASM 5.1 prolog for a .COM file =======================

tgbprep	segment para public 'code'
		assume	cs:tgbprep
		assume	ds:tgbprep
		assume	es:nothing

		org	100h
r0000:
		jmp	r0100

;----------------------------------------------------------------------

;Layout of the sectors within the CVV partition,
;sectors relative to the first sector of the partition:

;0: boot code (only telling the user that this partition cannot be booted)
;1               : not used
;2               : not used
;3               : virtual volume parameters
;4...63          : not used (room for additional boot code)
;65...16448      : 1st 8 MB virtual volume
;16449...32832   : 2nd 8 MB virtual volume
;<repeat 13 times>
;nnnnn...nnnnn   : 15th 8 MB virtual volume
;nnnnn and higher: not used

;----------------------------------------------------------------------

;Data for sector 0 of the CVV partition: only a boot error message.
;
;Harddisk and diskette boot code normally run at 0000:7C00h; the stack
;starts just below 0000:7C00h.

s0buf	equ	$

	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	cli
	mov	sp,0
	mov	ss,sp
	mov	sp,7c00h
	sti

;welcome

	mov	si,offset mb001 - offset s0buf + 7c00h
	call	L7D2C

;wait for a keypress

	xor	ah,ah
	int	16h

;re-IPL the system

	int	19h

; display ASCIZ-string at DS:SI

L7D2C:	
	lodsb
	or	al,al		;string terminator byte?
	jz	L7D52		;yes, done
	mov	ah,0eh		;no, write character in TTY mode
	mov	bl,0ffh
	int	10h
	jmp	short L7D2C	;prepare for next character
L7D52:	
	ret

mb001	db	0dh,0ah,0ah,0ah
	db	'You are booting from a harddisk partition with '
	db	'CP/M-86 Virtual Volumes'
	db	0dh,0ah
	db	'for "CP/M-86 for the '
	db	'IBM PC and PC XT version 1.1".'
	db	0dh,0ah,0dh,0ah
	db	'Sorry, but you cannot boot CP/M-86 from this partition.'
	db	0dh,0ah,0dh,0ah
	db	'Please insert a bootable diskette in your A: drive.'
	db	0dh,0ah
	db	'Then, '
	db	'press any key to boot your system from that diskette.'
	db	0dh,0ah,0dh,0ah
	db	0

	org	s0buf+510
	db	055h,0aah		;indicate a bootable partition

;----------------------------------------------------------------------

;buffer for the master boot record (head 0, cylinder 0, sector 1)

mbrbuf	db	512 dup(?)

peTable	equ	mbrbuf + 01beh		;start of partition table

;Format of a partition table entry (MS-DOS 5.0 ... 6.2).
;There are four PARTENTRY's, at 01BEh...01FDh in absolute sector 0.
;Primary partitions end, but not always start, on a cylinder boundary.

;PARTENTRY	STRUC		;4 entries, 16 bytes each
;peBootable	db	?	;80h = bootable, 00h = nonbootable
;peBeginHead	db	?	;beginning head
;peBeginSector	db	?	;bits 5...0: beginning sector
;				;bits 7...6: beginning cylinder bits 9...8
;peBeginCylinder	db	?	;beginning cylinder bits 7...0
;peFileSystem	db	?	;name of file system
;
;peEndHead	db	?	;ending head
;peEndSector	db	?	;bits 5...0: ending sector
;				;bits 7...6: ending cylinder bits 9...8
;peEndCylinder	db	?	;ending cylinder bits 7...0
;peStartSector	dd	?	;starting sector (relative to beg. of disk)
;peSectors	dd	?	;number of sectors in partition
;PARTENTRY	ENDS

;----------------------------------------------------------------------

;data for sector 3 of the CVV partition: the virtual volume parameter table

		align	2

s3buf		equ	$

s3chk		dw	0	;16 bit checksum (adding all 256 words
				; in this sector should produce zero)
				;This field must be on a word boundary!

tgbvers		equ	$	;version 1.0
tgbverl		db	0	;minor version
tgbverh		db	1	;major version

		db	'CPM86CVV'

s3part		equ	$	;a copy of our partition table entry

s3Bootable	db	?	;80h = bootable, 00h = nonbootable
s3BeginHead	db	?	;beginning head
s3BeginSector	db	?	;bits 5...0: beginning sector
				;bits 7...6: beginning cylinder bits 9...8
s3BeginCylinder	db	?	;beginning cylinder bits 7...0
s3FileSystem	db	?	;name of file system

s3EndHead	db	?	;ending head
s3EndSector	db	?	;bits 5...0: ending sector
				;bits 7...6: ending cylinder bits 9...8
s3EndCylinder	db	?	;ending cylinder bits 7...0
s3StartSector	dd	?	;starting sector (relative to beg. of disk)
s3Sectors	dd	?	;number of sectors in partition

;more data

s3last		dd	?	;last sector of the partition (zero-based,
				; relative to beginning of disk)

s3numv		dw	?	;number of virtual volumes in the CVV
				; partition: 1...15

s3sc		dw	?	;CVV partition start cylinder 0...1023
s3sh		db	?	;CVV partition start head 0...255
s3ss		db	?	;CVV partition start sector 1...63

s3ec		dw	?	;CVV partition end cylinder 0...1023
s3eh		db	?	;CVV partition max head = end head 0...255
s3es		db	?	;CVV partition max sector = end sector 1...63

s3res		dw	64	;number of reserved sectors at the start
				; of the CVV partition

s3spc		dw	?	;number of sectors per cylinder
				; = (s3eh+1) * s3es
				; = 0...2^14 -1 = 0...16383 = 0...8 MB

s3sph		db	?	;number of sectors per head
				; = s3es
				; = 0...2^6 -1 = 0...63 = 0...31.5 KB

s3spv		dw	16384	;number of sectors per virtual volume
				; = 16384 = 8 MB

		db	512-($-s3buf) dup('3')	;fill up to 512 bytes

;----------------------------------------------------------------------

;32 bytes CP/M directory entry for an empty file. This is written to the
;first 32 bytes of each virtual volume directory as a "volume label",
;with file name CVVOLUME.n01...CVVOLUME.n15 where n is the number of the
;harddisk where the virtual volumes are located (1 or 2).

slabel		db	0		;user number
		db	'CVVOLUME'	;file name
FT1		db	'1'		;file type
FT2		db	'0'		;file type
FT3		db	'0'		;file type
		db	0		;low byte extent counter (0...9)
		db	0		;reserved
		db	0		;high byte extent counter (0)
		db	0		;record count for this extent:
		db	16 dup(0)	;numbers of blocks allocated to file

;----------------------------------------------------------------------

;512 bytes of 0E5h, for initializing reserved, unused and directory sectors

se5buf	equ	$
	db	512 dup(0e5h)

;----------------------------------------------------------------------

mcrlf	db	0dh,0ah,'$'

w_cyl	dw	0
w_head	db	0
w_sec	db	0

w_bx	dw	?
w_hd	db	?		;80h/81h = first/second harddisk
w_bd	db	0		;0/1 = no/yes CVV partition already present
w_verb	db	0		;0/1 = no/yes verbose output

w_curd	db	0		;current drive

;----------------------------------------------------------------------

m000	db	0dh,0ah
	db	'CVV  - Harddisk driver for "CP/M-86 for the '
	db	'IBM PC and IBM PC XT, version 1.1"' 
	db	0dh,0ah
	db	'       CP/M Virtual Volumes - version 1.0 '
	db	'- 17Jun2001 - by Freek Heite.'
	db	0dh,0ah
	db	0dh,0ah,'$'

m001	db	'M001 - Primary partitions on your first harddisk '
	db	'(1 MB is 1048576 bytes):'
	db	0dh,0ah,'$'

m002	db	'M002 - Primary partitions on your second harddisk '
	db	'(1 MB is 1048576 bytes):'
	db	0dh,0ah,'$'

m003	db	0dh,0ah
	db	'M003 - Format which partition (1...4) on disk '
m003a	db	'x for CP/M-86 virtual volumes?'
	db	0dh,0ah
	db	'       WARNING: ALL EXISTING DATA ON THAT PARTITION '
	db	'WILL BE LOST!'
	db	0dh,0ah,'$'

m004	db	'       #'
m004a	db	'n. Start: cylinder='
m004b	db	'n    head='
m004c	db	'n   sector='
m004d	db	'n    ; first sector ='
m004e	db	'n         '
	db	0dh,0ah
	db	'           End  : cylinder='
m004f	db	'n    head='
m004g	db	'n   sector='
m004h	db	'n    ; total sectors='
m004i	db	'n         '
	db	0dh,0ah
	db	'           Size : '
m004j	db	'n          MB                      ; last  sector ='
m004k	db	'n         '
	db	0dh,0ah
	db	'           Type : '
m004l	db	'xxh='
	db	'$'

;Layout of m004:
;     #n. Start: cylinder=nnnn head=nnn sector=nnn; start sector =nnnnnnnnnn
;         End  : cylinder=nnnn head=nnn sector=nnn; total sectors=nnnnnnnnnn
;         Size : nnnnnnnnnn MB (1 MB is 1024 * 1024 is 1048576 bytes)
;         Type : xxh=xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

m005	db	'M005 - I/O error reading master boot record on harddisk '
m005a	db	'n.'
	db	0dh,0ah,'$'

m006	db	'M006 - Program aborted, no CP/M-86 disk made.'
	db	0dh,0ah,'$'

m007	db	'M007 - Sorry, the size of partition #'
m007a	db	'x is zero.'
	db	0dh,0ah,'$'

M008	db	'M008 - CP/M-86 virtual volume(s) created. '
	db	'Capacity is n MB (nnnnn KB).'
	db	0dh,0ah
	db	'       The number of cylinders (tracks) is nnn,'
	db	0dh,0ah
	db	'       the number of heads is nnn,'
	db	0dh,0ah
	db	'       the number of sectors per track is nnn.'
	db	0dh,0ah,'$'

m009	db	'M009 - Do you really want to format this partition #'
m009a	db	'x on harddisk '
m009b	db	'x (Y/N)?'
	db	0dh,0ah
	db	'       WARNING: ALL EXISTING DATA ON THAT PARTITION '
	db	'WILL BE LOST!'
	db	0dh,0ah,'$'

m010	db	0dh,0ah
	db	'M010 - Type C to format partition #'
m010a	db	'x on harddisk '
m010b	db	'x,'
	db	0dh,0ah
	db	'       or any other key to stop now.'
	db	0dh,0ah
	db	'       WARNING: ALL EXISTING DATA ON THAT PARTITION '
	db	'WILL BE LOST!'
	db	0dh,0ah,'$'

m011	db	'M011 - Sorry, partition #'
m011a	db	'x is too small; it should be at least 16448 sectors.'
	db	0dh,0ah,'$'

m012	db	0dh,0ah
	db	'M012 - This partition #'
m012a	db	'x will hold '
m012b	db	'n  CP/M-86 Virtual Volume(s),'
	db	0dh,0ah
	db	'       leaving ca. '
m012c	db	'n     MB of this partition unused (wasted).'
	db	0dh,0ah,0dh,0ah,'$'

m013	db	0dh,0ah
	db	'M013 - You have selected the following partition '
	db	'to be formatted:'
	db	0dh,0ah,'$'

m014	db	'M014 - I/O error writing master boot record on harddisk '
m014a	db	'n.'
	db	0dh,0ah,'$'

m015	db	0dh,0ah
	db	'M015 - About to update the partition table '
	db	'on the master boot record.'
	db	0dh,0ah,'$'

m016	db	'M016 - About to write virtual volume parameters to sector '
	db	'3 of the partition.'
	db	0dh,0ah,'$'

m017	db	'M017 - About to write a boot error message to sector '
	db	'0 of the partition.'
	db	0dh,0ah,'$'

m018	db	'M018 - About to clear reserved sectors 1 and '
	db	'2 of the partition.'
	db	0dh,0ah,'$'

m019	db	'M019 - About to clear reserved sectors 4...'
m019a	db	'n  of the partition.'
	db	0dh,0ah,'$'

m020	db	'M020 - About to clear the CP/M-86 directory for '
	db	'virtual volume #'
m020a	db	'n .'
	db	0dh,0ah,'$'

;M021 - write error: status=xxh harddisk=8xh cylinder=nnnnn head=nnn sector=nnn

m021	db	'M021 - '
	db	'write error: status='
m021a	db	'xxh harddisk='
m021b	db	'xxh cylinder='
m021c	db	'n     head='
m021d	db	'n   sector='
m021e	db	'n  '
	db	0dh,0ah,'$'

;M022 - Info: block=nnnnnnnnnn => cylinder=nnnnn head=nnn sector=nnn
;M023 - Range error: block=nnnnnnnnnn => cylinder=nnnnn head=nnn sector=nnn

m022	db	'M022 - Info: $'
m023	db	'M023 - Range error: $'

m024	db	'abs. sector='
m024a	db	'nnnnnnnnnn => cylinder='
m024b	db	'n     head='
m024c	db	'n   sector='
m024d	db	'n  '
	db	0dh,0ah,'$'

m025	db	'M025 - Partition succesfully formatted; '
m025a	db	'n  CP/M-86 virtual volume(s) created.'
	db	0dh,0ah,'$'

m026	db	'M026 - Premature end of program.'
	db	0dh,0ah,'$'

m027	db	'M027 - Sorry, there already is a CP/M '
	db	'Virtual Volumes partition on harddisk '
m027a	db	'1.'
	db	0dh,0ah,'$'

m028	db	'M028 - Sorry, partition #'
m028a	db	'x does not start and end below cylinder 1023.'
	db	0dh,0ah,'$'

;----------------------------------------------------------------------

STAKSIZ	equ	256			;size of local stack in words
endstak	equ	$
	db	STAKSIZ dup('fh')	;local stack
mystack	equ	$

;----------------------------------------------------------------------

r0100:
	cli
	mov	sp,cs
	mov	ss,sp			;switch to
	mov	sp,offset mystack	; local stack
	sti

	mov	dx,offset m000		;show intro
	call	dspmsg

	mov	cl,25			;return current disk
	int	0e0h
	mov	w_curd,al		;save it

	mov	m003a,'1'
	mov	m005a,'1'
	mov	m009b,'1'
	mov	m010b,'1'
	mov	m014a,'1'
	mov	m027a,'1'

	mov	w_hd,80h
	mov	dx,offset m001		;use first harddisk

	cmp	ds:[5dh],byte ptr '2'	;option '2' on command line?
	jnz	r0105			;no, ignore anything else

	mov	m003a,'2'
	mov	m005a,'2'
	mov	m009b,'2'
	mov	m010b,'2'
	mov	m014a,'2'
	mov	m027a,'2'

	mov	w_hd,81h
	inc	FT1

	mov	dx,offset m002		;use second harddisk
r0105:
	call	dspmsg

;read master boot record (head 0, cylinder 0, sector 1)

	mov	ah,2
	mov	al,1
	mov	ch,0
	mov	cl,1
	mov	dh,0
	mov	dl,w_hd			;80h/81h
	mov	bx,offset mbrbuf
	push	cs
	pop	es
	int	13h			;read absolute sector zero
	jnc	r0110			;jump if OK

	mov	dx,offset m005		;read error
	call	dspmsg
	jmp	stoprun

;----------------------------------------------------------------------
r0110:

;show information for primary partitions 1...4

	mov	al,1			;start with partition # 1
r0120:
	push	ax
	call	calcpar			;perform important calculations, then
					; show details for partition # in AL
	pop	ax

	inc	al
	cmp	al,4			;more partitions to show?
	jbe	r0120			;yes

;	jmp	r0130			;## uncomment to allow re-formatting
					;  an already existing CVV partition

	cmp	w_bd,0			;CVV partition already present?
	jz	r0130			;no

	mov	dx,offset m027		;yes, abort
	call	dspmsg
	jmp	stoprun

;which one to format?

r0130:
	mov	dx,offset m003		;ask for a number '1'...'4'
	call	dspmsg

r0140:
;	mov	ah,8			;no echo; checks ctrl-c and ctrl-break
;	int	21h

	push	es
	mov	dl,0ffh
	mov	cl,6
	int	0e0h
	pop	es

	cmp	al,0			;key pressed
	jz	r0140			;no

	cmp	al,3			;control-C?
	jne	r0141			;no
	jmp	stoprun			;yes

r0141:
	cmp	al,'1'			;check for keys
	jb	r0140			; '1' ... '4'
	cmp	al,'4'
	ja	r0140
	
	mov	m010a,al		;ASCII partition number
	mov	m009a,al
	mov	m007a,al
	mov	m011a,al
	mov	m012a,al
	mov	m028a,al

	sub	al,'0'			;from ASCII to binary 1...4

	push	ax
	mov	dx,offset m013		;header for selected partition details
	call	dspmsg
	pop	ax

	push	ax
	call	calcpar			;perform important calculations, then
					; show details for partition # in AL
	pop	ax

	dec	al			;0...3
	cbw				;from byte AL to word AX

	mov	cl,4			;AX := AX * size of PARTENTRY (= 16)
	shl	ax,cl			;0...48

	mov	bx,offset peTable
	add	bx,ax			;save BX = offset of selected
	mov	[w_bx],bx		; partition table entry

;The partition must start and end at a cylinder number less than 1023.

;"Placeholder" entries in the partition table have both their starting and
;ending cylinder numbers equal to 1023, only the table fields "starting sector"
;and "number of sectors" reflect the real location and size of the partition.
;Such partitions are not fully accessible with the standard C/H/S calls to
;INT 13h as used by our driver. Instead, they require INT 13h extensions like
;LBA addressing modes to access (the part of) the data that lies above 8 GB.
;So we cannot format such a partition.

	mov	al,[bx][3]		;C bits 7...0
	mov	ah,[bx][2]		;C bits 9...8 are in bits 7...6
	mov	cl,6
	shr	ah,cl			;C bits 9...8 now in bits 1...0

	cmp	ax,1023			;start cylinder below 1023?
	jnb	r0143			;no, error

;The partition must end at a cylinder number less than 1023

	mov	al,[bx][7]		;C bits 7...0
	mov	ah,[bx][6]		;C bits 9...8 are in bits 7...6
	mov	cl,6
	shr	ah,cl			;C bits 9...8 now in bits 1...0

	cmp	ax,1023			;end cylinder below 1023?
	jb	r0144			;yes, OK

r0143:
	mov	dx,offset m028		;probably a "placeholder" entry
	call	dspmsg			; in the partition table,
	jmp	stoprun			;  do not accept this partition.

;The size of the partition should not be zero

r0144:
	mov	ax,[bx][12]		;total number of sectors
	mov	dx,[bx][14]		; in DX:AX

	cmp	dx,0			;high word DX zero?
	jnz	r0150			;no, partition is large enough
	cmp	ax,0			;low word AX zero?
	jnz	r0145			;no, go check for minimum size

	mov	dx,offset m007		;yes, size of partition is zero
	call	dspmsg
	jmp	stoprun

;The partition size should be at least 16448 sectors:
;- 16384 sectors of 512 bytes (= 2^14 sectors = 8 MB) for data
;- plus 64 reserved sectors of 512 bytes

r0145:
	mov	cx,16384		;CX := minimum
	add	cx,s3res		; partition size

	cmp	ax,cx			;high word DX is 0, so only check AX
	jae	r0150

	mov	dx,offset m011
	call	dspmsg
	jmp	stoprun

;Calculate the maximum number of virtual volumes possible. We need:
;- 64 reserved sectors for the whole partition (incl. boot sector)
;- 16384 sectors = 2^14 sectors = 8 MB for each virtual volume

r0150:
	sub	ax,s3res		;subtract the number of
	sbb	dx,0			; reserved sectors

	mov	cx,14			;divide by the number of sectors per
					; virtual volume = 16384 = 2^14
r0152:
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	loop	r0152

	cmp	dx,0			;more than 65535 virtual volumes?
	jnz	r0155			;yes, but we will make only 15

	cmp	ax,15			;more than 15 virtual volumes?
	jb	r0157			;no, we will make 1...14

r0155:
	mov	ax,15			;maximum is 15
r0157:
	mov	s3numv,ax		;actual number of virtual volumes
	mov	si,offset m025a
	call	w2dec

	mov	ax,s3numv
	mov	si,offset m012b
	call	w2dec

;calculate how many MB's will be used for CVV, and the remaining (wasted) MB's

	mov	bx,w_bx			;pointer to partition table entry

	mov	ax,[bx][12]		;total number of sectors
	mov	dx,[bx][14]		; in DX:AX (24-bits value)

	mov	cx,11			;divide by the number of sectors per
					; megabyte = 2048 = 2^11
r0158:
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	loop	r0158

	push	ax			;AX := partition size in MB's
					; (never more than 8192 MB's,
					;  so DX can be ignored now)

	mov	ax,8			;8 MB
	mul	[s3numv]		; per CVV
	inc	ax			;  plus 1 MB for reserved sectors
	mov	bx,ax			;BX = total used MB's

	pop	ax

	sub	ax,bx			;wasted MB's := partition size minus
					; number of MB's used for CVV's
	mov	si,offset m012c
	call	w2dec

	mov	dx,offset m012		;show number of virtual volumes
	call	dspmsg

	mov	dx,offset m009		;do you really want to format Y/N?
	call	dspmsg

r0160:
	push	es
	mov	dl,0ffh
	mov	cl,6
	int	0e0h
	pop	es

	cmp	al,0			;key pressed?
	jz	r0160			;no

	cmp	al,3			;control-C?
	jne	r0161
	jmp	stoprun
r0161:
	cmp	al,'n'
	jne	r0162
	jmp	stoprun			;stop if 'n'
r0162:
	cmp	al,'N'
	jne	r0164
	jmp	stoprun			;stop if 'N'
r0164:
	cmp	al,'y'
	je	r0180			;continue if 'y'
	cmp	al,'Y'
	jne	r0160			;invalid key, try again

r0180:
	mov	dx,offset m010		;type C to format, other key to stop
	call	dspmsg	

r0182:
	push	es
	mov	dl,0ffh
	mov	cl,6
	int	0e0h
	pop	es

	cmp	al,0			;key pressed?
	jz	r0182			;no

	cmp	al,3			;control-C?
	jne	r0185
	jmp	stoprun

r0185:
	cmp	al,'c'
	je	r0200			;continue if 'c'
	cmp	al,'C'
	je	r0200			;continue if 'C'
	jmp	stoprun

;---------------------------------------------------------------------
r0200:

;change partition type in MBR to 0BDh

	mov	dx,offset m015		;about to update MBR
	call	dspmsg

	mov	bx,w_bx
	mov	byte ptr [bx][4],0BDh

;rewrite MBR

	mov	ah,3			;3=write
	mov	al,1
	mov	ch,0
	mov	cl,1
	mov	dh,0
	mov	dl,w_hd			;80h/81h
	mov	bx,offset mbrbuf
	push	cs
	pop	es
	int	13h			;write absolute sector zero
	jnc	r0299			;jump if OK

	mov	dx,offset m014		;write error
	call	dspmsg
	jmp	stoprun
r0299:

;----------------------------------------------------------------------
r0300:

;Fill and write the CVV parameter sector, sector 3

	push	ds
	pop	es

	mov	si,w_bx
	mov	di,offset s3part
	mov	cx,16
	cld
	rep	movsb			;copy our partition table entry

;andere data invullen

	mov	ah,s3es			;max number of sectors one-based
	mov	s3sph,ah		;sectors per head

	mov	al,s3eh			;max number of heads zero-based
	inc	al			;max number of heads one-based
	mul	ah			;
	mov	s3spc,ax		;sectors per cylinder

;calculate checksum of all 256 words in the CVV parameter sector

	mov	ax,0
	mov	[s3chk],ax
	mov	bx,offset s3buf
	mov	cx,256
r0350:
	add	ax,word ptr [bx]
	add	bx,2
	loop	r0350

	neg	ax			;2's complement
	mov	[s3chk],ax		;write the checksum	

;write the data in s3buf to the CVV parameter sector

	mov	dx,offset m016		;about to write parameter sector 3
	call	dspmsg

	push	cs
	pop	es
	mov	bx,offset s3buf
	mov	dx,0
	mov	ax,3			;sector 3 of the CVV partition
	call	int13

;Write a boot sector to the CVV partition

	mov	dx,offset m017
	call	dspmsg

	push	cs
	pop	es
	mov	bx,offset s0buf
	mov	dx,0
	mov	ax,0			;sector 0 of the CVV partition
	call	int13

;----------------------------------------------------------------------

;clear some sectors within the CVV partition with data from se5buf:
;- sector 1 (used by standard CP/M-86 for storing system parameters)
;- sector 2 (probably not used by standard CP/M-86)
;- sectors 4...s3res-1 (reserved for future CVV developments, e.g. bootcode)

r0400:
	mov	dx,offset m018		;about to clear sectors 1 and 2
	call	dspmsg

	push	cs
	pop	es
	mov	bx,offset se5buf
	mov	dx,0
	mov	ax,1			;clear sector 1 in the CVV partition
	call	int13

	inc	ax			;clear sector 2 in the CVV partition
	call	int13

	mov	ax,s3res		;show number of last reserved	
	dec	ax			; sector = s3res -1
	mov	si,offset m019a
	call	b2dec

	mov	dx,offset m019		;about to clear sectors 4...(s3res -1)
	call	dspmsg

	mov	dx,0
	mov	ax,4			;start with sector 4
r0410:
	push	cs
	pop	es
	mov	bx,offset se5buf	;512 bytes of hex 0E5h
	call	int13

	add	ax,1			;note that INC AX doesn't set the carry
	adc	dx,0			;prepare for next sector

;------ EITHER: clear only the reserved sectors

	cmp	ax,s3res		;more to do?
	jb	r0410			;yes

;------ OR: clear all sectors in the CVV partition
;
;	cmp	dx,word ptr s3Sectors+2	;more to do?
;	jne	r0410			;yes
;	cmp	ax,word ptr s3Sectors	;
;	jb	r0410			;yes

;----------------------------------------------------------------------

;Clear the directories of 1...15 virtual volume(s)

r0500:

	mov	dx,0			;the directory of the first virtual
	mov	ax,s3res		; volume starts at relative sector 64

	mov	cx,s3numv		;number of virtual volumes in partition
r0510:
	push	cx

	push	ax
	push	dx

	mov	ax,s3numv		;s3numv +1
	inc	ax			; minus cx
	sub	ax,cx			;  = current virtual volume # 1...15

	push	ax

	mov	si,offset m020a		;show virtual volume #
	call	b2dec

	mov	dx,offset m020		;about to clear directory
	call	dspmsg

	pop	ax

	mov	si,offset FT2		;prepare for 2 digits cvv number
	cmp	ax,10			;current cvv number >= 10?
	jae	r0520			;yes, OK
	mov	si,offset FT3		;no, use a single digit
r0520:
	call	b2dec			;put cvv number into the volume label

	pop	dx
	pop	ax

	mov	cx,128			;now clear 128 directory sectors, for
					; 2048 (or less) directory entries
					;  of 32 bytes each
r0550:
	push	cs
	pop	es
	mov	bx,offset se5buf	;512 bytes of 0E5h

	cmp	cx,128			;first directory sector?
	jne	r0560			;no
	mov	bx,offset slabel	;yes, include volume label

r0560:
	push	cx
	call	int13			;write a sector
	pop	cx

	add	ax,1			;prepare for
	adc	dx,0			; next sector

	loop	r0550			;jump if more directory sectors

	sub	ax,128			;back to the start
	sbb	dx,0			; of the virtual volume

	add	ax,s3spv		;add the size
	adc	dx,0			; of a virtual volume

	pop	cx
	loop	r0510			;jump if more virtual volumes

	mov	dx,offset m025		;all done
	jmp	stopr10

;----------------------------------------------------------------------

stoprun:
	mov	dx,offset m026
stopr10:
	call	dspmsg

	mov	cl,37			;reset drives
	mov	dx,0ffffh		;all drives
	int	0e0h

	mov	cl,14			;select disk
	mov	dl,w_curd
	int	0e0h

	mov	cl,0			;end program
	mov	dl,0			;free our memory
	int	0e0h

;----------------------------------------------------------------------
;Show a partition table entry
;
;On entry: AL = partition number (1...4)
;
;NOTE: This routine also performs some essential calculations before showing
;      the actual partition data. So this routine must always be called.


calcpar:
	mov	m004a,al		;1...4
	add	m004a,30h		;'1'...'4'

;BX := address of partition table entry

	dec	al			;0...3
	cbw
	mov	cl,4			;AX := AX * 16
	shl	ax,cl			;0...48

	mov	bx,offset peTable
	add	bx,ax			;BX = offset of partition table entry

;start cylinder
	mov	al,[bx][3]		;C bits 7...0
	mov	ah,[bx][2]		;C bits 9...8 are in bits 7...6
	mov	cl,6
	shr	ah,cl			;C bits 9...8 now in bits 1...0
	mov	s3sc,ax
	mov	si,offset m004b
	call	w2dec

;start head
	mov	al,[bx][1]		;H
	mov	s3sh,al
	mov	si,offset m004c
	call	b2dec

;start sector
	mov	al,[bx][2]		;S
	and	al,03fh			;bits 5...0
	mov	s3ss,al
	mov	si,offset m004d
	call	b2dec

;end cylinder
	mov	al,[bx][7]		;C bits 7...0
	mov	ah,[bx][6]		;C bits 9...8 are in bits 7...6
	mov	cl,6
	shr	ah,cl			;C bits 9...8 now in bits 1...0
	mov	s3ec,ax
	mov	si,offset m004f
	call	w2dec

;end head
	mov	al,[bx][5]		;H
	mov	s3eh,al
	mov	si,offset m004g
	call	b2dec

;end sector
	mov	al,[bx][6]		;S
	and	al,03fh			;bits 5...0
	mov	s3es,al
	mov	si,offset m004h
	call	b2dec

;sizes
	mov	ax,[bx][8]		;first sector
	mov	dx,[bx][10]
	mov	si,offset m004e

	push	bx
	call	d2dec			;show it
	pop	bx

	mov	ax,[bx][12]		;total number of sectors
	mov	dx,[bx][14]
	mov	si,offset m004i

	push	bx
	call	d2dec			;show it
	pop	bx

	mov	ax,[bx][12]		;number of sectors
	mov	dx,[bx][14]

	cmp	ax,0			;low word number of sectors is zero?
	jnz	calcp03			;no
	cmp	dx,0			;high word also zero?
	jz	calcp05			;yes, last sector is zero

calcp03:
	add	ax,[bx][8]		;add 
	adc	dx,[bx][10]		; start sector
	sub	ax,1			;  minus 1
	sbb	dx,0			;   gives last sector

calcp05:
	mov	word ptr s3last,ax
	mov	word ptr s3last +2,dx

	mov	si,offset m004k
	push	bx
	call	d2dec			;show it
	pop	bx

	mov	al,[bx][4]		;file system
	mov	si,offset m004l
	call	b2hex

;calculate size in MB's

	mov	ax,[bx][12]		;total number of 512 byte sectors
	mov	dx,[bx][14]

	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
					;DX:AX now is size in KB

	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
					;DX:AX now is size in MB
	push	bx

	mov	si,offset m004j
	call	d2dec
;show
	mov	dx,offset m004
	call	dspmsg

	pop	bx
;clear
	mov	word ptr m004b,'  '
	mov	byte ptr m004b+2,' '
	mov	word ptr m004c+1,'  '
	mov	word ptr m004d+1,'  '

	mov	word ptr m004f,'  '
	mov	word ptr m004f+2,' '
	mov	word ptr m004g+1,'  '
	mov	word ptr m004h+1,'  '

;show file system

	mov	al,[bx][4]		;file system, partition type

	cmp	al,0bdh			;CVV partition?
	jne	calcp10			;no
	mov	w_bd,1			;yes
calcp10:
	mov	ah,0
	mov	si,ax
	add	si,si
	add	si,offset ptab_of
	mov	dx,[si]

	call	dspmsg
	mov	dx,offset mcrlf
	call	dspmsg

	ret
;------

;Harddisk partition types (thanks to Paul Schlyter)

ptab_tx	equ	$			;max. 55 characters per line
;		'----+----1----+----2----+----3----+----4----+----5----+'

t00h	db	'unused$'
t01h	db	'FAT12: 0-16 MB, or 0-32679 sectors$'
t02h	db	'Xenix root file system$'
t03h	db	'Xenix /usr file system$'
t04h	db	'FAT16: 16-33 MB, or 32680-65535 sectors$'
t05h	db	'Extended DOS partition up to 8 GB$'
t06h	db	'BIGDOS FAT16 33MB - 4GB; or Compaq DOS 3.31-5.0 > 32MB$'
t07h	db	'OS/2 HPFS, NT NTFS, Advanced Unix, QNX 2.x pre-1988$'
t08h	db	'AIX data, SplitDrive, Commodore DOS, QNX 1.x and 2.x$'
t09h	db	'AIX boot; Coherent; QNX 1.x and 2.x$'
t0ah	db	'OS/2 boot manager; Coherent swap; Unisys OPUS$'
t0bh	db	'FAT32 up to 2047 GB$'
t0ch	db	'FAT32 with INT 13h or LBA extensions$'
t0dh	db	'?$'
t0eh	db	'FAT16: 33 MB - 4 GB with INT 13/LBA extensions$'
t0fh	db	'Extended DOS part. with INT13/LBA ext.; hidden FAT16$'
t10h	db	'?$'
t11h	db	'hidden FAT12$'
t12h	db	'EISA partition; Compaq BIOS config partition$'
t13h	db	'?$'
t14h	db	'ExtendedX DOS partition; hidden FAT16$'
t15h	db	'?$'
t16h	db	'Hidden BIGDOS FAT16$'
t17h	db	'Hidden IFPS or NTFS$'
t18h	db	'AST/Windows swap file (smartsleep partition)$'
t19h	db	'Willowtech Photon COS (Completely Optimized System)$'
t1ah	db	'?$'
t1bh	db	'hidden FAT32$'
t1ch	db	'hidden FAT32 with INT13/LBA extensions$'
t1dh	db	'?$'
t1eh	db	'?$'
t1fh	db	'?$'
t20h	db	'?$'
t21h	db	'?$'
t22h	db	'?$'
t23h	db	'?$'
t24h	db	'NEC DOS 3.x$'
t25h	db	'?$'
t26h	db	'?$'
t27h	db	'?$'
t28h	db	'?$'
t29h	db	'?$'
t2ah	db	'?$'
t2bh	db	'?$'
t2ch	db	'?$'
t2dh	db	'?$'
t2eh	db	'?$'
t2fh	db	'?$'
t30h	db	'?$'
t31h	db	'?$'
t32h	db	'?$'
t33h	db	'?$'
t34h	db	'?$'
t35h	db	'?$'
t36h	db	'?$'
t37h	db	'?$'
t38h	db	'THEOS 3.2, 2 GB partition$'
t39h	db	'THEOS 4, partition spanning multiple disks$'
t3ah	db	'THEOS 4, 4 GB partition$'
t3bh	db	'THEOS 4, extended partition$'
t3ch	db	'PowerQuest Partition Magic reovery partition$'
t3dh	db	'?$'
t3eh	db	'?$'
t3fh	db	'?$'
t40h	db	'Venix 286$'
t41h	db	'Linux; Minix; Personal RISC; PowerPC Ref. boot$'
t42h	db	'Dynamic disk volume; Linux swap; Secure File System$'
t43h	db	'Linux (shared with DR-DOS)$'
t44h	db	'?$'
t45h	db	'Eumel/Elan$'
t46h	db	'Eumel/Elan$'
t47h	db	'Eumel/Elan$'
t48h	db	'Eumel/Elan$'
t49h	db	'?$'
t4ah	db	'?$'
t4bh	db	'?$'
t4ch	db	'?$'
t4dh	db	'QNX 4.x$'
t4eh	db	'QNX 4.x second part$'
t4fh	db	'QNX 4.x third part$'
t50h	db	'Ontrack Disk Manager (older versions)$'
t51h	db	'Ontrack Disk Manager$'
t52h	db	'Linux swap file system; Microport System V/AT; CP/M$'
t53h	db	'Ontrack Disk Manager 6.0$'
t54h	db	'?$'
t55h	db	'EZ-Drive Disk Manager$'
t56h	db	'Golden Bow VFeature Partitioned Volume$'
t57h	db	'DrivePro Disk Manager$'
t58h	db	'?$'
t59h	db	'?$'
t5ah	db	'?$'
t5bh	db	'?$'
t5ch	db	'Priam Edisk Disk Manager$'
t5dh	db	'?$'
t5eh	db	'?$'
t5fh	db	'?$'
t60h	db	'?$'
t61h	db	'SpeedStor Disk Manager$'
t62h	db	'?$'
t63h	db	'Unix System V (SCO, ISC Unix, UnixWare, Mach, GNU HURD)$'
t64h	db	'Novell Netware 2.xx$'
t65h	db	'Novell Netware 3.xx and 4.xx$'
t66h	db	'?$'
t67h	db	'Novell$'
t68h	db	'Novell$'
t69h	db	'Novell$'
t6ah	db	'?$'
t6bh	db	'?$'
t6ch	db	'?$'
t6dh	db	'?$'
t6eh	db	'?$'
t6fh	db	'?$'
t70h	db	'DiscSecure multi-boot$'
t71h	db	'?$'
t72h	db	'?$'
t73h	db	'?$'
t74h	db	'?$'
t75h	db	'IBM PC/IX$'
t76h	db	'?$'
t77h	db	'?$'
t78h	db	'?$'
t79h	db	'?$'
t7ah	db	'?$'
t7bh	db	'?$'
t7ch	db	'?$'
t7dh	db	'?$'
t7eh	db	'?$'
t7fh	db	'?$'
t80h	db	'Minix up to version 1.4a$'
t81h	db	'Minix version 1.4 and up; Mitac Disk Manager$'
t82h	db	'Prime; Solaris x86; Linux swap partition$'
t83h	db	'Linux Ext2 file system$'
t84h	db	'OS/2 hidden C: drive; laptop energy saver partition$'
t85h	db	'Linux extended partition$'
t86h	db	'Legacy NT FAT16 disk$'
t87h	db	'Legacy NT NTFS disk$'
t88h	db	'?$'
t89h	db	'?$'
t8ah	db	'Linux kernel partition for AiR-BOOT$'
t8bh	db	'Legacy NT formatted with FAT32$'
t8ch	db	'Legacy NT with INT13 ext. formatted with FAT32$'
t8dh	db	'?$'
t8eh	db	'Linux logical volume manager$'
t8fh	db	'?$'
t90h	db	'?$'
t91h	db	'?$'
t92h	db	'?$'
t93h	db	'Amoeba$'
t94h	db	'Amoeba bad block table$'
t95h	db	'?$'
t96h	db	'?$'
t97h	db	'?$'
t98h	db	'?$'
t99h	db	'?$'
t9ah	db	'?$'
t9bh	db	'?$'
t9ch	db	'?$'
t9dh	db	'?$'
t9eh	db	'?$'
t9fh	db	'?$'
ta0h	db	'laptop energy saver partition$'
ta1h	db	'?$'
ta2h	db	'?$'
ta3h	db	'?$'
ta4h	db	'?$'
ta5h	db	'BSD/386; 386BSD; NetBSD; FreeBSD$'
ta6h	db	'OpenBSD$'
ta7h	db	'NEXTSTEP$'
ta8h	db	'?$'
ta9h	db	'NetBSD$'
taah	db	'?$'
tabh	db	'?$'
tach	db	'?$'
tadh	db	'?$'
taeh	db	'?$'
tafh	db	'?$'
tb0h	db	'?$'
tb1h	db	'?$'
tb2h	db	'?$'
tb3h	db	'?$'
tb4h	db	'?$'
tb5h	db	'?$'
tb6h	db	'?$'
tb7h	db	'BSDI file system$'
tb8h	db	'BSDI swap partition$'
tb9h	db	'?$'
tbah	db	'?$'
tbbh	db	'?$'
tbch	db	'?$'
tbdh	db	'CP/M-86 Virtual Volumes$'
tbeh	db	'Solaris boot partition$'
tbfh	db	'?$'
tc0h	db	'CTOS; REAL/32$'
tc1h	db	'DR-DOS$'
tc2h	db	'Hidden Linux partition (Power Boot manager)$'
tc3h	db	'Hidden Linux switch partition (Power Boot Manager)$'
tc4h	db	'DR-DOS$'
tc5h	db	'?$'
tc6h	db	'DR-DOS; Windows NT special$'
tc7h	db	'Syrinx boot; Windows NT special$'
tc8h	db	'?$'
tc9h	db	'?$'
tcah	db	'?$'
tcbh	db	'DR-DOS$'
tcch	db	'DR-DOS$'
tcdh	db	'CTOS (Convergent Technologies OS - Unisys)$'
tceh	db	'DR-DOS$'
tcfh	db	'?$'
td0h	db	'REAL/32$'
td1h	db	'?$'
td2h	db	'?$'
td3h	db	'?$'
td4h	db	'?$'
td5h	db	'?$'
td6h	db	'?$'
td7h	db	'?$'
td8h	db	'CP/M-86$'
td9h	db	'?$'
tdah	db	'?$'
tdbh	db	'CP/M-86, Concurrent CP/M-86, Concurrent DOS, CTOS$'
tdch	db	'?$'
tddh	db	'CTOS (Convergent Technologies OS - Unisys)$'
tdeh	db	'?$'
tdfh	db	'?$'
te0h	db	'?$'
te1h	db	'DOS acc; SpeedStar$'
te2h	db	'?$'
te3h	db	'DOS read/only; SpeedStar$'
te4h	db	'SpeedStar$'
te5h	db	'?$'
te6h	db	'?$'
te7h	db	'?$'
te8h	db	'?$'
te9h	db	'?$'
teah	db	'?$'
tebh	db	'BEOS$'
tech	db	'?$'
tedh	db	'?$'
teeh	db	'?$'
tefh	db	'?$'
tf0h	db	'Linux/PA-RISC boot loader$'
tf1h	db	'SpeedStar$'
tf2h	db	'DOS > 3.3, secondary partition$'
tf3h	db	'?$'
tf4h	db	'SpeedStar, Prologue$'
tf5h	db	'Prologue$'
tf6h	db	'?$'
tf7h	db	'?$'
tf8h	db	'?$'
tf9h	db	'?$'
tfah	db	'?$'
tfbh	db	'?$'
tfch	db	'?$'
tfdh	db	'Linux RAID partition$'
tfeh	db	'SpeedStar; IBM PS/2 Initial Microcode Load$'
tffh	db	'Xenix bad block table$'

t_unk	db	'Unknow partition type$'

;Table with offsets of descriptions for recognized partition ID's

ptab_of	equ	$	
	dw	t00h,t01h,t02h,t03h,t04h,t05h,t06h,t07h
	dw	t08h,t09h,t0ah,t0bh,t0ch,t0dh,t0eh,t0fh
	dw	t10h,t11h,t12h,t13h,t14h,t15h,t16h,t17h
	dw	t18h,t19h,t1ah,t1bh,t1ch,t1dh,t1eh,t1fh
	dw	t20h,t21h,t22h,t23h,t24h,t25h,t26h,t27h
	dw	t28h,t29h,t2ah,t2bh,t2ch,t2dh,t2eh,t2fh
	dw	t30h,t31h,t32h,t33h,t34h,t35h,t36h,t37h
	dw	t38h,t39h,t3ah,t3bh,t3ch,t3dh,t3eh,t3fh

	dw	t40h,t41h,t42h,t43h,t44h,t45h,t46h,t47h
	dw	t48h,t49h,t4ah,t4bh,t4ch,t4dh,t4eh,t4fh
	dw	t50h,t51h,t52h,t53h,t54h,t55h,t56h,t57h
	dw	t58h,t59h,t5ah,t5bh,t5ch,t5dh,t5eh,t5fh
	dw	t60h,t61h,t62h,t63h,t64h,t65h,t66h,t67h
	dw	t68h,t69h,t6ah,t6bh,t6ch,t6dh,t6eh,t6fh
	dw	t70h,t71h,t72h,t73h,t74h,t75h,t76h,t77h
	dw	t78h,t79h,t7ah,t7bh,t7ch,t7dh,t7eh,t7fh

	dw	t80h,t81h,t82h,t83h,t84h,t85h,t86h,t87h
	dw	t88h,t89h,t8ah,t8bh,t8ch,t8dh,t8eh,t8fh
	dw	t90h,t91h,t92h,t93h,t94h,t95h,t96h,t97h
	dw	t98h,t99h,t9ah,t9bh,t9ch,t9dh,t9eh,t9fh
	dw	ta0h,ta1h,ta2h,ta3h,ta4h,ta5h,ta6h,ta7h
	dw	ta8h,ta9h,taah,tabh,tach,tadh,taeh,tafh
	dw	tb0h,tb1h,tb2h,tb3h,tb4h,tb5h,tb6h,tb7h
	dw	tb8h,tb9h,tbah,tbbh,tbch,tbdh,tbeh,tbfh

	dw	tc0h,tc1h,tc2h,tc3h,tc4h,tc5h,tc6h,tc7h
	dw	tc8h,tc9h,tcah,tcbh,tcch,tcdh,tceh,tcfh
	dw	td0h,td1h,td2h,td3h,td4h,td5h,td6h,td7h
	dw	td8h,td9h,tdah,tdbh,tdch,tddh,tdeh,tdfh
	dw	te0h,te1h,te2h,te3h,te4h,te5h,te6h,te7h
	dw	te8h,te9h,teah,tebh,tech,tedh,teeh,tefh
	dw	tf0h,tf1h,tf2h,tf3h,tf4h,tf5h,tf6h,tf7h
	dw	tf8h,tf9h,tfah,tfbh,tfch,tfdh,tfeh,tffh

;-------------- convert byte in AL to decimal string at [SI] ----------
b2dec:
	push	ax
	mov	ah,0
	call	w2dec
	pop	ax
	ret

;-------------- convert word in AX to decimal string at [SI] ----------

;The result is left-justified, no leading zeroes. Trailing positions are not
;touched, so beware of digits that are left over from a previous call that
;used the same destination.

w2dec:
	push	ax
	push	cx
	push	dx
	call	w2dec10			;this one does the real work
	pop	dx
	pop	cx
	pop	ax

	ret

;Repeat dividing by 10 and pushing remainder on stack, until quotient is zero.

w2dec10:
	mov	cx,10			;divisor
	mov	dx,0			;high word of dividend

	div	cx			;AX := (DX:AX)/CX; DX := remainder
	cmp	ax,0			;is the quotient/result zero?
	jz	w2dec20			;yes

	push	dx			;put remainder on stack
	call	w2dec10			;recursively divide by 10
	pop	dx			;get remainder from stack

w2dec20:
	add	dl,'0'			;transform remainder to ASCII
	mov	[si],dl			;store ASCII digit
	inc	si

	ret

;-------------- convert dword in DX:AX to decimal string at [SI] ------

;Brute force routine, based on Z80 code from John Elliott

d2dec:
	mov	bp,03b9ah	;BP:DI = 1.000.000.000 decimal
	mov	di,0ca00h
	call	digit

	mov	bp,005f5h	;BP:DI = 100.000.000 decimal
	mov	di,0e100h
	call	digit

	mov	bp,00098h	;BP:DI = 10.000.000 decimal
	mov	di,09680h
	call	digit

	mov	bp,0000fh	;BP:DI = 1.000.000 decimal
	mov	di,04240h
	call	digit

	mov	bp,00001h	;BP:DI = 100.000 decimal
	mov	di,086a0h
	call	digit

	mov	bp,0		;BP:DI = 10.000 decimal
	mov	di,10000
	call	digit

	mov	bp,0		;BP:DI = 1.000 decimal
	mov	di,1000
	call	digit

	mov	bp,0		;BP:DI = 100 decimal
	mov	di,100
	call	digit

	mov	bp,0		;BP:DI = 10 decimal
	mov	di,10
	call	digit

	mov	bl,al		;BL is now units
	jmp	digout

;-------
digit:
	call	divide		;Divide DX:AX by BP:DI. Return BL=quotient,
				;and DX:AX=remainder
digout:
	add	bl,'0'		;Quotient digit: from binary to ASCII
	mov	[si],bl		;Store the digit
	inc	si		;Prepare for next digit
	ret
;-------

divide:				;Divide by repeating a subtraction
	mov	bl,-1
divi10:
	inc	bl
	sub	ax,di		;DX:AX := DX:AX - BP:DI
	sbb	dx,bp
	jnc	divi10

;OK, AL=quotient. Now let DX:AX := DX:AX + BP:DI to get the remainder

	add	ax,di
	adc	dx,bp
	ret

;-------------- convert word in AX to hexadecimal string at [SI]

;Contents of AX is NOT preserved!

w2hex:
	push	ax

	mov	al,ah
	call	b2hex			;convert AH

	pop	ax
					;fall through to convert AL

;-------------- convert byte in AL to hexadecimal string at [SI]

b2hex:
	push	ax
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	call	n2hex		;convert high nibble of AL
	pop	ax
	and	al,0fh
				;fall through to convert low nibble of AL

;-------------- convert lower nibble of AL to hexadecimal string at [SI];
;		before calling n2hex, make sure the high nibble of AL is zero

n2hex:
	add	al,090h
	daa
	adc	al,040h
	daa
	mov	[si],al
	inc	si

	ret

;-------------- display message$ [DX] on the console ------------------

dspmsg:

	push	ds
	push	es

	push	cs
	pop	ds

;	mov	ah,9			;display string
;	int	21h

	mov	cl,9			;display string
	int	0e0h

	pop	es
	pop	ds

dspmsg99:
	ret

;-------------- calculate INT 13h parameters; write a sector ----------

;Input:
;DX:AX = physical sector number, relative to the start of the CVV partition
;ES:BX = address of data to be written

int13:
	push	ax
	push	dx

	push	bx
	push	es

;blank out some message fields

	mov	word ptr m024b+1,'  '
	mov	word ptr m024b+3,'  '
	mov	word ptr m024c+1,'  '
	mov	word ptr m024d+1,'  '

;add start sector of the CVV partition (a zero-based number), giving the
;absolute sector number on the disk;
;range is 0...2^24 - 1 is 0...16.772.216 is 0...8 GB

	add	ax,word ptr s3StartSector
	adc	dx,word ptr s3StartSector+2

	push	ax
	push	dx
	mov	si,offset m024a		;show absolute sector number DX:AX
	call	d2dec
	pop	dx
	pop	ax

;transform absolute sector number to C/H/S values

	div	s3spc			;divide by number of sectors per cyl
	mov	w_cyl,ax		; giving AX = cylinder value 0...1023

	mov	ax,dx			;remainder

	div	s3sph			;divide by number of sectors per head
	mov	w_head,al		; giving AL = head value 0...255
	inc	ah			;AH = remainder = sector value 0...63,
					; make it 1...64
	mov	w_sec,ah

;show values

	mov	ax,w_cyl
	mov	si,offset m024b
	call	w2dec

	mov	al,w_head
	mov	si,offset m024c
	call	b2dec

	mov	al,w_sec
	mov	si,offset m024d
	call	b2dec

	cmp	w_verb,0		;verbose?
	jz	int1310			;no

	mov	dx,offset m022
	call	dspmsg
	mov	dx,offset m024
	call	dspmsg
int1310:

;Check for calculated C/H/S outside partition boundaries
	
	mov	al,w_head		;H
	cmp	al,s3eh			;too large?
	ja	int1320			;yes, error

	mov	al,w_sec		;S
	cmp	al,s3es			;too large?
	ja	int1320			;yes, error

	mov	ax,w_cyl		;C
	cmp	ax,s3ec			;too large?
	ja	int1320			;yes, error

	cmp	ax,s3sc			;too small?
	jb	int1320			;yes, error
	ja	int1350			;no, OK

;Special check if first cylinder and first head of the CVV partition:
;a partition might not start on the very first head of the first cylinder,
;c.q. the very first sector of the first head. 

	mov	al,w_head		;H
	cmp	al,s3sh			;too small?
	jb	int1320			;yes, error
	ja	int1350			;no, OK

	mov	al,w_sec		;S
	cmp	al,s3ss			;too small?
	jnb	int1350			;no, OK

int1320:				;error: C/H/S is outside partition
	mov	dx,offset m023
	call	dspmsg
	mov	dx,offset m024
	call	dspmsg

	jmp	stoprun

;transform correct C/H/S to INT 13h format

int1350:
	mov	cx,w_cyl
	xchg	ch,cl

	shl	cl,1
	shl	cl,1
	shl	cl,1
	shl	cl,1
	shl	cl,1
	shl	cl,1
	or	cl,w_sec
	
	mov	dh,w_head

;Now call INT 13h to write the sector

;Registers:
;ES = segment of buffer
;BX = offset of buffer
;CX = cylinder and sector (INT 13h format)
;DH = head

	mov	al,1			;write one sector
	mov	ah,3			;3=write
	mov	dl,w_hd			;harddisk 80h/81h

	pop	es			;segment of buffer
	pop	bx			;offset of buffer

	push	cx			;save registers
	push	dx			; for error reporting
	int	13h			;call ROM BIOS
	pop	dx
	pop	cx

	jnc	int1399			;jump if OK

	call	berr			;build and show error message
	jmp	stoprun

int1399:
	pop	dx
	pop	ax

	ret

;-------------- build I/O error message M021 --------------------------

berr:
	mov	al,ah
	mov	si,offset m021a		;show error code in AL
	call	b2hex

	mov	al,w_hd
	mov	si,offset m021b		;show drive 80h/81h
	call	b2hex

	mov	al,dh
	mov	si,offset m021d		;show head
	call	b2dec

	mov	al,cl
	and	al,3fh			;sector bits 5...0
	mov	si,offset m021e		;show sector
	call	b2dec

	mov	al,ch			;cylinder bits 7...0
	mov	ah,cl
	mov	cl,6
	shr	ah,cl			;cylinder bits 9...8
	mov	si,offset m021c		;show cylinder
	call	w2dec

	mov	dx,offset m021		;show complete error message
	call	dspmsg

berr99:
	ret

	align	128			;pad with data until 128-byte boundary

;============== MASM 5.1 epilog for a .COM file =======================
	
tgbprep	ends
	end	r0000
