	page	,132

FDEBUG	equ	0			;use 1 for extended run-time message

;------
; CVV.ASM - version 1.0
;
; Date   : 17Jun2001
; Author : Freek Heite
; Email  : fheite@knoware.nl
;
;------
;
; CVV for CP/M-86.
;
; The CVV software package enables "CP/M-86 for the IBM PC and IBM PC XT
; Version 1.1" to use up to 120 MB of harddisk storage, subdivided in chunks
; of 8 MB each, the so-called CVV's or "CP/M Virtual Volumes".

; In this program, "CP/M-86" is used as a shorthand notation for 
; "CP/M-86 for the IBM PC and IBM PC XT  Version 1.1", which is
; "Copyright (C) 1983, Digital Research".


;============== MASM 5.1 prolog for a .COM file =======================

tgb1	segment para public 'code'
		assume	cs:tgb1
		assume	ds:tgb1
		assume	es:nothing

		org	100h

;============== resident data, placed in non-near FIDD storage ========

RDA00	equ	$

r0000:		jmp	r0100		;jump past resident data & code, to the
					; start of our transient code; only
					; used when running the CMD program,
					; not used by the resident driver.
;------
	db	0DBh

	align	2

	db	512	dup('s')	;runtime stack for INT E6h handler
tgbstak	equ	$

	db	0DBh

;------

cpmseg	dw	?			;the CP/M-86 code and data segment

fidnof	dw	?			;near offset of first FIDD storage byte

e6prev	dw	?,?			;far pointer to previous INT E6 handler

;register save area, used when our INT E6h handler gets control

s_ax	dw	?
s_bx	dw	?
s_cx	dw	?
s_dx	dw	?
s_si	dw	?
s_di	dw	?
s_bp	dw	?
s_ss	dw	?
s_sp	dw	?

w_hd	db	080h			;harddisk to be used by this
					; this driver: 80h=1, 81h=2

w_numv	dw	?			;number of CVV's controlled by this
					; driver

w_verbx	db	0			;0 or 1, meaning no/yes show runtime
					;	 informational messages

w_cmd13	db	?			;2=read, 3=write, command for INT 13h
w_blk13	dd	?			;more
w_cyl	dw	?			; working
w_head	db	?			;  storage
w_sec	db	?			;   fields for PC ROM BIOS INT 13h

w_cpblk	dd	?			;CP/M-86 write type flag

w_di	dw	?			;offset within drvtab of calling drive

w_cdrv	db	?			;requested CP/M drive 0...15 is A:...P:
w_ctrk	dw	?			;requested CP/M track 0...255
w_csec	dw	?			;requested CP/M sector 0...255
w_cvv	dw	?			;CVV number (0...15) to which the
					; requested CP/M drive is mapped

w_cdblk	db	?			;CP/M-86 deblock flag (write type)

w_sib	dw	-1,-1			;number of sector currently In Buffer

w_dirt	db	0			;harddisk buffer dirty 0/1 = no/yes

	db	0DBh

;------

drvtab	db	0,0,0,0,0,0,0,0		;CP/M drive number per virtual volume
	db	0,0,0,0,0,0,0,0		; A=0...P=15

	db	0DBh

;------

;Addresses of the dph's for each per virtual volume. Note that this DPH table
;resides in non-near FIDD storage, as CP/M-itself does not have to access it.
;However, the offsets in this table are offsets within near FIDD storage - as
;the DPH's themselves do have to be accessible by CP/M, they must be located
;in near FIDD storage.

dphtab	dw	dphtgb1
	dw	dphtgb2
	dw	dphtgb3
	dw	dphtgb4
	dw	dphtgb5
	dw	dphtgb6
	dw	dphtgb7
	dw	dphtgb8
	dw	dphtgb9
	dw	dphtgb10
	dw	dphtgb11
	dw	dphtgb12
	dw	dphtgb13
	dw	dphtgb14
	dw	dphtgb15
	dw	dphtgb16

	db	0DBh

;------

;Counters. Do not change the order of these counters, as most of them are
;indexed by "write type".

n_start		equ	$

n_r		dd	0		;number of CP/M reads
n_r_snib	dd	0		;read: sector not in buffer
n_r_bfbr	dd	0		;read: buffer flushed before reading

n_w		dd	0		;number of CP/M writes
					; equals n_wu + n_wd + n_wn

n_wn		dd	0		;number of CP/M normal writes
n_wd		dd	0		;number of CP/M directory writes
n_wu		dd	0		;number of CP/M unallocated writes

n_wn_snib	dd	0		;normal write:
					; sector not in buffer
n_wd_snib	dd	0		;directory write:
					; sector not in buffer
n_wu_snib	dd	0		;unallocated write:
					; sector not in buffer

n_wn_bfbw	dd	0		;normal write:
					; buffer flushed before writing
n_wd_bfbw	dd	0		;directory write:
					; buffer flushed before writing
n_wu_bfbw	dd	0		;unallocated write:
					; buffer flushed before writing

n_end		equ	$
	
		db	0DBh

;------

;data from sector 3 of the CVV partition: the virtual volume parameter table

		align	2

s3buf		equ	$

s3chk		dw	0	;16 bit checksum (adding all 256 words
				; in this sector should produce zero)
				;This field must be on a word boundary!

tgbvers		equ	$	;1.0
tgbverl		db	0	;minor version
tgbverh		db	1	;major version

		db	'CPM86CVV'

s3part		equ	$	;a copy of our partition table entry

s3Bootable	db	?	;80h = bootable, 00h = nonbootable
s3BeginHead	db	?	;beginning head
s3BeginSector	db	?	;bits 5...0: beginning sector
				;bits 7...6: beginning cylinder bits 9...8
s3BeginCylinder	db	?	;beginning cylinder bits 7...0
s3FileSystem	db	?	;name of file system

s3EndHead	db	?	;ending head
s3EndSector	db	?	;bits 5...0: ending sector
				;bits 7...6: ending cylinder bits 9...8
s3EndCylinder	db	?	;ending cylinder bits 7...0
s3StartSector	dd	?	;starting sector (relative to beg. of disk)
s3Sectors	dd	?	;number of sectors in partition

;more data

s3last		dd	?	;last sector of the partition (zero-based,
				; relative to beginning of disk)

s3numv		dw	?	;number of virtual volumes in the CVV
				; partition: 1...15

s3sc		dw	?	;CVV partition start cylinder 0...1023
s3sh		db	?	;CVV partition start head 0...255
s3ss		db	?	;CVV partition start sector 1...63

s3ec		dw	?	;CVV partition end cylinder 0...1023
s3eh		db	?	;CVV partition max head = end head 0...255
s3es		db	?	;CVV partition max sector = end sector 1...63

s3res		dw	64	;number of reserved sectors at the start
				; of the CVV partition

s3spc		dw	?	;number of sectors per cylinder
				; = (s3eh+1) * s3es
				; = 0...2^14 -1 = 0...16383 = 0...8 MB

s3sph		db	?	;number of sectors per head
				; = s3es
				; = 0...2^6 -1 = 0...63 = 0...31.5 KB

s3spv		dw	16384	;number of sectors per virtual volume
				; = 16384 = 8 MB

		db	512-($-s3buf) dup('3')	;fill up to 512 bytes

		db	0DBh
;------

IF FDEBUG

;long message text:
;
;CVV301 AX=xxxxh (0=sel 2=rd 4=wr 6=hom) drv#=xxh fiddrv#=xxh dblk=xxh vrfy=xxh
;Parms at DX:BX=xxxx:xxxxh are: trk=xxxxh sec=xxxxh dmaoff=xxxxh dmaseg=xxxxh

m301	db	0dh,0ah
	db	'CVV301 AX='
m301a	db	'xxxxh (0=sel 2=rd 4=wr 6=hom) drv#='
m301b	db	'xxh fiddrv#='
m301c	db	'xxh dblk='
m301d	db	'xxh vrfy='
m301e	db	'xxh'
	db	0dh,0ah
	db	'Parms at DX:BX='
m301f	db	'xxxx:'
m301g	db	'xxxxh are: trk='
m301h	db	'xxxxh sec='
m301i	db	'xxxxh dmaoff='
m301j	db	'xxxxh dmaseg='
m301k	db	'xxxxh'
	db	0dh,0ah,'$'

ELSE

;short message text:
;
;CVV302 AX=xxxxh (0=sl 2=rd 4=wr 6=ho) tr=xxxxh se=xxxxh drv=xxh prm=xxxx:xxxxh

m302	db	0dh,0ah
	db	'CVV302 AX='
m302a	db	'xxxxh (0=sl 2=rd 4=wr 6=ho) tr='
m302b	db	'xxxxh se='
m302c	db	'xxxxh drv='
m302d	db	'xxh prm='
m302f	db	'xxxx:'
m302g	db	'xxxxh'
	db	0dh,0ah,'$'

ENDIF

;I/O error when reading/writing harddisk
;
;CVV303 I/O err=xxh: cmd=X b=nnnnnnnnnn C=nnnnn H=nnn S=nnn CT=nnn CS=nnn CD=X:

m303	db	0dh,0ah
	db	'CVV303 I/O err='
m303a	db	'xxh: '
	db	'$'

;sector to read or write not within CVV partition
;
;CVV304 range err: cmd=X b=nnnnnnnnnn C=nnnnn H=nnn S=nnn CT=nnn CS=nnn CD=X:

m304	db	0dh,0ah
	db	'CVV304 range err: '
	db	'$'

;detail data for M304 and M305

m305	db	'cmd='
m305a	db	'X b='			;command: Read or Write
m305b	db	'nnnnnnnnnn C='		;absolute harddisk sector
m305c	db	'n     H='		;cylinder
m305d	db	'n   S='		;head
m305e	db	'n   CT='		;sector
m305f	db	'n   CS='		;CP/M track
m305g	db	'n   CD='		;CP/M sector
m305h	db	'X:'  			;CP/M drive
	db	0dh,0ah,'$'

;track and/or sector number as requested by CP/M is too large (i.e. > 255)
;
;CVV306 range error: cmd=X CP/M-drive=X: CP/M-track=nnnnn CP/M-sector=nnnnn

m306	db	0dh,0ah
	db	'CVV306 range error: cmd='
m306a	db	'X CP/M-drive='		;chemical X is R(ead) or W(rite)
m306b	db	'X: CP/M-track='
m306c	db	'nnnnn CP/M-sector='
m306d	db	'nnnnn'
	db	0dh,0ah,'$'

;------
	align	2

secbuf	db	512 dup('b')		;buffer for one harddisk sector

	db	0DBh

;------

RDA99	equ	$

;============== resident code, placed in non-near FIDD storage ========

;Placed in non-near FIDD storage at some segment, starting at offset RCA00.
;So at run time, the offsets are the same as at assembly time.

RCA00	equ	$

;-------------- about interrupt E6h -----------------------------------

comment %

The BIOS of CP/M-86 issues an interrupt E6h whenever it receives a
disk-related call from the CP/M-86 BDOS specifying a disk drive that
is not recognized by the BIOS-itself. The default E6h handler in a standard
CP/M-86 system does nothing but return an error code on the SELDSK call.

This INT E6h interface allows developers to add drivers for additional,
non-standard storage devices: the driver program is stored in FIDD storage
and then hooks this interrupt E6h.
Basically, that's what this CVV program is doing.

Registers on entry to an interrupt E6h handler, when called by CP/M-86 BIOS:

AX = CP/M-86 BIOS function: 0=seldsk 2=read 4=write 6=home. Details of
     these functions can be found in the CP/M-86 System Guide.
BX = offset within the CP/M-86 segment of the INT E6h parameter block, plus 1.
CL = deblock flag a.k.a. write type. Described in the CP/M-86 System Guide
     (0=normal write, 1=write to directory, 2=write to the first sector of 
     an unallocated block,).
DX = the CP/M-86 code and data segment. 0051h in a standard CP/M-86 system.

The INT E6h parameter block is 12 bytes. Note that DX:BX points to the second
byte of the parameters, biosdk_fdrive, not to the first byte.

- byte biosdk_drive = drive number 0=A...15=P
- byte biosdk_fdrive = drive number as in previous byte, minus the number of
                       drives in the system that are directly controlled by
                       the PC ROM BIOS. Not used by this program.
- byte data_182 = deblock flag a.k.a. write type (same as CL above)
- word biosdk_track = track
- word biosdk_sector = sector
- word biosdk_dma_offs = CP/M-86 BIOS DMA offset
- word biosdk_dma_segm = CP/M-86 BIOS DMA segment
- byte biosdk_verify = verify data written 0=no other=yes. Not used by
                       this program.

Registers on return:

AX = return codes as defined in the CP/M-86 System Guide for the actual
     BIOS function being performed
others = same as on entry

In all cases, the CP/M-86 BIOS will copy AX to BX immediately after the
interrupt E6h returns.

 %	;end comment

;-------------- handler for INT E6h -----------------------------------

e6hand:

	mov	cs:s_ss,ss		;save old SS
	mov	cs:s_sp,sp		; and SP

	cli
	mov	sp,cs
	mov	ss,sp			;switch to
	mov	sp,offset tgbstak	; local stack
	sti

	pushf
	push	di
	push	es
	push	ax
	push	cx

;------ is this interrupt E6h for one of our drives?

	mov	es,dx
	mov	al,es:[bx-1]		;AL := calling drive 0=A...15=P

	push	cs
	pop	es

	mov	di,offset drvtab	;find calling drive in the drvtab table
	mov	cx,cs:w_numv		;number of valid entries in this table

	cld
	repne	scasb			;when found, zero flag will be set

	mov	cs:w_di,di		;save the offset +1 within drvtab where
					; we might have found the calling drive

	pop	cx			;restore
	pop	ax			; all
	pop	es			;  changed
	pop	di			;   registers

	jz	e6h02			;yes, it is one of our drives

	popf				;restore flags

	cli
	mov	ss,cs:s_ss		;restore old SS
	mov	sp,cs:s_sp		; and SP
	sti

	jmp	dword ptr cs:e6prev	;go to previous handler for INT E6h

;------ this interrupt E6h is indeed for one of our drives ------------

e6h02:
	popf

	push	ds
	push	es

	push	cs
	pop	ds

	mov	s_ax,ax
	mov	s_bx,bx
	mov	s_cx,cx
	mov	s_dx,dx
	mov	s_si,si
	mov	s_di,di
	mov	s_bp,bp

;------ determine calling CP/M drive, and corresponding virtual volume number

	mov	bx,[w_di]		;offset +1 within drvtab where
					; we found the calling drive
	dec	bx
	mov	al,[bx]
	mov	w_cdrv,al		;calling drive 0...15 is A:...P:

	sub	bx,offset drvtab
	mov	w_cvv,bx		;virtual volume # 0...15

;------ display input parameters for this driver

e6h03:
	cmp	w_verbx,0		;verbose?
	jz	e6h05			;no

	call	dspregs			;format the input parameters

IF FDEBUG
	mov	si,offset m301		;long format
ELSE
	mov	si,offset m302		;short format
ENDIF

	call	dspm			;show it
e6h05:

;------ process function code in AX

	cmp	s_ax,0			;seldsk?
	jnz	e6h10			;no		
	call	e6seldsk			
	jmp	e6h95
e6h10:
	cmp	s_ax,2			;read?
	jnz	e6h20			;no
	call	e6read
	jmp	e6h92
e6h20:
	cmp	s_ax,4			;write?
	jnz	e6h30			;no
	call	e6write
	jmp	e6h92
e6h30:
	cmp	s_ax,6			;home?
	jnz	e6h40			;no
	call	e6home
	jmp	e6h90
e6h40:
	cmp	s_ax,'GK'		;ioctl?
	jnz	e6h50			;no
	cmp	s_cx,'TG'
	jnz	e6h50
	call	e6ctl			;magic words OK, call ioctl routine
	jmp	e6h97
e6h50:
	mov	ax,1			;unknown function
	mov	bx,ax
	stc
	jmp	e6h95
e6h90:
	mov	ax,s_ax
e6h92:
	mov	bx,s_bx
e6h95:
	mov	cx,s_cx
	mov	dx,s_dx
	mov	si,s_si
	mov	di,s_di
	mov	bp,s_bp
e6h97:
	pop	es
	pop	ds

	cli
	mov	ss,cs:s_ss		;restore old SS
	mov	sp,cs:s_sp		; and SP
	sti

	iret				;return from INT E6h

;-------------- seldsk ------------------------------------------------
e6seldsk:

	mov	bx,w_cvv		;BX := CVV number 0...15

	add	bx,bx			;BX := BX * 2
	add	bx,offset dphtab
	mov	ax,word ptr [bx]	;pointer to DPH of calling CVV
	
	mov	bx,ax			;return AX := BX := near pointer to DPH
					; (DPH is in "near" FIDD storage, so
					;  within the CP/M-86 segment)
	ret

;-------------- read --------------------------------------------------
e6read:

;verify and set up parameters

	call	calc
	jnc	e6r01			;OK
	jmp	e6r95			;track or sector number too large
e6r01:

	add	word ptr n_r,1		;statistics
	adc	word ptr n_r +2,0

	mov	ax,word ptr w_cpblk
	cmp	ax,word ptr w_sib	;sector already in buffer?
	jne	e6r10			;no, must read
	mov	ax,word ptr w_cpblk +2
	cmp	ax,word ptr w_sib +2
	jne	e6r10			;no, must read

	jmp	e6r20			;yes, already there, skip the read

e6r10:
	add	word ptr n_r_snib,1	;statistics:
	adc	word ptr n_r_snib +2,0	; sector to be read not in buffer

;flush host buffer, if it contains unwritten data

	call	qdirt			;flush buffer, if needed
	mov	m305a,'F'
	jnc	e6r11
	jmp	e6r90			;jump if failure on INT 13h
e6r11:

;call INT 13h to read the relative 512 bytes harddisk sector, as
;it is not yet in the buffer

	mov	w_cmd13,2		;read

	mov	bx,offset secbuf	;offset of 512 bytes buffer
	push	cs
	pop	es			;segment of 512 bytes buffer

	mov	ax,word ptr w_cpblk	;sector number
	mov	dx,word ptr w_cpblk +2	; for int13

	call	int13			;read sector DX:AX
	mov	m305a,'R'
	jc	e6r90			;jump if failure on INT 13h

	mov	ax,word ptr w_cpblk	;read OK, update sib
	mov	word ptr w_sib,ax
	mov	dx,word ptr w_cpblk +2
	mov	word ptr w_sib +2,dx

;move 128 bytes from the 512 bytes harddisk sector to the CP/M-86 DMA area

e6r20:
	mov	es,s_dx			;ES:BX := far pointer to parameters
	mov	bx,s_bx

	mov	di,es:[bx+6]		;CP/M DMA offset
	mov	es,es:[bx+8]		;CP/M DMA segment

	mov	si,offset secbuf

	mov	ax,w_csec		;CP/M sector number
	and	ax,11b			;mask bits 1...0 giving 0/1/2/3

	mov	cl,7			;multiply by 128
	shl	ax,cl			; giving 0/128/256/384
	add	si,ax			;offset within 512 byte harddisk sector

	mov	cx,64
	cld
	rep	movsw			;move 64 words

	xor	ax,ax			;done, RC := 0
	ret

e6r90:
	call	dspm			;display message at SI as set by int13
					; (range error or I/O errr)

	mov	si,offset m305		;display message details
e6r95:
	call	dspm

	mov	ax,1			;done, RC := 1
	ret

;-------------- write -------------------------------------------------

e6write:

;verify and set up parameters

	call	calc
	jnc	e6w01			;OK
	jmp	e6w95			;track or sector number too large
e6w01:

	add	word ptr n_w,1		;statistics
	adc	word ptr n_w +2,0

	mov	si,offset n_wn
	call	wstat			;statistics per write type

;check if the sector to be written is already in the buffer

	mov	ax,word ptr w_cpblk
	cmp	ax,word ptr w_sib	;sector already in buffer?
	jne	e6w10			;no, might need flush and pre-read
	mov	ax,word ptr w_cpblk +2
	cmp	ax,word ptr w_sib +2
	jne	e6w10			;no, might need flush and pre_read

	jmp	e6w20			;yes, skip the flush and pre-read

e6w10:
	mov	si,offset n_wn_snib	;statistics: sector not in buffer
	call	wstat

;flush host buffer, if it contains unwritten data

	call	qdirt			;flush buffer, if needed
	mov	m305a,'F'
	jnc	e6w11			;OK
	jmp	e6w90			;jump if failure on INT 13h
e6w11:		

;skip the pre-read when writing the first sector of an unallocated data block,
;and go immediately to updating w_sib

	cmp	w_cdblk,2		;write unallocated?
	je	e6w15			;yes

;call INT 13h to pre-read the relative 512 bytes harddisk sector, as
;it is not yet in the buffer

	mov	w_cmd13,2		;read

	mov	bx,offset secbuf	;offset of 512 bytes buffer
	push	cs
	pop	es			;segment of 512 bytes buffer

	mov	ax,word ptr w_cpblk	;sector number
	mov	dx,word ptr w_cpblk +2	; for int13

	call	int13			;read sector DX:AX
	mov	m305a,'P'
	jc	e6w90			;jump if failure on INT 13h

e6w15:
	mov	ax,word ptr w_cpblk	;read OK or not required, update w_sib
	mov	word ptr w_sib,ax
	mov	ax,word ptr w_cpblk +2
	mov	word ptr w_sib +2,ax

;for all write types:
;move 128 bytes from the CP/M-86 DMA area to the 512 bytes harddisk sector

e6w20:
	mov	es,s_dx			;ES:BX := far pointer to parameters
	mov	bx,s_bx

	mov	si,es:[bx+6]		;CP/M DMA offset
	mov	ds,es:[bx+8]		;CP/M DMA segment

	push	cs
	pop	es

	mov	di,offset secbuf

	mov	ax,cs:w_csec		;CP/M sector number
	and	ax,11b			;mask bits 1...0 giving 0/1/2/3

	mov	cl,7			;multiply by 128
	shl	ax,cl			; giving 0/128/256/384
	add	di,ax			;offset within 512 byte harddisk sector

	mov	cx,64
	cld
	rep	movsw			;move 64 words

	push	cs
	pop	ds			;restore DS

	mov	w_dirt,1		;mark buffer as dirty

;if writing to the directory:
;call ROM BIOS INT 13h to rewrite the 512 bytes sector to the harddisk
;as directory writes should always be done immediately

	cmp	w_cdblk,1		;directory write?
	jne	e6w80			;no, just leave the data in the buffer

	mov	w_cmd13,3		;write now

	mov	bx,offset secbuf
	push	cs
	pop	es

	mov	ax,word ptr w_cpblk	;sector number
	mov	dx,word ptr w_cpblk +2	; for int13

	call	int13			;write sector DX:AX

	mov	m305a,'W'
	jc	e6w90			;jump if failure on INT 13h

	mov	w_dirt,0		;buffer is now clean

e6w80:
	xor	ax,ax			;done, RC := 0
	ret

e6w90:
	call	dspm			;display message at SI as set by int13

	mov	si,offset m305		;display message details
e6w95:
	call	dspm
e6w97:
	mov	ax,1			;done, RC := 1
	ret

;-------------- home --------------------------------------------------

e6home:
	nop				;no action
	ret

;-------------- ioctl -------------------------------------------------
e6ctl:
	mov	ax,'OK'			;tell our caller that we're here
	mov	bx,'FH'

	mov	cx,cs			;segment of driver's non-near
					; FIDD data and code
	ret

;-------------- qdirt -------------------------------------------------

;If the host buffer contains data that has not yet been written to disk,
;write it out now and mark the buffer status as clean (flushed).

qdirt:
	cmp	w_dirt,0		;buffer clean?
	clc
	jz	qdir99			;yes, done

	cmp	s_ax,2			;current function = read?
	jne	qdir10			;no

	add	word ptr n_r_bfbr,1	;yes, statistics
	adc	word ptr n_r_bfbr +2,0
	jmp	qdir20

qdir10:
	mov	si,offset n_wn_bfbw
	call	wstat

;now write the dirty buffer to disk

qdir20:
	mov	w_cmd13,3		;write

	mov	bx,offset secbuf	;offset of 512 bytes buffer
	push	cs
	pop	es			;segment of 512 bytes buffer

	mov	ax,word ptr w_sib	;sector number
	mov	dx,word ptr w_sib +2	; for int13

	call	int13			;read sector DX:AX
	jc	qdir99			;jump if failure on INT 13h

	mov	w_dirt,0		;OK, mark buffer clean

qdir99:
	ret

;-------------- wstat -------------------------------------------------

;SI = offset of a pair of three successive dword counters, one per write type

wstat:
	mov	bl,w_cdblk		;deblock flag should be 0, 1 or 2

	cmp	bl,2			;larger than 2?
	ja	wstat99			;yes, unexpected value, do not count

	mov	bh,0
	add	bx,bx
	add	bx,bx			;BX := BX * 4, counters are dwords

	add	word ptr [bx][si],1	;statistics: type of write
	adc	word ptr [bx][si][2],0
wstat99:
	ret
;-------------- calc --------------------------------------------------

;Calculate harddisk sector to read or write, based on the E6h parameters.
;
;Returns:
;- carry set: track or sector too large (i.e. above 255)
;- carry not set: acceptable sector number has been put into w_cpblk

calc:

;get CP/M-track and -sector number to read, from the FIDD parameters

	mov	es,s_dx			;ES:BX := far pointer to E6h parameters
	mov	bx,s_bx

	mov	dx,es:[bx+2]		;CP/M track 0...255
	mov	w_ctrk,dx

	mov	ax,es:[bx+4]		;CP/M sector 0...255
	mov	w_csec,ax

;get deblock flag, from the FIDD parameters

	mov	cl,es:[bx+1]		;deblock flag,
	mov	w_cdblk,cl		; 2 = first write to unallocated block

;range check: track and sector must both be less than 256

	cmp	dh,0			;track above 255?
	jnz	calc10			;yes, error

	cmp	ah,0			;sector above 255?
	jz	calc20			;no, continue
calc10:
	mov	m306a,'R'		;build range error message M306

	mov	al,w_cdrv		;1...15 = B:...P:
	add	al,'A'
	mov	m306b,al

	mov	word ptr m306c +1,'  '
	mov	word ptr m306c +3,'  '
	mov	ax,w_ctrk
	mov	si,offset m306c
	call	w2dec

	mov	word ptr m306d +1,'  '
	mov	word ptr m306d +3,'  '
	mov	ax,w_csec
	mov	si,offset m306d
	call	w2dec

	mov	si,offset m306		;prepare for range error message

	stc
	jmp	calc99

calc20:

;build in DX:AX the relative 128 byte CP/M sector number within the partition

;reshuffle DH.DL:AH.AL (tt=track, ss=sector)
;from      00.tt:00.ss
;to        00.00:tt.ss

	mov	ah,dl

;add 64 K sectors for each preceeding CVV

	mov	dx,w_cvv

;convert from 128 byte CP/M sector number to 512 byte harddisk sector number

	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX ->carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry

	mov	word ptr w_cpblk,ax
	mov	word ptr w_cpblk +2,dx

	clc
calc99:
	ret

;-------------- setup and execute INT 13h -----------------------------

;Input:
;
;DX:AX   = physical harddisk sector number, relative to the start of the
;          CVV partition, excluding reserved sectors at the beginning of 
;          the partition
;ES:BX   = far pointer to our 512 bytes sector buffer in non-near FIDD storage
;w_cmd13 = action to perform: R for read, W for write

int13:
	push	bx
	push	es

;add the reserved sectors at the start of the CVV partition

	add	ax,s3res
	adc	dx,0

;add start sector of the partition, giving the absolute sector number on the
;drive in DX:AX, range 0...2^24 - 1 is 0...16.772.216 is 0...8 GB

	add	ax,word ptr s3StartSector
	adc	dx,word ptr s3StartSector+2

	mov	word ptr w_blk13,ax
	mov	word ptr w_blk13 +2,dx

;transform absolute sector number in DX:AX to C/H/S values

	div	s3spc			;divide by number of sectors per cyl
	mov	w_cyl,ax		; giving AX = cylinder value 0...1023

	mov	ax,dx			;remainder

	div	s3sph			;divide by number of sectors per head
	mov	w_head,al		; giving AL = head value 0...255
	inc	ah			;AH = remainder = sector value 0...62,
					; make it 1...63
	mov	w_sec,ah

;check for C/H/S outside partition boundaries

	mov	al,w_head
	cmp	al,s3eh			;too large?
	ja	int1320			;yes

	mov	al,w_sec
	cmp	al,s3es			;too large?
	ja	int1320			;yes

	mov	ax,w_cyl
	cmp	ax,s3ec			;too large?
	ja	int1320			;yes

	cmp	ax,s3sc			;too small?
	jb	int1320			;yes
	jne	int1350			;no; jump if not first cylinder

;Special checks if first cylinder and first head of the CVV partition, as a
;partition might not start on the very first head of the first cylinder,
;c.q. the very first sector of the first head. 

	mov	al,w_head		;H
	cmp	al,s3sh			;too small?
	jb	int1320			;yes
	jne	int1350			;no; jump if not first head

	mov	al,w_sec		;S
	cmp	al,s3ss			;too small?
	jnb	int1350			;no

int1320:
	call	m305fmt			;format C/H/S details for M305

	mov	si,offset m304		;calculated C/H/S is outside partition
					; (meaning our calculations are wrong)

	pop	es			;clean up
	pop	bx			; the stack

	stc
	ret

;transform C/H/S to the parameter format required by INT 13h in CL, CH and DH

int1350:
	mov	cx,w_cyl
	xchg	ch,cl

	shl	cl,1
	shl	cl,1
	shl	cl,1
	shl	cl,1
	shl	cl,1
	shl	cl,1
	or	cl,w_sec
	
	mov	dh,w_head

;Now call INT 13h to read or write the 512 bytes harddisk sector

;Registers:
;ES = segment of buffer
;BX = offset of buffer
;CX = cylinder and sector (in INT 13h format)
;DH = head

	mov	ah,w_cmd13

	mov	al,1			;process one sector
	mov	dl,w_hd			;harddisk 80h/81h

	pop	es			;segment of buffer
	pop	bx			;offset of buffer

	int	13h			;call ROM BIOS
	jnc	int1399			;jump if OK

	mov	al,ah			;show error code of INT 13h
	mov	si,offset m303a
	call	b2hex

	call	m305fmt			;format C/H/S details for M305

	mov	si,offset m303		;harddisk I/O error

	stc				;return error
	ret

int1397:
	pop	es
	pop	bx

int1399:
	ret

;-------------- format data for message M305 --------------------------

m305fmt:

	mov	word ptr m305c +1,'  '
	mov	word ptr m305c +3,'  '
	mov	word ptr m305d +1,'  '
	mov	word ptr m305e +1,'  '
	mov	word ptr m305f +1,'  '
	mov	word ptr m305g +1,'  '

	mov	ax,word ptr w_blk13
	mov	dx,word ptr w_blk13 +2
	mov	si,offset m305b
	call	d2dec

	mov	ax,w_cyl
	mov	si,offset m305c
	call	w2dec

	mov	al,w_head
	mov	si,offset m305d
	call	b2dec

	mov	al,w_sec
	mov	si,offset m305e
	call	b2dec

	mov	ax,w_ctrk
	mov	si,offset m305f
	call	w2dec

	mov	ax,w_csec
	mov	si,offset m305g
	call	w2dec

	mov	al,w_cdrv
	add	al,'A'
	mov	m305h,al

m30599:
	ret

;-------------- convert dword in DX:AX to decimal string at [SI] ------

;Brute force routine (divide by repeated subtraction).
;Based on Z80 code from John Elliott

d2dec:
	mov	bp,03b9ah	;BP:DI = 1.000.000.000 decimal
	mov	di,0ca00h
	call	digit

	mov	bp,005f5h	;BP:DI = 100.000.000 decimal
	mov	di,0e100h
	call	digit

	mov	bp,00098h	;BP:DI = 10.000.000 decimal
	mov	di,09680h
	call	digit

	mov	bp,0000fh	;BP:DI = 1.000.000 decimal
	mov	di,04240h
	call	digit

	mov	bp,00001h	;BP:DI = 100.000 decimal
	mov	di,086a0h
	call	digit

	mov	bp,0		;BP:DI = 10.000 decimal
	mov	di,10000
	call	digit

	mov	bp,0		;BP:DI = 1.000 decimal
	mov	di,1000
	call	digit

	mov	bp,0		;BP:DI = 100 decimal
	mov	di,100
	call	digit

	mov	bp,0		;BP:DI = 10 decimal
	mov	di,10
	call	digit

	mov	bl,al		;BL is now units
	jmp	digout

;-------
digit:
	call	divide		;Divide DX:AX by BP:DI. Return BL=quotient,
				;and DX:AX=remainder
digout:
	add	bl,'0'		;Quotient digit: from binary to ASCII
	mov	[si],bl		;Store the digit
	inc	si		;Prepare for next digit
	ret
;-------

divide:				;Divide by repeating a subtraction
	mov	bl,-1
divi10:
	inc	bl
	sub	ax,di		;DX:AX := DX:AX - BP:DI
	sbb	dx,bp
	jnc	divi10

;OK, AL=quotient. Now let DX:AX := DX:AX + BP:DI to get the remainder

	add	ax,di
	adc	dx,bp
	ret

;-------------- convert byte in AL to decimal string at [SI] ----------
b2dec:
	push	ax
	mov	ah,0
	call	w2dec
	pop	ax
	ret

;-------------- convert word in AX to decimal string at [SI] ----------

;The result is left-justified, no leading zeroes. Trailing positions are not
;touched, so beware of digits that are left over from a previous call that
;used the same destination.

;Repeat dividing by 10 and pushing remainder on stack, until quotient is zero.

w2dec:
	push	ax
	push	cx
	push	dx
	call	w2dec10			;this one does the real work
	pop	dx
	pop	cx
	pop	ax

	ret

w2dec10:
	mov	cx,10			;divisor
	mov	dx,0			;high word of dividend

	div	cx			;AX := (DX:AX)/CX; DX := remainder
	cmp	ax,0			;is the quotient/result zero?
	jz	w2dec20			;yes

	push	dx			;put remainder on stack
	call	w2dec10			;recursively divide by 10
	pop	dx			;get remainder from stack

w2dec20:
	add	dl,'0'			;transform remainder to ASCII
	mov	[si],dl			;store ASCII digit
	inc	si

	ret

;-------------- convert word in AX to hexadecimal string at [SI]

;Contents of AX is NOT preserved!

w2hex:
	push	ax

	mov	al,ah
	call	b2hex			;convert AH

	pop	ax
					;fall through to convert AL

;-------------- convert byte in AL to hexadecimal string at [SI]

b2hex:
	push	ax
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	call	n2hex		;convert high nibble of AL
	pop	ax
	and	al,0fh
				;fall through to convert low nibble of AL

;-------------- convert lower nibble of AL to hexadecimal string at [SI];
;		before calling n2hex, make sure the high nibble of AL is zero

n2hex:
	add	al,090h
	daa
	adc	al,040h
	daa
	mov	[si],al
	inc	si

	ret

;-------------- display registers at entry to INT E6h handler ---------

dspregs:

IF FDEBUG

;------ m301

	mov	ax,s_ax			;function code
	mov	si,offset m301a
	call	w2hex

	mov	ax,s_dx			;segment for paramaters
	mov	si,offset m301f
	call	w2hex

	mov	ax,s_bx			;offset for parameters
	mov	si,offset m301g
	call	w2hex

	mov	es,s_dx			;set ES:BX to parameters
	mov	bx,s_bx

	mov	al,es:[bx-1]		;drive number
	mov	si,offset m301b
	call	b2hex

	mov	al,es:[bx]		;FIDD drive number
	mov	si,offset m301c
	call	b2hex

	mov	al,es:[bx+1]		;deblock flag a.k.a. write type
	mov	si,offset m301d
	call	b2hex

	mov	ax,es:[bx+2]		;track
	mov	si,offset m301h
	call	w2hex

	mov	ax,es:[bx+4]		;sector
	mov	si,offset m301i
	call	w2hex

	mov	ax,es:[bx+6]		;DMA offset
	mov	si,offset m301j
	call	w2hex

	mov	ax,es:[bx+8]		;DMA segment
	mov	si,offset m301k
	call	w2hex

	mov	al,es:[bx+9]		;verify flag
	mov	si,offset m301e
	call	b2hex

ELSE

;------ m302

	mov	ax,s_ax			;function code
	mov	si,offset m302a
	call	w2hex

	mov	ax,s_dx			;segment for parameters
	mov	si,offset m302f
	call	w2hex

	mov	ax,s_bx			;offset for parameters
	mov	si,offset m302g
	call	w2hex

	mov	es,s_dx			;set ES:BX to parameters
	mov	bx,s_bx

	mov	al,es:[bx-1]		;drive number
	mov	si,offset m302d
	call	b2hex

	mov	ax,es:[bx+2]		;track
	mov	si,offset m302b
	call	w2hex

	mov	ax,es:[bx+4]		;sector
	mov	si,offset m302c
	call	w2hex
ENDIF
	
dspr99:
	ret

;-------------- display ASCII$ message at DS:SI through INT 10h -------

;Used by the interrupt E6h handler for displaying messages. As the BDOS
;is not reentrant, we cannot use the standard CP/M-86 calls here.

dspm:
dspm10:
	cld
	lodsb

	cmp	al,'$'			;string terminator?
	jz	dspm90			;yes, done

	mov	ah,0eh			;write in TTY mode
	xor	bx,bx			;BH=0=page BL=0=color
	int	10h

	jmp	short dspm10		;next character

;Tell CP/M-86 that the screen cursor position has changed, so it will know
;where to write its own next output.

dspm90:
	mov	ah,3			;read cursor position and size
	mov	bh,0
	int	10h			;DH := row, DL := column
	cmp	dh,23
	jbe	dspm95
	mov	dh,23			;don't set cursor above line 23

dspm95:
	mov	es,cpmseg		;the CP/M-86 segment
	mov	es:[351fh],dh		;set cursor line

	ret

RCA99	equ	$


;============== resident data, placed in near FIDD storage ============

;Placed in near FIDD storage in the CP/M-segment, at offset [fidnof].
;So at run time, the offsets are not the same as at assembly time:
;e.g. run time offset of DPHCVV1 := offset DPHCVV1 - offset RDN00 + [fidnof].

;The contents of the near pointers DPBPTRnn and ALVPTRnn below are incremented
;with [fidnof] by the transient program, before the data is moved into FIDD
;storage (see below at label R10000).

RDN00		equ	$

;-------------- a single DPB for all virtual volumes ------------------

;Values:
;
;- block size BLS=8192; there are 64 sectors of 128 bytes in a block
;- block shift BSH is 6, because BLS=8192
;- block mask BLM is 63, because BLS=8192
;- track size is 32 KB, is 4 blocks of 8 KB;
;  there are 256 sectors of 128 bytes on a track, so SPT=256
;- 1024 directory entries, so four 8 KB blocks are used for the directory
;  (DRM=1023, AL0=0F0h, AL1=0)
;- no checked directory entries, media is not removable, so CKS=0
;- reserved tracks: none (the read and write routines in this driver program
;  will account for the 64 reserved harddisk sectors (= 1 CP/M track) at the
;  start of the partition, and for the position of the virtual volume within
;  the partition).
;

;Other numbers:
;
;size	MB's	8
;size	KB's	8192
;
;DSM	blocks	1023
;EXM	mask	3
;
;tracks		256

;STAT DSK: for an 8 MB virtual volume:
;
;65,536: 128 Byte Record Capacity
; 8,192: Kilobyte Drive  Capacity
; 1,024: 32 Byte  Directory Entries
;     0: Checked  Directory Entries
;   512: 128 Byte Records / Directory Entry
;    64: 128 Byte Records / Block
;   256: 128 Byte Records / Track
;     0: reserved  Tracks

;blstgb		equ	8192		;block size is 32 sectors of 128 bytes

dpbtgb:					;DPB control block
spttgb		dw	256		;number of 128-byte sectors per track
bshtgb		db	6		;block shift count: blstgb = (2^6) *128
blmtgb		db	63		;block mask
exmtgb		db	3		;extent mask
dsmtgb		dw	1023		;number of blocks minus 1
drmtgb		dw	1023		;number of directory entries minus 1,
					;1023 dir entries of 32 bytes, total is
					;32 KB is 4 blocks of blstgb bytes
al0tgb		db	0f0h		;4 directory blocks of blstgb bytes
al1tgb		db	0		; (256 entries per block)
ckstgb		dw	0		;no CKS, media is not removable
offtgb		dw	0		;no reserved tracks
		db	0DBh
		
;-------------- DPH's for all 15 CVV's --------------------------------

dphtgb1:
xlttgb1		dw	0		;no sector translation
scratchtgb1	dw	0,0,0		;scratch pad for BDOS
dirbuf1		dw	?		;128 byte directory buffer for all DPHs
dpbptr1		dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr1		dw	0		;no CSV: non-removable media
alvptr1		dw	offset alvtgb1 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb2:
xlttgb2		dw	0		;no sector translation
scratchtgb2	dw	0,0,0		;scratch pad for BDOS
dirbuf2		dw	?		;128 byte directory buffer for all DPHs
dpbptr2		dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr2		dw	0		;no CSV: non-removable media
alvptr2		dw	offset alvtgb2 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb3:
xlttgb3		dw	0		;no sector translation
scratchtgb3	dw	0,0,0		;scratch pad for BDOS
dirbuf3		dw	?		;128 byte directory buffer for all DPHs
dpbptr3		dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr3		dw	0		;no CSV: non-removable media
alvptr3		dw	offset alvtgb3 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb4:
xlttgb4		dw	0		;no sector translation
scratchtgb4	dw	0,0,0		;scratch pad for BDOS
dirbuf4		dw	?		;128 byte directory buffer for all DPHs
dpbptr4		dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr4		dw	0		;no CSV: non-removable media
alvptr4		dw	offset alvtgb4 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb5:
xlttgb5		dw	0		;no sector translation
scratchtgb5	dw	0,0,0		;scratch pad for BDOS
dirbuf5		dw	?		;128 byte directory buffer for all DPHs
dpbptr5		dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr5		dw	0		;no CSV: non-removable media
alvptr5		dw	offset alvtgb5 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb6:
xlttgb6		dw	0		;no sector translation
scratchtgb6	dw	0,0,0		;scratch pad for BDOS
dirbuf6		dw	?		;128 byte directory buffer for all DPHs
dpbptr6		dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr6		dw	0		;no CSV: non-removable media
alvptr6		dw	offset alvtgb6 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb7:
xlttgb7		dw	0		;no sector translation
scratchtgb7	dw	0,0,0		;scratch pad for BDOS
dirbuf7		dw	?		;128 byte directory buffer for all DPHs
dpbptr7		dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr7		dw	0		;no CSV: non-removable media
alvptr7		dw	offset alvtgb7 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb8:
xlttgb8		dw	0		;no sector translation
scratchtgb8	dw	0,0,0		;scratch pad for BDOS
dirbuf8		dw	?		;128 byte directory buffer for all DPHs
dpbptr8		dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr8		dw	0		;no CSV: non-removable media
alvptr8		dw	offset alvtgb8 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb9:
xlttgb9		dw	0		;no sector translation
scratchtgb9	dw	0,0,0		;scratch pad for BDOS
dirbuf9		dw	?		;128 byte directory buffer for all DPHs
dpbptr9		dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr9		dw	0		;no CSV: non-removable media
alvptr9		dw	offset alvtgb9 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb10:
xlttgb10	dw	0		;no sector translation
scratchtgb10	dw	0,0,0		;scratch pad for BDOS
dirbuf10	dw	?		;128 byte directory buffer for all DPHs
dpbptr10	dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr10	dw	0		;no CSV: non-removable media
alvptr10	dw	offset alvtgb10 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb11:
xlttgb11	dw	0		;no sector translation
scratchtgb11	dw	0,0,0		;scratch pad for BDOS
dirbuf11	dw	?		;128 byte directory buffer for all DPHs
dpbptr11	dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr11	dw	0		;no CSV: non-removable media
alvptr11	dw	offset alvtgb11 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb12:
xlttgb12	dw	0		;no sector translation
scratchtgb12	dw	0,0,0		;scratch pad for BDOS
dirbuf12	dw	?		;128 byte directory buffer for all DPHs
dpbptr12	dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr12	dw	0		;no CSV: non-removable media
alvptr12	dw	offset alvtgb12 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb13:
xlttgb13	dw	0		;no sector translation
scratchtgb13	dw	0,0,0		;scratch pad for BDOS
dirbuf13	dw	?		;128 byte directory buffer for all DPHs
dpbptr13	dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr13	dw	0		;no CSV: non-removable media
alvptr13	dw	offset alvtgb13 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb14:
xlttgb14	dw	0		;no sector translation
scratchtgb14	dw	0,0,0		;scratch pad for BDOS
dirbuf14	dw	?		;128 byte directory buffer for all DPHs
dpbptr14	dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr14	dw	0		;no CSV: non-removable media
alvptr14	dw	offset alvtgb14 - RDN00	;pointer to allocation vector
		db	0DBh 

dphtgb15:
xlttgb15	dw	0		;no sector translation
scratchtgb15	dw	0,0,0		;scratch pad for BDOS
dirbuf15	dw	?		;128 byte directory buffer for all DPHs
dpbptr15	dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr15	dw	0		;no CSV: non-removable media
alvptr15	dw	offset alvtgb15 - RDN00	;pointer to allocation vector
		db	0DBh

dphtgb16:
xlttgb16	dw	0		;no sector translation
scratchtgb16	dw	0,0,0		;scratch pad for BDOS
dirbuf16	dw	?		;128 byte directory buffer for all DPHs
dpbptr16	dw	offset dpbtgb - RDN00	;pointer to DPB
csvptr16	dw	0		;no CSV: non-removable media
alvptr16	dw	offset alvtgb16 - RDN00	;pointer to allocation vector
		db	0DBh

;------ ALV areas for 1023 data blocks (i.e. the DSM for an 8 MB disk),
;       size = (DSM/8)+1 bytes, then rounded up to the next integer value = 129

alvtgb1		db	129 dup (0)
		db	0DBh
alvtgb2		db	129 dup (0)
		db	0DBh
alvtgb3		db	129 dup (0)
		db	0DBh
alvtgb4		db	129 dup (0)
		db	0DBh
alvtgb5		db	129 dup (0)
		db	0DBh
alvtgb6		db	129 dup (0)
		db	0DBh
alvtgb7		db	129 dup (0)
		db	0DBh
alvtgb8		db	129 dup (0)
		db	0DBh
alvtgb9		db	129 dup (0)
		db	0DBh
alvtgb10	db	129 dup (0)
		db	0DBh
alvtgb11	db	129 dup (0)
		db	0DBh
alvtgb12	db	129 dup (0)
		db	0DBh
alvtgb13	db	129 dup (0)
		db	0DBh
alvtgb14	db	129 dup (0)
		db	0DBh
alvtgb15	db	129 dup (0)
		db	0DBh
alvtgb16	db	129 dup (0)
		db	0DBh

RDN99		equ	$


;============== resident code, placed in near FIDD storage ============

;Placed in near FIDD storage in the CP/M-segment immediately following
;the resident near data right above, at offset [fidnof] plus
;the length of the resident near data, i.e. [fidnof] + RDN99 - RDN00.
;So at run time, the offsets are not the same as at assembly time:
;e.g. run time offset of RCN10 := offset RCN10 - offset RDN00 + [fidnof].

RCN00	equ	$
					;this program does not need
					; any resident code that must
					;  be put into "near" FIDD storage,
					;   i.e. we do not need any code
					;    that must be run from within the
					;     CP/M-86 code and data segment.
RCN99	equ	$

;============== end of resident data and code =========================

;============== start of transient code ===============================

r0100:
	mov	ax,cs
	mov	es,ax

	cli
	mov	ss,ax			;switch to
	mov	sp,offset mystack	; local stack
	sti

	mov	cl,25			;return current disk
	int	0e0h
	mov	curdsk,al		;save it

;-------------- intro -------------------------------------------------

r1000:
	mov	dx,offset m000		;intro
	call	dspmsg

;------ check options

;Valid options:
;V = verbose FIDD-related messages (default: no such messages)
;X = run-time messages (not recommended; default: no such messages))
;2 = use second harddisk (default: first harddisk)
;Q = show current CVV assignments (other options are ignored)
;R = same as Q, and reset statistics

	mov	bx,0			;index into file name in FCB's 1 and 2
r1005:
	mov	al,[bx][05dh]		;get option character from FCB 1
	call	chkopt

	mov	al,[bx][06dh]		;get option character from FCB 2
	call	chkopt

	inc	bx			;prepare for next option character
	cmp	bx,7			;all eight positions 0...7 scanned?
	jle	r1005			;no, not yet

	cmp	w_qry,0			;show mapping and statistics?
	jz	r1007			;no

	call	cvvqry			;yes
	
	jmp	stoprun9

;------ CVV driver already loaded for the requested harddisk?

r1007:
	mov	e6p_biosdk_drive,1	;start with drive B: = 1
r1010:
	mov	ax,'GK'			;perform ioctl function
	mov	bx,offset e6parms +1	;offset of the E6h parameters
	mov	cx,'TG'			;magic word
	mov	dx,ds			;segment of the E6h parameters

	int	0e6h			;call FIDD multiplex interrupt

	cmp	ax,'OK'			;CVV driver already loaded?
	jne	r1020			;no
	cmp	bx,'FH'			;second check
	jne	r1020			;no

	push	es			;yes, driver was found
	mov	es,cx

	mov	al,es:w_hd		;harddisk where current CVV resides
	cmp	al,w_hdreq		;same as harddisk requested now?

	pop	es

	jne	r1020			;no
	
	mov	dx,offset m001		;yes, cannot load a second CVV driver
	jmp	stoprun			; for the same harddisk
r1020:
	inc	e6p_biosdk_drive	;prepare for next drive
	cmp	e6p_biosdk_drive,16	;are we past drive P:?
	jb	r1010			;not yet, check next drive letter
r1099:
	mov	al,w_hdreq		;requested harddisk is not yet used,
	mov	w_hd,al			;CVV driver will now use it

;-------------- read master boot record -------------------------------

r1100:
	mov	ah,2
	mov	al,1
	mov	ch,0
	mov	cl,1
	mov	dh,0
	mov	dl,w_hdreq		;80h/81h
	mov	bx,offset mbrbuf
	push	cs
	pop	es
	int	13h			;read absolute sector zero
	jnc	r1199			;jump if OK

	mov	dx,offset m010
	jmp	stoprun

r1199:

;-------------- check for a CP/M-86 virtual volumes partition ---------

r1200:
	mov	bx,offset peTable
	mov	cx,4
r1210:
	cmp	byte ptr [bx][4],0BDh	;CP/M-86 virtual volumes partition?
	je	r1290
	add	bx,16			;prepare for next partition table entry
	loop	r1210

	mov	dx,offset m009		;partition type not found
	jmp	stoprun
r1290:

	mov	ax,5			;CX is 4...1
	sub	ax,cx			;AX will be 1...4

	call	calcpar			;perform important calculations, then
					; show details for partition # in AL
r1299:

;-------------- read CVV parameters in sector 3 -----------------------

r1300:

	mov	al,s3ss			;starting
	mov	dh,s3sh			; CHS values
	mov	cx,s3sc			;  of the CVV partition

;add 3 to starting CHS values of the partition, to address sector 3

	add	al,3
	cmp	al,s3es			;past ending sector?
	jbe	r1350			;no

	sub	al,s3es			;yes
	inc	dh			;next head
	cmp	dh,s3eh			;past ending head?
	jbe	r1350			;no

	sub	dh,s3eh			;yes
	inc	cx			;next cylinder

;read relative sector 3 of the CVV partition

r1350:
	xchg	ch,cl
	shl	cl,1
	shl	cl,1
	shl	cl,1
	shl	cl,1
	shl	cl,1
	shl	cl,1
	or	cl,al

	push	cs
	pop	es

	mov	bx,offset s3buf
	mov	ah,2
	mov	al,1
	mov	dl,w_hdreq

	int	13h
	jnc	r1399			;jump if OK

	mov	dx,offset m019
	jmp	stoprun
r1399:

;-------------- verify checksum ---------------------------------------

;the sum of all 256 words in the parameter sector should be zero

r1400:
	mov	ax,0
	mov	bx,offset s3buf
	mov	cx,256
r1410:
	add	ax,word ptr [bx]
	add	bx,2
	loop	r1410

	cmp	ax,0			;checksum = OK = zero?
	jz	r1499			;yes

	mov	dx,offset m022		;checksum error
	jmp	stoprun
r1499:

;-------------- check the version of CVV on the harddisk

r14a0:
	mov	al,tgbverh
	mov	si,offset m026b
	call	b2dec

	mov	al,tgbverl
	mov	si,offset m026c
	call	b2dec

	mov	ax,word ptr tgbvers	;version of CVV partition
	cmp	ax,0100h		;is it <= 1.0?
	jbe	r14a9			;yes, OK

	mov	dx,offset m026
	jmp	stoprun

r14a9:

;-------------- map virtual volumes to drive letters

r1500:
	mov	ax,s3numv
	mov	si,offset m018b
	call	w2dec

	mov	dx,offset m018		;show number of CVV's in partition
	call	dspmsg

	mov	w_numv,0

;find an unused drive letter

	mov	f50cx,-1		;start at drive A: minus 1
r1530:
	inc	f50cx			;check next drive letter
	cmp	f50cx,15		;are we past drive letter P:?
	ja	r1550			;yes, no more drive letters available

	mov	cl,50			;perform direct BIOS call: SELDSK
	mov	dx,offset f50parm
	int	0e0h

	cmp	bx,0			;is this a free drive letter?
	jz	r1540			;yes, we can use this drive letter

	jmp	r1530			;no, try next drive letter

;allocate the unused drive letter to a CVV

r1540:
	mov	al,byte ptr f50cx
	add	al,'A'
	mov	m011a,al		;show the unused drive letter

	mov	ax,w_numv
	inc	ax
	mov	si,offset m011b		;show CVV number for this drive letter
	call	w2dec

	mov	dx,offset m011
	call	dspmsg

	mov	al,byte ptr f50cx
	mov	bx,offset drvtab
	add	bx,w_numv
	mov	[bx],al			;tabulate this drive

	inc	w_numv
	mov	ax,w_numv
	cmp	ax,s3numv		;do we need more drive letters?
	jb	r1530			;yes
	jmp	r1599			;no, done

;show CVV's for which we have no drive letter available

r1550:
	mov	ax,w_numv
r1560:
	inc	ax
	push	ax

	mov	si,offset m012a
	call	w2dec

	mov	dx,offset m012
	call	dspmsg

	pop	ax

	cmp	ax,s3numv
	jb	r1560

;if no CVV's could be allocated to a drive letter, leave now

	cmp	w_numv,0		;any CVV drives created?
	jnz	r1599			;yes, continue

	mov	m014a,'0'
	mov	dx,offset m014		;no
	jmp	stoprun

r1599:

;============== more or less standard FIDD stuff starts here ==========

;-------------- check CP/M-86 version ---------------------------------

; CP/M-86 1.x BDOS call 12 returns version 2.2

r3000:
	mov	cl,12			;get version
	int	0e0h

	cmp	bx,22h			;version 2.2?
	je	r3099			;yes, OK

	mov	dx,offset m003		;invalid version
	jmp	stoprun

r3099:

;-------------- pause -------------------------------------------------

	cmp	w_verb,0		;verbose?
	jz	r4005			;no
	call	getenter
r4005:

;-------------- get CP/M-86 code and data segment ---------------------

	call	findcpmseg

;-------------- check for valid BIOS jump table at offset 2500h -------

	call	chkjumptab

;-------------- pause -------------------------------------------------

	cmp	w_verb,0		;verbose?
	jz	r4010			;no
	call	getenter
r4010:

;-------------- locate & show the FIDD storage descriptor -------------

	call	showdesc

;-------------- check total amount of FIDD storage in kilobytes -------

	call	chkfidkb

;-------------- check that the FIDD segment is above the CP/M-86 segment

	call	chkabove

;-------------- check and show near FIDD details ----------------------

	call	shownear

;-------------- check and show "non-near" FIDD details ----------------

	call	showany

;-------------- check for enough "near" FIDD storage ------------------

	call	chknear

;-------------- pause -------------------------------------------------

	cmp	w_verb,0		;verbose?
	jz	r5005			;no
	call	getenter
r5005:

;-------------- allocate [fidreqn] KB's of "near" FIDD storage --------

	call	allocnear

;-------------- allocate [fidreqa] KB's of "non-near" FIDD storage ----

	call	allocany

;-------------- relocate ----------------------------------------------

r10000:
	push	cs
	pop	ds

	mov	ax,fidnof

	add	dpbptr1,ax
	add	alvptr1,ax
	add	dpbptr2,ax
	add	alvptr2,ax
	add	dpbptr3,ax
	add	alvptr3,ax
	add	dpbptr4,ax
	add	alvptr4,ax

	add	dpbptr5,ax
	add	alvptr5,ax
	add	dpbptr6,ax
	add	alvptr6,ax
	add	dpbptr7,ax
	add	alvptr7,ax
	add	dpbptr8,ax
	add	alvptr8,ax

	add	dpbptr9,ax
	add	alvptr9,ax
	add	dpbptr10,ax
	add	alvptr10,ax
	add	dpbptr11,ax
	add	alvptr11,ax
	add	dpbptr12,ax
	add	alvptr12,ax

	add	dpbptr13,ax
	add	alvptr13,ax
	add	dpbptr14,ax
	add	alvptr14,ax
	add	dpbptr15,ax
	add	alvptr15,ax
	add	dpbptr16,ax
	add	alvptr16,ax

;adjust the offsets to the actual DPH's in the DPH table

	mov	bx,offset dphtab
	mov	cx,16
r10100:
	add	word ptr [bx],ax
	sub	word ptr [bx],offset RDN00
	add	bx,2
	loop	r10100

r10999:

;-------------- get and display INT E6h handler details ---------------

r12000:
	mov	ax,0
	mov	es,ax

	mov	ax,es:0e6h+0e6h+0e6h+0e6h	;offset current E6 handler
	mov	e6prev,ax
	mov	ax,es:0e6h+0e6h+0e6h+0e6h+2	;segment current E6 handler
	mov	e6prev+2,ax

	cmp	w_verb,0		;verbose?
	jz	r12999			;no

	mov	ax,e6prev
	mov	si,offset m013d		;show offset old INT E6h handler
	call	w2hex

	mov	ax,e6prev+2
	mov	si,offset m013c		;show segment old INT E6h handler
	call	w2hex

	mov	ax,offset e6hand
	mov	si,offset m013b		;show offset new INT E6h handler
	call	w2hex

;	mov	ax,w030c
	mov	ax,w036i
	mov	si,offset m013a		;show segment new INT E6h handler
	call	w2hex

	mov	dx,offset m013
	call	dspmsg
r12999:

;-------------- move resident data and code to non-near FIDD memory ---

r21000:
	mov	si,100h

	mov	di,100h
	mov	es,[w036i]

	mov	cx,RCA99 - RDA00
	jcxz	r21999

	cld
	rep	movsb
r21999:

;-------------- move resident data and code to near FIDD memory -------

r22000:
	mov	si,offset RDN00

	mov	di,[fidnof]
	mov	es,[cpmseg]

	mov	cx,RCN99 - RDN00
	jcxz	r22999

	cld
	rep	movsb

r22999:

;-------------- activate new handler for interrupt E6h ----------------

r25000:
	mov	ax,0
	mov	es,ax

	cli
	mov	ax,offset e6hand
	mov	es:0e6h+0e6h+0e6h+0e6h,ax	;offset new handler
	mov	ax,w036i
	mov	es:0e6h+0e6h+0e6h+0e6h+2,ax	;segment new handler
	sti

r25999:

;-------------- change CP/M-86 system drive (boot drive, at 24B7h)

r26000:
	cmp	w_bdrv,0			;change boot drive?
	jz	r26999				;no,done

	cmp	w_numv,0			;any CVV-drives created?
	jz	r26999				;no, done

	mov	es,cpmseg

	mov	al,es:[24B7h]			;old BDOS boot drive
	mov	m025a,al
	add	m025a,'A'

	mov	al,[drvtab]
	mov	m025b,al
	add	m025b,'A'
	mov	es:[24B7h],al			;new BDOS boot drive 

	mov	dx,offset m025
	call	dspmsg				;show it

r26999:

;-------------- bye ---------------------------------------------------

r99000:

	mov	cl,13			;reset disk system (flush buffers);
	int	0e0h			;used to activate new CSV's and ALV's

	mov	ax,w_numv
	mov	si,offset m014a
	call	w2dec

	cmp	w_verb,0		;verbose?
	jz	r99010			;no

	call	rptstak			;report stack usage

r99010:
	mov	dx,offset m014		;program ended succesfully
	jmp	stoprun

r99999:

;-------------- end this program --------------------------------------

stoprun:

	mov	cl,9
	int	0e0h			;display message at DX

stoprun2:
	mov	cl,14			;select disk
	mov	dl,curdsk
	int	0e0h

stoprun9:
	mov	cl,0			;return to CCP
	mov	dl,0			;free our memory
	int	0e0h

;----------------------------------------------------------------------
;Show current CVV mappings and statistics

cvvqry:

	mov	dx,offset m020		;show header
	call	dspmsg

;scan all drives A: through P:

	mov	e6p_biosdk_drive,0	;start with 0 = drive A:
cvvq10:
	mov	ax,'GK'			;perform ioctl function
	mov	bx,offset e6parms +1	;offset of the E6h parameters
	mov	cx,'TG'			;magic word
	mov	dx,ds			;segment of the E6h parameters

	int	0e6h			;call FIDD multiplex interrupt

	cmp	ax,'OK'			;CVV driver already loaded for drive?
	je	cvvq12			;maybe...
	jmp	cvvq20			;no
cvvq12:
	cmp	bx,'FH'			;check the second magic word
	je	cvvq14			;yes, driver found for drive
	jmp	cvvq20			;no, driver not found for this drive

cvvq14:
	inc	n_cvv			;one more CVV found

;The ioctl call returns CX = code segment of the driver for the drive letter
;we asked for.
;Read the data from the driver's code segment immediately after the ioctl
;call - as it will be changed by any following call to the driver program
;(either an ioctl call, or a disk-related call by CP/M-86).

	mov	es,cx			;code segment for driver

	cmp	es:w_hd,80h		;CVV volume on hdisk 1?
	jne	cvvq15			;no
	mov	w_cvseg1,cx		;yes, save code segment for driver
	jmp	cvvq17			; for hdisk 1
cvvq15:
	cmp	es:w_hd,81h		;CVV volume on hdisk 2?
	jne	cvvq17			;no, ignore
	mov	w_cvseg2,cx		;yes, save code segment for driver for
					; hdisk 2
cvvq17:
	mov	al,es:w_cdrv		;0...15 is A:...P:
	add	al,'A'
	mov	m021a,al		;show the CP/M-86 drive letter

	mov	ax,es:w_cvv		;0...15
	inc	ax			;make it 1...16
	mov	si,offset m021b
	call	w2dec			;show the CVV number

	mov	al,es:w_hd		;80h...81h
	sub	al,80h			;make it 0...1
	add	al,'1'			;make it printable '1'...'2'
	mov	m021c,al		;show the harddisk number

	mov	dx,offset m021		;show drive mapping data
	call	dspmsg

cvvq20:
	inc	e6p_biosdk_drive	;prepare for next drive
	cmp	e6p_biosdk_drive,16	;are we past drive P:?
	jae	cvvq30			;yes
	jmp	cvvq10			;no, check next drive letter

cvvq30:
	cmp	n_cvv,0			;any CVV's found?
	jnz	cvvq40			;yes

	mov	dx,offset m016		;no, driver not loaded, tell it
	call	dspmsg
	jmp	cvvq99			;done

;now arrange for showing the buffer statistics

cvvq40:
	cmp	w_cvseg1,0		;was a CVV driver found for hdisk 1?
	jz	cvvq50			;no

	mov	dx,offset nlcr
	call	dspmsg

	call	getenter		;yes
	mov	es,w_cvseg1
	mov	m023a,'1'
	call	cvvstat			;show statistics for hdisk 1

cvvq50:
	cmp	w_cvseg2,0		;was a CVV driver found for hdisk 2?
	jz	cvvq60			;no

	mov	dx,offset nlcr
	call	dspmsg

	call	getenter		;yes
	mov	es,w_cvseg2
	mov	m023a,'2'
	call	cvvstat			;show statistics for hdisk 2

cvvq60:
	cmp	w_reset,0		;statistics reset?
	jz	cvvq99			;no

	mov	dx,offset m024		;yes, tell it
	call	dspmsg

cvvq99:
	ret

;----------------------------------------------------------------------
;Show CVV buffer statistics for a harddisk

;ES = data segment of the CVV driver for harddisk 1 or harddisk 2

cvvstat:

	mov	ax,word ptr es:n_r
	mov	dx,word ptr es:n_r +2
	mov	si,offset m023b
	call	d2dec

	mov	ax,word ptr es:n_r_snib
	mov	dx,word ptr es:n_r_snib +2
	mov	si,offset m023c
	call	d2dec

	mov	ax,word ptr es:n_r_bfbr
	mov	dx,word ptr es:n_r_bfbr +2
	mov	si,offset m023d
	call	d2dec

	mov	ax,word ptr es:n_w
	mov	dx,word ptr es:n_w +2
	mov	si,offset m023e
	call	d2dec

	mov	ax,word ptr es:n_wn
	mov	dx,word ptr es:n_wn +2
	mov	si,offset m023f
	call	d2dec

	mov	ax,word ptr es:n_wn_snib
	mov	dx,word ptr es:n_wn_snib +2
	mov	si,offset m023g
	call	d2dec

	mov	ax,word ptr es:n_wn_bfbw
	mov	dx,word ptr es:n_wn_bfbw +2
	mov	si,offset m023h
	call	d2dec

	mov	ax,word ptr es:n_wu
	mov	dx,word ptr es:n_wu +2
	mov	si,offset m023i
	call	d2dec

	mov	ax,word ptr es:n_wu_snib
	mov	dx,word ptr es:n_wu_snib +2
	mov	si,offset m023j
	call	d2dec

	mov	ax,word ptr es:n_wu_bfbw
	mov	dx,word ptr es:n_wu_bfbw +2
	mov	si,offset m023k
	call	d2dec

	mov	ax,word ptr es:n_wd
	mov	dx,word ptr es:n_wd +2
	mov	si,offset m023l
	call	d2dec

	mov	ax,word ptr es:n_wd_snib
	mov	dx,word ptr es:n_wd_snib +2
	mov	si,offset m023m
	call	d2dec

	mov	ax,word ptr es:n_wd_bfbw
	mov	dx,word ptr es:n_wd_bfbw +2
	mov	si,offset m023n
	call	d2dec

	push	es
	mov	dx,offset m023
	call	dspmsg			;show all statistics
	pop	es

	cmp	w_reset,0		;reset statistics?
	jz	cvvst99			;no, done

	mov	al,0			;yes
	mov	di,offset n_start

	mov	cx,offset n_end - offset n_start	;reset counters
	cld
	rep	stosb

	mov	es:w_verbx,0		;turn of run-time messages

cvvst99:
	ret

;----------------------------------------------------------------------
;Show a partition table entry
;
;On entry: AL = partition number (1...4)
;
;NOTE: This routine also performs some essential calculations before showing
;      the actual partition data. So this routine must always be called.

calcpar:
	mov	m004a,al		;1...4
	add	m004a,30h		;'1'...'4'

;BX := address of partition table entry

	dec	al			;0...3
	cbw
	mov	cl,4			;AX := AX * 16
	shl	ax,cl			;0...48

	mov	bx,offset peTable
	add	bx,ax			;BX = offset of partition table entry

;start cylinder
	mov	al,[bx][3]		;C bits 7...0
	mov	ah,[bx][2]		;C bits 9...8 are in bits 7...6
	mov	cl,6
	shr	ah,cl			;C bits 9...8 now in bits 1...0
	mov	s3sc,ax
	mov	si,offset m004b
	call	w2dec

;start head
	mov	al,[bx][1]		;H
	mov	s3sh,al
	mov	si,offset m004c
	call	b2dec

;start sector
	mov	al,[bx][2]		;S
	and	al,03fh			;bits 5...0
	mov	s3ss,al
	mov	si,offset m004d
	call	b2dec

;end cylinder
	mov	al,[bx][7]		;C bits 7...0
	mov	ah,[bx][6]		;C bits 9...8 are in bits 7...6
	mov	cl,6
	shr	ah,cl			;C bits 9...8 now in bits 1...0
	mov	s3ec,ax
	mov	si,offset m004f
	call	w2dec

;end head
	mov	al,[bx][5]		;H
	mov	s3eh,al
	mov	si,offset m004g
	call	b2dec

;end sector
	mov	al,[bx][6]		;S
	and	al,03fh			;bits 5...0
	mov	s3es,al
	mov	si,offset m004h
	call	b2dec

;sizes
	mov	ax,[bx][8]		;start sector
	mov	dx,[bx][10]
	mov	si,offset m004e
	push	bx
	call	d2dec
	pop	bx

	mov	ax,[bx][12]		;total number of sectors
	mov	dx,[bx][14]
	mov	si,offset m004i
	push	bx
	call	d2dec
	pop	bx

;calculate size in MB's from number of sectors (shift right 11 bits)

	mov	ax,[bx][12]		;total number of 512 byte sectors
	mov	dx,[bx][14]

	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
					;DX:AX now is size in KB

	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
	shr	dx,1			;0 -> DX -> carry
	rcr	ax,1			;carry -> AX -> carry
					;DX:AX now is size in MB
	push	bx

	mov	si,offset m004j
	call	d2dec

;show 
	cmp	w_verb,0		;verbose?
	jz	calcp90			;no

	mov	dx,offset m004		;yes, show the partition data
	call	dspmsg
calcp90:

	pop	bx

	ret

;-------------- check total amount of FIDD storage in kilobytes -------

chkfidkb:

;Calculate, how many KB's of near FIDD storage we need (data plus code)

	mov	ax,RCN99-RDN00		;required near storage in bytes
	mov	bx,ax			; also in BX
	mov	cl,10
	shr	ax,cl			;make it KB's

	test	bx,03ffh		;exact multiple of kilobytes?
	jz	cfk05			;yes
	inc	ax			;no, round up to the next kilobyte
cfk05:
	mov	fidreqn,ax		;save it

;Calculate, how many KB's of non-near FIDD storage we need.

	mov	ax,RCA99-RDA00		;required storage in bytes
	mov	bx,ax			; also in BX
	mov	cl,10
	shr	ax,cl			;make it KB's

	test	bx,03ffh		;exact multiple of kilobytes?
	jz	cfk07			;yes
	inc	ax			;no, round up to the next kilobyte
cfk07:
	mov	fidreqa,ax		;save it

;show what we need

	mov	ax,fidreqn
	add	ax,fidreqa		;show total KB's needed
	mov	si,offset m071a
	call	w2dec

	mov	ax,fidreqn		;show near KB's needed
	mov	si,offset m071b
	call	w2dec

	mov	ax,fidreqa		;show non-near KB's needed
	mov	si,offset m071c
	call	w2dec

	cmp	w_verb,0		;verbose?
	jz	cfk10			;no

	mov	dx,offset m071		;show our FIDD storage requirements
	call	dspmsg
cfk10:

;is there enough of FIDD storage?

	mov	ax,fidreqn
	add	ax,fidreqa		;required FIDD KBs (near plus non-near)
	cmp	ax,fidsize		;is it enough?
	jbe	cfk99			;yes, continue

	mov	si,offset m008a		;show total required FIDD size in KB
	call	w2dec

	mov	ax,fidsize
	mov	si,offset m008b		;show available FIDD size in KB
	call	w2dec

	mov	dx,offset m008		;not enough FIDD storage
	jmp	stoprun

cfk99:
	ret

;-------------- about FIDDS -------------------------------------------

comment %

The ultimate reference about FIDDS would be the Digital Research
application note "CP/M-86 FIDDS for the IBM PC" but that note seems to
have been lost in the dust of ages. If you come across it, please post it
in the internet news group "comp.os.cpm" on the internet and/or email me a
copy at fheite@knoware.nl.

Based on some disassembly of the BIOS-part of CP/M-86, I think that there 
are two aspects of FIDDs (= Field Installable Device Drivers):

1. FIDD storage, as explained below. This gives a way to store a device
   driver, resident program etc.

2. The FIDD interrupt 0E6h, described far above in this program. This
   provides a mechanism for the communication between the CP/M-86 BIOS and
   a device driver - as far as that driver is for a block storage device such
   as a ramdisk, harddisk or diskette.

What follows, is my personal interpretation of FIDD storage, from a developer's
point of view:

In their version 1.1 of CP/M-86 for the IBM PC and XT, Digital Research
added a way to reserve, at boot time, from 1 to 99 KB of the RAM memory
in the PC for use by so-called "Field Installable Device Drivers" or FIDD
programs. 

The standard CP/M-86-supplied program SETUP.CMD is used to reserve a
certain amount of this FIDD storage and to write that amount - along with
other CP/M-86 configuration data - to track 0, sector 2 of a boot diskette
or to some (yet unknown to me) place on a harddisk CP/M partition.

When CP/M-86 is booted, the configuration data is read from the boot disk,
and the configured amount of FIDD memory is allocated right behind the
memory that the CP/M-86 BIOS needs for its own code and data, its disk
buffers etc.

The FIDD memory is never released or reused by CP/M-86 so it's a rather
safe place to store device drivers, resident programs etc.

Where to find details about the FIDD memory? At offset 2556h within the
BIOS part of CP/M-86, a few bytes after the BIOS jump table at offset 2500h,
is a near (16-bit) pointer to a "FIDD storage descriptor". This descriptor
itself is made up of four fields (the last two of them not directly related
to storage, but what's in a name?).

1. a WORD giving the size of the FIDD storage in KB's, range 0...99
   (although a WORD, SETUP.CMD only allows values in the range 0...99). 

2. a WORD giving the segment address of the first byte of FIDD storage
   (assuming a zero offset).

3. a WORD giving the offset within the CP/M-86 segment of a 128 byte work
   area commonly called DIRBUF, used for directory operations within the
   CP/M BDOS. This area is used for all disk devices in the system - both
   native devices supported by the CP/M-86 BIOS and non-native devices that
   are controlled through a FIDD device driver; the FIDD device driver can use 
   this system-wide DIRBUF so it doesn't need to reserve its own 128 bytes.

4. a Diskette Parameter Table (DPT). A DPT is 11 bytes long, it tells the
   PC-ROM-BIOS diskette routines (interrupt 13h) some low-level technical
   details about how to handle diskette operations (e.g. the number of sectors
   on a track, the number of bytes in a sector, how long to wait for the
   diskette drive motor to reach its working speed, etc.). 

A program can allocate some (or all) of the FIDD storage to safely store
some resident code for e.g. a "device driver" like this program, or
a "resident program" like a screen saver. As CP/M-86 does not provide an
interface to mark some part of FIDD storage as "in use", the application
itself is responsible for manipulating the FIDD storage descriptor.

Basically, there are two ways to allocate some FIDD storage:
 
1. use some KB's of FIDD storage at the end of the FIDD storage area, and
   decrement the first word of the FIDD descriptor with the number of KB's
   you want to use.

2. use some KB's of FIDD storage at the beginning of the FIDD storage area,
   decrement the first word of the FIDD descriptor with the number of KB's
   you want to use, and finally increment the second word of the FIDD
   descriptor with the number of paragraphs you want to use (a paragraph
   is 16 bytes, so multiply your amount of KB's with 64, then add that
   value to the second word in the FIDD storage descriptor).

Btw, as a matter of good housekeeping, you should always set the FIDD
segment to zero if you have allocated all available FIDD memory - whether
you use method 1. or method 2.

As said before, there are two ways to allocate some FIDD storage. Which one
to chose? Methode 2. is probably the simplest, as method 1. might involve
more arithmetic in case the FIDD storage is more than 64 KB (and thus
a segment boundary must be crossed).

But there is more to consider. If you are loading a device driver for
some kind of disk device (ramdisk, harddisk, diskette, whatever), you must
make available to CP/M-86 some data structures describing this disk
device: a DPH, a DPD, room for allocation vectors and directory check
vectors. As a CP/M-86 BIOS can only handle "near pointers" i.e. 16-bits offsets
to these structures, these data structures MUST reside in a part of the
FIDD storage that can be addressed using the segment value that CP/M-86 is
using for its own code, data etc.

So it is necessary that the first KB's of FIDD storage can be addressed
(reached) from the CP/M-86 code and data segment.

 +----------------------------------+
 |0K                             64K|
 |                                  | the CP/M segment
 |                                  |
 +----------------------------------+
                       .            .
                       .            .
                       .            .
                       +----------------------------------+
                       |0K          .                  99K|
                       |   near     .       non-near      | the FIDD segment
                       |            .                     |
                       +----------------------------------+

The part of FIDD memory that can also be adressed with the CP/M segment,
will be called "near" FIDD storage - as it is near the CP/M segment. The
rest of the FIDD storage, up to the maximum value of 99 KB, will be called
"non-near" FIDD storage or "any" FIDD storage.

Basically, "near" FIDD storage is a scarse resource. In a standard CP/M-86
system with only a diskette drive it cannot be more than about 44 KB. If
the system also has a harddisk with a CP/M-partition on it, there is at
most about 40 KB of "near" FIDD storage. If that is not enough for your
application, you are out of luck - you cannot change the amount of "near"
FIDD storage as you cannot influence the amount of memory that is unused
at the end of the CP/M segment.

You could further increase the total amount of FIDD storage, up to 99 KB, but
that only increases the amount of "non-near" FIDD storage. It would make
the FIDD box in the figure above just extend more to the right.

All this means that you should allocate "non-near" FIDD storage whenever
possible, and allocate the "near" FIDD storage only when needed. Consider
that the user might want to load more FIDD programs than just the one you
are developing. If your full-blown screen saver program would allocate all
KB's of "near" storage, the user would not be able to load a ramdisk
device driver afterwards. But the ramdisk program _must_ have some "near"
storage for its DPH, DPB etc., while a screensaver (very probably) can
reside everywhere in memory and would very well function when running from
"non-near" storage.

Below are the routines this program uses for calculating, displaying,
and allocating both types of FIDD storage. As said before, the value of
the FIDD segment can easily be located once the value of the CP/M-86
segment is known. However, there is no simple way to find this value of
the CP/M-86 code and data segment. So there are additional routines for
finding and validating the CP/M-segment.

The amount of code might seem overwhelming, but most of it is just for
displaying what we are doing.

 %	;end comment

;-------------- locate & show the FIDD storage descriptor -------------

showdesc:

	mov	ax,cpmseg		;segment of the FIDD storage descriptor
	mov	si,offset m030a		;show it (normally 0051h)
	call	w2hex

	mov	es,cpmseg		;segment of the FIDD storage descriptor
	mov	bx,es:2556h		;pointer to the FIDD storage descriptor

	mov	ax,bx
	mov	si,offset m030b		;show it (normally 3AC0h)
	call	w2hex
	
	mov	ax,es:[bx]		;size of FIDD storage in KB (0...99)
	mov	fidsize,ax

	mov	si,offset m030d		;show it (varying, depends on the value
	call	w2dec			; placed on the boot disk by SETUP.CMD)

	mov	ax,es:[bx+2]		;segment of FIDD storage
	mov	fidseg,ax
	mov	w030c,ax

	mov	si,offset m030c		;show it (varying, depends on the size
	call	w2hex			; and number of disk drives in system)

	mov	ax,cpmseg		;segment of DIRBUF area
	mov	si,offset m030i		;show it (normally 0051h)
	call	w2hex

	mov	ax,es:[bx+4]		;offset of DIRBUF within CP/M segment
	mov	dirbuf1,ax
	mov	dirbuf2,ax
	mov	dirbuf3,ax
	mov	dirbuf4,ax

	mov	dirbuf5,ax
	mov	dirbuf6,ax
	mov	dirbuf7,ax
	mov	dirbuf8,ax

	mov	dirbuf9,ax
	mov	dirbuf10,ax
	mov	dirbuf11,ax
	mov	dirbuf12,ax

	mov	dirbuf13,ax
	mov	dirbuf14,ax
	mov	dirbuf15,ax
	mov	dirbuf16,ax

	mov	si,offset m030j
	call	w2hex			;show it (normally 4BE2h)

;show where the FIDD memory is located

	mov	ax,fidseg		;start segment of FIDD storage
					; (offset is zero)
	mov	si,offset m030e		;show it
	call	w2hex

	mov	ax,fidseg
	mov	bx,fidsize
	cmp	bx,64			;more than 64 KB?
	jbe	showd10			;no

	add	ax,1000h		;yes, add 64 KB to end segment value
	sub	bx,64			;subtract 64 KB from size
showd10:

	mov	w030g,ax
	mov	si,offset m030g		;show end segment of FIDD storage
	call	w2hex

	mov	ax,bx
	mov	cl,10			;from KB's
	shl	ax,cl			; to bytes
	dec	ax			;minus 1 byte

	cmp	fidsize,0		;is FIDD size zero?
	jnz	showd20			;no
	mov	ax,0			;yes, show end offset as zero
showd20:

	mov	w030h,ax
	mov	si,offset m030h		;show end offset of FIDD memory
	call	w2hex

	cmp	w_verb,0		;verbose?
	je	showd99			;no

	mov	dx,offset m030		;display FIDD storage info
	call	dspmsg

showd99:
	ret

;-------------- check that the FIDD segment is above the CP/M-86 segment

;N.B. The FIDD segment is zero when CP/M-86 has no FIDD memory configured.

chkabove:

	mov	ax,fidseg
	cmp	ax,cpmseg		;FIDD segment above CP/M-86 segment?
	ja	cabo99			;yes, OK
					;no, strange....

	mov	si,offset m083a		;show FIDD segment
	call	w2hex

	mov	ax,cpmseg		;show CP/M-86 segment
	mov	si,offset m083b
	call	w2hex

	mov	dx,offset m083		;FIDD segment not above CP/M-86 segment
	jmp	stoprun

cabo99:
	ret

;-------------- check and show near FIDD details ----------------------

;Isn't it amazing how many things you can tell about only two segments
;and a handful of kilobytes?

shownear:

;Fill in some values we already know: CP/M-86 segment and FIDD segment

	mov	ax,fidseg
	mov	si,offset m031b
	call	w2hex

	mov	ax,fidseg
	mov	si,offset m031d
	call	w2hex

	mov	ax,cpmseg
	mov	si,offset m031f
	call	w2hex

	mov	ax,cpmseg
	mov	si,offset m031h
	call	w2hex

;Calculate the amount of "near" FIDD storage in KB's. The difference between
;the FIDD segment and the CP/M-86 segment is subtracted from 64 KB, giving
;the theoretical maximum for the amount of "near" FIDD storage. If the actual
;amount of FIDD storage is below the theoretical maximum, all available
;FIDD storage qualifies as "near".

	mov	ax,fidseg		;calculate FIDD segment
	sub	ax,cpmseg		; minus the CP/M-86 segment
	mov	bx,ax			;save result in BX

	mov	cl,6			;convert from 16 byte paragraphs
	shr	ax,cl			; to 1024 byte KB's

	test	bx,003fh		;exact multiple of kilobytes?
	jz	shon05			;yes
	inc	ax			;no, round up to the next kilobyte
shon05:

	cmp	ax,64			;is the difference between CP/M-86
	jb	shon08			; segment and FIDD-segment >= 64 KB?

	mov	w031a,0			;yes, so there's no "near" FIDD storage

	cmp	w_verb,0		;verbose?
	jz	shon99			;no

	mov	dx,offset m032
	call	dspmsg
	jmp	shon99

shon08:
	neg	ax			;calculate 64 KB minus AX, so AX :=
	add	ax,64			; theoretical max. near FIDD storage

	cmp	ax,fidsize		;larger than available FIDD storage?
	jbe	shon10			;no
	mov	ax,fidsize		;yes, reduce to what's actually present
shon10:
	mov	w031a,ax		;available "near" FIDD storage in KB's
	mov	si,offset m031a
	call	w2dec

	mov	ax,w031a		;available "near" FIDD storage in KB's
	mov	cl,10
	shl	ax,cl			;from KBs to bytes
	dec	ax			;minus 1
	mov	w031e,ax
	mov	si,offset m031e
	call	w2hex

;Now calculate the offsets within the CP/M-86 segment of this near FIDD storage

	mov	ax,fidseg
	sub	ax,cpmseg

	mov	cl,4			;from paragraphs
	shl	ax,cl			; to bytes
	mov	bx,ax			;BX = AX = offset of first "near" byte
	mov	fidnof,ax

	mov	si,offset m031g
	call	w2hex

	mov	ax,w031a		;available "near" FIDD storage in KB's
	mov	cl,10			;from KB's
	shl	ax,cl			; to bytes

	add	ax,bx			;AX := offset of last "near" byte
	dec	ax			;minus 1
	mov	si,offset m031i
	call	w2hex

	cmp	w_verb,0		;verbose?
	jz	shon99			;no

	mov	dx,offset m031		;show "near" FIDD storage details
	call	dspmsg

shon99:
	ret

;-------------- check and show "non-near" FIDD details ----------------

showany:

	mov	ax,fidsize		;total FIDD size in KB
	sub	ax,w031a		; minus near FIDD size in KB
					;  gives non-near FIDD size in KB

	cmp	ax,0			;is it 0 KB?
	jnz	shoa10			;no

	cmp	w_verb,0		;verbose?
	jz	shoa99			;no

	mov	dx,offset m034		;no "non-near" FIDD storage
	call	dspmsg
	jmp	shoa99

shoa10:
	mov	si,offset m033a		;amount of non-near FIDD storage
	call	w2dec

	mov	ax,fidseg		;start segment of non-near FIDD storage
	mov	si,offset m033b
	call	w2hex

	mov	ax,w031e		;start offset of non-near FIDD storage
	inc	ax			;plus 1

	cmp	w031a,0			;but: w031e is undefined if there is
	jnz	shoa15			; no near storage available.
	mov	ax,0			;  In that case, AX := 0.
shoa15:
	mov	si,offset m033c
	call	w2hex

	mov	ax,w030g		;end segment of FIDD storage
	mov	si,offset m033d
	call	w2hex

	mov	ax,w030h		;end offset of FIDD storage
	mov	si,offset m033e
	call	w2hex

	cmp	w_verb,0		;verbose?
	jz	shoa99			;no

	mov	dx,offset m033		;show "non-near" FIDD storage details
	call	dspmsg

shoa99:
	ret

;-------------- check for enough "near" FIDD storage ------------------

chknear:

	mov	ax,fidreqn
	cmp	ax,0			;any "near" FIDD storage required?
	jz	chkn99			;no

	cmp	ax,w031a		;is there enough "near" storage?
	jbe	chkn99			;yes

	mov	dx,offset m007
	call	dspmsg
	jmp	stoprun

chkn99:
	ret

;-------------- allocate "near" FIDD storage --------------------------

;This routine assumes that the required amount of storage is indeed available.

allocnear:

	cmp	fidreqn,0		;do we need any "near" storage?
	jnz	alln10			;yes, proceed
	jmp	alln99			;no, done

;Show allocation details

alln10:
	mov	ax,fidreqn
	mov	si,offset m035a
	call	w2dec

	mov	ax,fidseg
	mov	si,offset m035b
	call	w2hex

	mov	ax,fidseg
	mov	si,offset m035d
	call	w2hex

	mov	ax,cpmseg
	mov	si,offset m035f
	call	w2hex

	mov	ax,cpmseg
	mov	si,offset m035h
	call	w2hex

	mov	ax,fidreqn		;required "near" FIDD storage
	mov	cl,10			; from KB's
	shl	ax,cl			;  to bytes

	dec	ax			;minus 1
	mov	bx,ax			;save it
	mov	si,offset m035e
	call	w2hex

	mov	ax,fidnof
	mov	si,offset m035g
	call	w2hex

	mov	ax,fidnof
	add	ax,bx			;required storage in bytes, minus 1
	mov	si,offset m035i
	call	w2hex

;Now, calculate and update the FIDD storage descriptor by
;- converting the number of required KB's to paragraphs, then adding that
;  value to the FIDD segment value
;- and subtracting the number of required KB's from the FIDD size.


	mov	ax,fidsize		;old FIDD size in KB
	sub	ax,fidreqn		;subtract what we need in KB
	mov	fidnsize,ax		;new FIDD size in KB

	mov	si,offset m035k		;show it
	call	w2dec

	mov	ax,fidreqn		;required FIDD size in KB
	mov	cl,6			;convert from KB
	shl	ax,cl			; to 16 byte paragraphs
	add	ax,fidseg		;add old FIDD segment
	mov	fidnseg,ax		;new FIDD segment

	cmp	fidnsize,0		;is the new FIDD size zero?
	jnz	alln20			;no
	mov	fidnseg,0		;yes, set new FIDD segment to zero

alln20:
	mov	ax,fidnseg		;new FIDD segment
	mov	si,offset m035j		;show it
	call	w2hex

	cmp	w_verb,0		;verbose?
	jz	alln90			;no

	mov	dx,offset m035		;show allocation details etc.
	call	dspmsg

alln90:
	call	updfid			;update the FIDD storage descriptor

alln99:
	ret

;-------------- allocate "non-near" FIDD storage ----------------------

;This routine assumes that the required amount of storage is indeed available.

allocany:

	cmp	fidreqa,0		;do we need any "non-near" storage?
	jnz	alla10			;yes, proceed
	jmp	alla99			;no, done

;Show allocation details

alla10:
	mov	ax,fidreqa
	mov	si,offset m036a
	call	w2dec

	mov	bx,fidreqa		;non-near storage we need
	mov	cl,10			; from KB's
	shl	bx,cl			;  to bytes

	mov	ax,w030h		;offset of the very last FIDD byte

	sub	ax,bx			;calculate offset of first byte to
					; be allocated as "offset of very last
					; FIDD byte" minus "the number of
					; bytes we need".

	inc	ax			;plus 1
	mov	w036c,ax
	mov	si,offset m036c
	call	w2hex

	mov	ax,w030g		;segment of the first byte to allocate

	mov	bx,fidsize
	cmp	bx,64			;is FIDD size 64 KB or less?
	jbe	alla20			;yes
	sub	bx,64			;no
	cmp	bx,fidreqa		;requesting more than (size - 64 KB)?
	jae	alla20			;no
	sub	ax,1000h		;yes, adjust segment

alla20:
	mov	w036b,ax
	mov	si,offset m036b
	call	w2hex

	mov	ax,w030g
	mov	si,offset m036d
	call	w2hex

	mov	ax,w030h
	mov	si,offset m036e
	call	w2hex

;Calculate start of area to be allocated, when using an offset of zero.

	mov	ax,w036b		;segment

	mov	bx,w036c		;divide offset by 16 (its rightmost
	mov	cl,4			; digit is a 0 so we won't lose data)
	shr	bx,cl

	add	ax,bx			;add (offset/16) to segment
	push	ax

	mov	si,offset m036f		;actual start segment
	call	w2hex

	pop	ax			;segment

	mov	bx,fidreqa		;KB's we need
	cmp	bx,64			;more than 64 KB?
	jbe	alla40			;no

	add	ax,1000h		;yes, add 64 KB to end segment value
	sub	bx,64			;subtract 64 KB from size
alla40:

	mov	si,offset m036g		;actual end segment
	call	w2hex

	mov	cl,10			;from KB's
	shl	bx,cl			; to bytes
	dec	bx			;minus 1
	mov	ax,bx
	mov	si,offset m036h		;actual end offset
	call	w2hex

;Calculate start of area to be allocated, when using an offset of 100h.

	mov	ax,w036b		;segment

	mov	bx,w036c		;divide offset by 16 (its rightmost
	mov	cl,4			; digit is a 0 so we won't lose data)
	shr	bx,cl

	add	ax,bx			;add (offset/16) to segment
	sub	ax,10h			;subtract 16 paragraphs = 100h bytes
	push	ax

	mov	w036i,ax
	mov	si,offset m036i		;actual start segment
	call	w2hex

	pop	ax			;segment

	mov	bx,fidreqa		;KB's we need
	cmp	bx,64			;more than 64 KB?
	jbe	alla50			;no

	add	ax,1000h		;yes, add 64 KB to end segment value
	sub	bx,64			;subtract 64 KB from size
alla50:

	mov	si,offset m036j		;actual end segment
	call	w2hex

	mov	cl,10			;from KB's
	shl	bx,cl			; to bytes
	dec	bx			;minus 1
	add	bx,100h			;account for the offset of 100h

	mov	ax,bx
	mov	si,offset m036k		;actual end offset
	call	w2hex

;The FIDD storage descriptor is updated by
;- subtracting the number of required KB's from the FIDD size.

	mov	ax,fidseg		;the FIDD segment is not changed, but
	mov	si,offset m036l		; display it anyway.
	call	w2hex

	mov	ax,fidseg		;FIDD segment
	mov	fidnseg,ax		; is not changed

	mov	ax,fidsize		;FIDD size
	sub	ax,fidreqa		;subtract what we need in KB
	mov	fidnsize,ax		;new FIDD size in KB
		
	mov	si,offset m036m		;show it
	call	w2dec

	cmp	w_verb,0		;verbose?
	jz	alla90			;no

	mov	dx,offset m036		;show allocation details etc.
	call	dspmsg

alla90:
	call	updfid			;update the FIDD storage descriptor

alla99:
	ret

;-------------- update the FIDD storage descriptor --------------------

;New FIDD segment is in <fidnseg>, new FIDD size is in <fidnsize>.

updfid:

	push	es

	mov	es,cpmseg		;the cpm segment
	mov	bx,es:2500h + 56h	;pointer to FIDD storage descriptor

	mov	ax,fidnsize
	mov	fidsize,ax		;update our working storage
	mov	es:[bx],ax		;new FIDD size in KB

	cmp	ax,0			;if the new FIDD size is zero, then
	jnz	updf10			; also set the FIDD segment to zero
	mov	fidnseg,0
updf10:

	mov	ax,fidnseg
	mov	fidseg,ax		;update our working storage
	mov	es:[bx][2],ax		;new FIDD segment

updf99:
	pop	es
	ret

;-------------- display message$ [DX] on the console ------------------

dspmsg:

	push	ds

	push	cs
	pop	ds

	mov	cl,9			;display string
	int	0e0h

	pop	ds

dspmsg99:
	ret

;-------------- hit ENTER to continue or ctrl-C to stop ---------------

getenter:

	push	ds

	push	cs
	pop	ds

	mov	dx,offset m015		;press enter or control-c
	mov	cl,9			;display string
	int	0e0h

getent10:
	mov	dl,0ffh			;console input
	mov	cl,6			;direct console I/O
	int	0e0h

	cmp	al,0dh			;enter?
	je	getent99		;yes, done

	cmp	al,3			;control-c?
	jne	getent10		;no
	jmp	stoprun2		;yes

getent99:
	pop	ds

	ret

;-------------- check command line option character in AL -------------

chkopt:

	cmp	al,' '		;blank?
	jne	chkop05		;no
	jmp	chkop99		;yes, ignore it, return

chkop05:
	cmp	al,'a'
	jb	chkop10
	cmp	al,'z'
	ja	chkop10
	sub	al,'a'-'A'	;make uppercase

chkop10:
	cmp	al,'V'		;verbose option?
	jne	chkop20		;no
	mov	w_verb,1	;yes
	jmp	chkop99		;return
chkop20:
	cmp	al,'X'		;run-time messages?
	jnz	chkop30		;no
	mov	w_verbx,1	;yes
	jmp	chkop99		;return
chkop30:
	cmp	al,'Z'		;set boot drive?
	jnz	chkop40		;no
	mov	w_bdrv,1	;yes
	jmp	chkop99		;return
chkop40:
	cmp	al,'2'		;use second harddisk?
	jnz	chkop50		;no
	mov	w_hdreq,81h	;yes
	mov	m001a,'2'
	mov	m004z,'2'
	mov	m009a,'2'
	mov	m010a,'2'
	mov	m018a,'2'
	mov	m019a,'2'
	mov	m026a,'2'
	jmp	chkop99		;return
chkop50:
	cmp	al,'Q'		;query CVV's?
	jnz	chkop60		;no
	mov	w_qry,1		;yes
	jmp	chkop99		;return
chkop60:
	cmp	al,'R'		;query CVV's and reset statistics?
	jnz	chkop90		;no
	mov	w_qry,1		;yes
	mov	w_reset,1
	jmp	chkop99		;return
chkop90:
	mov	m002a,al	;report an invalid option
	mov	dx,offset m002
	jmp	stoprun

chkop99:
	ret

;-------------- report stack usage --------------------------------

rptstak:
	push	cs
	pop	es			;scan memory at ES:DI

	mov	di,offset endstak

	cld
	mov	ax,'hf'			;scan for word 'fh'
	mov	cx,STAKSIZ		;scan max. STAKSIZ words
	repe	scasw		

	mov	ax,cx			;stack usage in words
	add	ax,cx			;stack usage in bytes	
	mov	si,offset m017a		;print AX in dec
	call	w2dec
	
	mov	cl,9			;print stack usage
	mov	dx,offset m017
	int	0e0h

	ret

;--------- find CP/M-86 code and data segment -------------------------

; In a "standard" CP/M-86 system, the CP/M-86 code and data segment is 
; at 0051h. To be sure, we sample some data in the system.

; The following values are obtained:
;
; cpmseg1 segment for INT E0h from interrupt table
; cpmseg2 segment for INT E6h from interrupt table
; cpmseg3 segment returned by BDOS call 27 get addr(alloc)
; cpmseg4 segment returned by BDOS call 31 get addr(dpb)
; cpmseg5 segment returned by BDOS call 49 get addr(sysvars)
; cpmseg6 segment for INT 00h from interrupt table
; cpmseg7 segment for INT 1Bh from interrupt table
; cpmseg8 segment for INT 1Ch from interrupt table
; cpmseg9 segment for INT 1Eh from interrupt table
;
; If all these values are the same, that value is taken as the CP/M-86 segment.
;
; If not all values are the same:
;
; - if one or more of them are 0051h, the value 0051h is taken as 
;   the CP/M-86 segment;
;
; - if one or more of them are 3051h, the value 3051h is taken as 
;   the CP/M-86 segment (our DOS debugger loads CPM.SYS at segment 3051h);
;
; - otherwise, we quit as we cannot determine the value of the CP/M-86 segment.
;
; Note:
; The CP/M-86 BIOS executes an INT E2h instruction at offset 02F46, but in a
; standard system the handler for this interrupt is 0000:0000. So this CP/M-
; interrupt E2h will not help us with finding the "real" CP/M-86 segment.

findcpmseg:

	mov	ax,0
	mov	es,ax			;set ES to zero

	mov	ax,es:0e0h+0e0h+0e0h+0e0h+2
	mov	cpmseg1,ax		;segment for INT E0h

	cmp	w_verb,0		;verbose?
	je	findc10			;no

	mov	si,offset m051a
	call	w2hex
	mov	dx,offset m051
	call	dspmsg
findc10:

	mov	ax,0
	mov	es,ax			;set ES to zero

	mov	ax,es:0e6h+0e6h+0e6h+0e6h+2
	mov	cpmseg2,ax		;segment for INT E6h

	cmp	w_verb,0		;verbose?
	je	findc30			;no

	mov	si,offset m053a
	call	w2hex
	mov	dx,offset m053
	call	dspmsg
findc30:

	mov	cl,27			;get addr(alloc)
	int	0e0h
	mov	cpmseg3,es		;segment from BDOS 27

	cmp	w_verb,0		;verbose?
	je	findc40			;no

	mov	ax,es
	mov	si,offset m054a
	call	w2hex
	mov	dx,offset m054
	call	dspmsg
findc40:

	mov	cl,31			;get addr(disk parms)
	int	0e0h
	mov	cpmseg4,es		;segment from BDOS 31

	cmp	w_verb,0		;verbose?
	je	findc50			;no

	mov	ax,es
	mov	si,offset m055a
	call	w2hex
	mov	dx,offset m055
	call	dspmsg
findc50:

	mov	cl,49			;get addr(system variables)
	int	0e0h
	mov	cpmseg5,es		;segment from BDOS 49

	cmp	w_verb,0		;verbose?
	je	findc52			;no

	mov	ax,es
	mov	si,offset m056a
	call	w2hex
	mov	dx,offset m056
	call	dspmsg
findc52:

	mov	ax,0
	mov	es,ax			;set ES to zero

	mov	ax,es:0+2
	mov	cpmseg6,ax		;segment for INT 00h

	cmp	w_verb,0		;verbose?
	je	findc53			;no

	mov	si,offset m057a
	call	w2hex
	mov	dx,offset m057
	call	dspmsg
findc53:

	mov	ax,0
	mov	es,ax			;set ES to zero

	mov	ax,es:01bh+01bh+01bh+01bh+2
	mov	cpmseg7,ax		;segment for INT 1Bh

	cmp	w_verb,0		;verbose?
	je	findc54			;no

	mov	si,offset m058a
	call	w2hex
	mov	dx,offset m058
	call	dspmsg
findc54:

	mov	ax,0
	mov	es,ax			;set ES to zero

	mov	ax,es:01ch+01ch+01ch+01ch+2
	mov	cpmseg8,ax		;segment for INT 1Ch

	cmp	w_verb,0		;verbose?
	je	findc55			;no

	mov	si,offset m052a
	call	w2hex
	mov	dx,offset m052
	call	dspmsg
findc55:

	mov	ax,0
	mov	es,ax			;set ES to zero

	mov	ax,es:01eh+01eh+01eh+01eh+2
	mov	cpmseg9,ax		;segment for INT 1Eh

	cmp	w_verb,0		;verbose?
	je	findc56			;no

	mov	si,offset m05aa
	call	w2hex
	mov	dx,offset m05a
	call	dspmsg
findc56:

;All segment values have been collected. Are they all the same?

	mov	ax,cpmseg1		;get first segment value
	mov	cpmseg,ax		;assume it's correct

	mov	si,offset cpmseg2
	mov	cx,nsegs-1		;compare to the nsegs-1 other values
findc58:
	cmp	ax,[si]			;equal to first value?
	jne	findc60			;no
	add	si,2			;yes
	loop	findc58			;prepare for next value

	jmp	findc90			;all the same value, done

;Is one or more of these segment values equal to 0051h?

findc60:
	mov	cpmseg,51h		;assume 51h, which is correct 
					; in a standard CP/M-86 system
	push	ds
	pop	es
	mov	di,offset cpmseg1

	mov	cx,nsegs		;search all cpmseg values
	mov	ax,0051h

	cld
	repnz	scasw			;search for 0051h at ES:DI
	jz	findc90			;found 0051h, done

;Is one or more of these segment values equal to 3051h?

findc70:
	mov	cpmseg,3051h		;assume 3051h (we use this when
					; debugging CP/M-86 under DOS)
	push	ds
	pop	es
	mov	di,offset cpmseg1

	mov	cx,nsegs		;search all cpmseg values
	mov	ax,3051h

	cld
	repnz	scasw			;search for 3051h at ES:DI
	jz	findc90			;found 3051h, done

;Not all values the same; and we didn't find any 0051h or 3051h

	mov	dx,offset m059		;CP/M-86 segment cannot be determined
	jmp	stoprun

findc90:
	cmp	w_verb,0		;verbose?
	je	findc99			;no

	mov	ax,cpmseg		;display CP/M-86 segment value
	mov	si,offset m005a
	call	w2hex

	mov	dx,offset m005
	call	dspmsg

findc99:
	ret

;------------------- check for valid BIOS jump table at offset 2500h --

; This check is done to ensure that we've correctly located the CP/M-86
; code and data segment.
; The BIOS jump table has 21 entries. All entries are supposed to be 2-byte
; short jumps plus a NOP, or 3-byte near jumps. 

chkjumptab:

	mov	es,cpmseg
	mov	di,2500h		;offset of BIOS jump table

	mov	cx,21			;check 21 jump table entries
chkj05:
	mov	al,es:[di]
	cmp	al,0e9h			;opcode for short jump?
	je	chkj10			;yes, OK
	cmp	al,0ebh			;opcode for near jump?
	jne	chkj90			;no, error
chkj10:
	add	di,3			;prepare for next jump table entry
	loop	chkj05			
	jmp	chkj95			;OK, done

chkj90:
	mov	ax,cpmseg		;the CPM segment
	mov	si,offset m006a
	call	w2hex

	mov	ax,di			;offset where no jmp opcode was found
	mov	si,offset m006b
	call	w2hex

	mov	dx,offset m006		;invalid BIOS jump table entry
	jmp	stoprun

chkj95:
	cmp	w_verb,0		;verbose?
	je	chkj99			;no

	mov	ax,cpmseg		;the CPM segment
	mov	si,offset m061a
	call	w2hex

	mov	dx,offset m061		;BIOS jump table OK
	call	dspmsg

chkj99:
	ret

;============== end of transient code =================================


;============== start of transient data ===============================

curdsk		db	0	;current drive at program start

f50parm		equ	$	;for BDOS function 50 "direct BIOS call"
f50func		db	9	;BIOS function SELDSK
f50cx		dw	?	;drive 0=A...15=P
f50dx		dw	1	;not "first time"

w_hdreq		db	80h	;hdisk as requested on command line 80h/81h

w_verb		db	0	;0 or 1, meaning no/yes verbose output

w_qry		db	0	;1 = query CVV information
w_reset		db	0	;1 = reset statistics
w_bdrv		db	0	;1= set boot drive to first CVV drive

n_cvv		db	0	;total number of CVV's on all hard disks

w_es		dw	?	;for saving ES register

w_cvseg1	dw	0	;segment of CVV driver for hdisk 1
w_cvseg2	dw	0	;segment of CVV driver for hdisk 2

;------

fidreqn		dw	0	;number of near FIDD KB's required by this pgm:
				;some KB's for DPH, DPB etc.
				;Allocate it at the start of FIDD storage.

fidreqa		dw	0	;number of FIDD KB's required by this program,
				;that can reside anywhere in FIDD storage:
				;all code, and most of the working storage.
				;Allocate it at the high end of FIDD storage.

fidseg		dw	0	;segment for FIDD storage
fidsize		dw	0	;size of FIDD storage in KB (1024 bytes)

fidnseg		dw	0	;new segment for FIDD storage
fidnsize	dw	0	;new size of FIDD storage in KB

w030c		dw	?	;the FIDD segment before we changed it
w030g		dw	?	;segment of last byte of total FIDD storage
w030h		dw	?	;offset of last byte of total FIDD storage

w031a		dw	?	;actually available amount of near FIDD storage
w031e		dw	?	;offset of last byte of near FIDD storage

w036b		dw	?	;segment of first byte of non-near FIDD storage
				; that will be allocated (assuming offset 0)
w036c		dw	?	;offset of first byte of non-near FIDD storage
				; that will be allocated
w036i		dw	?	;segment of first byte of non-near FIDD storage
				; that will be allocated (assuming offset 100h)
;------

nsegs		equ	9	;total number of "cpm segments" checked

cpmseg1		dw	0	;segment for INT E0h (BDOS calls)
cpmseg2		dw	0	;segment for INT E6h (FIDD disk interrupt)
cpmseg3		dw	0	;segment from BDOS call 27 get addr(alloc)
cpmseg4		dw	0	;segment from BDOS call 31 get addr(dpb)
cpmseg5		dw	0	;segment from BDOS call 49 get addr(sysvars)
cpmseg6		dw	0	;segment for INT 00h (overflow)
cpmseg7		dw	0	;segment for INT 1Bh (keyboard break)
cpmseg8		dw	0	;segment for INT 1Ch (user timer tick)
cpmseg9		dw	0	;segment for INT 1Eh (diskette parameters)

;------

nlcr	db	0dh,0ah,'$'

m000	db	'CVV  - Harddisk driver for "CP/M-86 for the '
	db	'IBM PC and IBM PC XT, version 1.1"' 
	db	0dh,0ah
	db	'       CP/M Virtual Volumes - version 1.0 '
	db	'- 17Jun2001 - by Freek Heite.'
	db	0dh,0ah,'$'

m001	db	'M001 - CVV virtual volume driver is already active for '
	db	'harddisk '
m001a	db	'1.'
	db	0dh,0ah,'$'

m002	db	'M002 - Sorry, invalid program option '
m002a	db	'? given. Valid options: 2 Q R V X Z.'
	db	0dh,0ah,'$'

m003	db	'M003 - Sorry, invalid CP/M-86 version. '
	db	'This program needs version 1.1.'
	db	0dh,0ah,'$'

;M030 - The FIDD storage descriptor in the CP/M-86 segment is at xxxx:xxxxh,
;       the FIDD segment is xxxxh, available FIDD storage size is nn KB.
;       The FIDD storage area is from xxxx:0000h - xxxx:xxxxh.
;       The DIRBUF workarea in the CP/M-86 segment is at xxxx:xxxxh.

m030	db	'M030 - The FIDD storage descriptor in the CP/M-86 segment '
	db	'is at '
m030a	db	'xxxx:'
m030b	db	'xxxxh;'
	db	0dh,0ah
	db	'       the FIDD segment is '
m030c	db	'xxxxh, available FIDD storage size is '
m030d	db	'?  KB.'
	db	0dh,0ah
	db	'       The FIDD storage area is from '
m030e	db	'xxxx:'
m030f	db	'0000h - '
m030g	db	'xxxx:'
m030h	db	'xxxxh.'
	db	0dh,0ah
	db	'       The DIRBUF workarea in the CP/M-86 segment is at '
m030i	db	'xxxx:'
m030j	db	'xxxxh.'
	db	0dh,0ah,'$'

;M031 - Current "near" FIDD storage is nn KB, from xxxx:0000h - xxxx:xxxxh, 
;       which is xxxx:xxxxh - xxxx:xxxxh within the CP/M-86 segment.

m031	db	'M031 - Current "near" FIDD storage is '
m031a	db	'?  KB, from '
m031b	db	'xxxx:'
m031c	db	'0000h -'
m031d	db	'xxxx:'
m031e	db	'xxxxh,'
	db	0dh,0ah
	db	'       which is '
m031f	db	'xxxx:'
m031g	db	'xxxxh - '
m031h	db	'xxxx:'
m031i	db	'xxxxh within the CP/M-86 segment.'
	db	0dh,0ah,'$'

;M032 - No "near" FIDD storage available, all FIDD storage is "non-near".

m032	db	'M032 - No "near" FIDD storage available, '
	db	'all FIDD storage is "non-near".'
	db	0dh,0ah,'$'

;M033 - Current "non-near" FIDD storage is nn KB, from xxxx:xxxxh - xxxx:xxxxh.

m033	db	'M033 - Current "non-near" FIDD storage is '
m033a	db	'?  KB, from '
m033b	db	'xxxx:'
m033c	db	'xxxxh - '
m033d	db	'xxxx:'
m033e	db	'xxxxh.'
	db	0dh,0ah,'$'

;M034 - Non-"near" FIDD storage is 0 KB, all available FIDD storage is "near".

m034	db	'M034 - "Non-near" FIDD storage is 0 KB, all available '
	db	'FIDD storage is "near".'
	db	0dh,0ah,'$'

;M035 - Allocated nn KB of "near" FIDD storage at xxxx:0000h - xxxx:xxxxh,
;       which is xxxx:xxxxh - xxxx:xxxxh within the CP/M-86 segment.
;       New FIDD segment is xxxxh, new available FIDD storage size is nn KB.

m035	db	'M035 - Allocated '
m035a	db	'?  KB of "near" FIDD storage at '
m035b	db	'xxxx:'
m035c	db	'0000h - '
m035d	db	'xxxx:'
m035e	db	'xxxxh,'
	db	0dh,0ah
	db	'       which is '
m035f	db	'xxxx:'
m035g	db	'xxxxh - '
m035h	db	'xxxx:'
m035i	db	'xxxxh within the CP/M-86 segment.'
	db	0dh,0ah
	db	'       New FIDD segment is '
m035j	db	'xxxxh, new available FIDD storage size is '
m035k	db	'?  KB.'
	db	0dh,0ah,'$'

;M036 - Allocated nn KB of "non-near" FIDD storage at xxxx:xxxx - xxxx:xxxxh,
;       which is xxxx:0000h - xxxx:xxxxh when using a zero offset,
;	which is xxxx:0100h - xxxx:xxxxh when using an offset of 100h.
;       New FIDD segment is xxxxh, new available FIDD storage size is nn KB.

m036	db	'M036 - Allocated '
m036a	db	'?  KB of "non-near" FIDD storage at '
m036b	db	'xxxx:'
m036c	db	'xxxx - '
m036d	db	'xxxx:'
m036e	db	'xxxxh,'
	db	0dh,0ah
	db	'       which is '
m036f	db	'xxxx:0000h - '
m036g	db	'xxxx:'
m036h	db	'xxxxh when using a zero offset,'
	db	0dh,0ah
	db	'       which is '
m036i	db	'xxxx:0100h - '
m036j	db	'xxxx:'
m036k	db	'xxxxh when using an offset of 100h.'
	db	0dh,0ah
	db	'       FIDD segment remains '
m036l	db	'xxxxh, new available FIDD storage size is '
m036m	db	'?  KB.'
	db	0dh,0ah,'$'

m004	db	'M004 - Partition #'
m004a	db	'n on harddisk '
m004z	db	'1 is a partition with CP/M-86 virtual volumes:'
	db	0dh,0ah
	db	'       Start: cylinder='
m004b	db	'n    head='
m004c	db	'n   sector='
m004d	db	'n  ; start sector ='
m004e	db	'n         '
	db	0dh,0ah
	db	'       End  : cylinder='
m004f	db	'n    head='
m004g	db	'n   sector='
m004h	db	'n  ; total sectors='
m004i	db	'n         '
	db	0dh,0ah
	db	'       Size : '
m004j	db	'n          MB (where 1 MB is 1024 * 1024 is 1048576 bytes)'
	db	0dh,0ah,'$'

m005	db	'M005 - Ergo conclusio: the CP/M-86 code and data '
	db	'is at segment '
m005a	db	'xxxxh.'
	db	0dh,0ah,'$'

m051	db	'M051 - Segment for INT E0h BDOS call handler is '
m051a	db	'xxxxh.'
	db	0dh,0ah,'$'
m052	db	'M052 - Segment for INT 1Ch user timer tick handler is '
m052a	db	'xxxxh.'
	db	0dh,0ah,'$'
m053	db	'M053 - Segment for INT E6h FIDD handler is '
m053a	db	'xxxxh.'
	db	0dh,0ah,'$'
m054	db	'M054 - Segment for ALV of current drive is '
m054a	db	'xxxxh.'
	db	0dh,0ah,'$'
m055	db	'M055 - Segment for DPB of current drive is '
m055a	db	'xxxxh.'
	db	0dh,0ah,'$'
m056	db	'M056 - Segment for CP/M-86 system variables is '
m056a	db	'xxxxh.'
	db	0dh,0ah,'$'
m057	db	'M057 - Segment for INT 00h overflow handler is '
m057a	db	'xxxxh.'
	db	0dh,0ah,'$'
m058	db	'M058 - Segment for INT 1Bh keyboard break handler is '
m058a	db	'xxxxh.'
	db	0dh,0ah,'$'
m05a	db	'M05A - Segment for INT 1Eh diskette parameter table is '
m05aa	db	'xxxxh.'
	db	0dh,0ah,'$'

m059	db	'M059 - Sorry, cannot determine the CP/M-86 code & data '
	db	'segment.'
	db	0dh,0ah,'$'

m006	db	'M006 - Sorry, the BIOS jump table at address '
m006a	db	'xxxx:2500h in the CP/M-86 segment'
	db	0dh,0ah
	db	'       is invalid: there is no short or near jump '
	db	'opcode at offset '
m006b	db	'xxxxh.'
	db	0dh,0ah,'$'

m061	db	'M061 - The BIOS jump table at '
m061a	db	'xxxx:2500h has valid jump instructions.'
	db	0dh,0ah,'$'

m007	db	'M007 - Sorry, not enough "near" FIDD storage available.'
	db	0dh,0ah,'$'

m071	db	'M071 - This program needs a total of '
m071a	db	'?  KB of available FIDD storage:'
	db	0dh,0ah
	db	'       '
m071b	db	'?  KB as "near" storage, and '
m071c	db	'?  KB as "non-near" storage.'
	db	0dh,0ah,'$'

m008	db	'M008 - Sorry, not enough storage reserved for FIDD''s: '
m008a	db	'?  KB is required,'
	db	0dh,0ah
	db	'       but only '
m008b	db	'?  KB is available.'
	db	0dh,0ah,'$'

m083	db	'M083 - Sorry, the FIDD segment is not '
	db	'above the CP/M-86 segment:'
	db	0dh,0ah
	db	'       FIDD segment is '
m083a	db	'xxxxh, CP/M-86 segment is '
m083b	db	'xxxxh.'
	db	0dh,0ah,'$'

m009	db	'M009 - No partition with CP/M-86 virtual volumes found '
	db	'on harddisk '
m009a	db	'1.'
	db	0dh,0ah,'$'

m010	db	'M010 - I/O error reading master boot record on harddisk '
m010a	db	'1.'
	db	0dh,0ah,'$'

m011	db	'M011 - CP/M-86 virtual volume #'
m011b	db	'n  will be drive '
m011a	db	'x:.'
	db	0dh,0ah,'$'

m012	db	'M012 - CP/M-86 virtual volume #'
m012a	db	'n  cannot be used: no drive letter available.'
	db	0dh,0ah,'$'

m013	db	'M013 - Handler for interrupt E6h was '
m013c	db	'xxxx:'
m013d	db	'xxxxh, now changed to '
m013a	db	'xxxx:'
m013b	db	'xxxxh.'
	db	0dh,0ah,'$'

m014	db	'M014 - There are '
m014a	db	'n  CP/M-86 virtual volumes available for use.'
	db	0dh,0ah,'$'

m015	db	'M015 - Press ENTER to continue.......................'
	db	'........................'
	db	0dh,0ah,'$'

m016	db	0dh,0ah
	db	'M016 - Sorry, the driver for CP/M-86 Virtual Volumes '
	db	'is not loaded.'
	db	0dh,0ah,'$'

m017	db	'M017 - This program has used '
m017a	db	'?     bytes on the stack.'
	db	0dh,0ah,'$'

m018	db	'M018 - The CP/M-86 virtual volume partition on harddisk '
m018a	db	'1 contains '
m018b	db	'n  volumes.'
	db	0dh,0ah,'$'

m019	db	'M019 - I/O error reading CP/M-86 virtual volume parameters '
	db	'on harddisk '
m019a	db	'1.'
	db	0dh,0ah,'$'

m020	db	0dh,0ah
	db	'CP/M-86  virtual   hard'
	db	0dh,0ah
	db	' drive   volume    disk'
	db	0dh,0ah
	db	'-------  -------   ----'
	db	0dh,0ah,'$'

m021	db	'   '
m021a	db	'X:       '
m021b	db	'n        '
m021c	db	'X'
	db	0dh,0ah,'$'

m022	db	'M022 - Checksum of CP/M-86 virtual volume parameters is '
	db	'not correct.'
	db	0dh,0ah,'$'

m023	db	0dh,0ah
	db	'M023 - Statistics for the virtual volumes on harddisk '
m023a	db	'?:'
	db	0dh,0ah,0dh,0ah
	db	'Number of CP/M-86 reads..............................: '
m023b	db	'nnnnnnnnnn'
	db	0dh,0ah
	db	'- number of times sector not in buffer...............: '
m023c	db	'nnnnnnnnnn'
	db	0dh,0ah
	db	'- number of times buffer was saved before reading....: '
m023d	db	'nnnnnnnnnn'
	db	0dh,0ah
	db	0dh,0ah
	db	'Number of CP/M-86 writes.............................: '
m023e	db	'nnnnnnnnnn'
	db	0dh,0ah
	db	'- number of normal writes............................: '
m023f	db	'nnnnnnnnnn'
	db	0dh,0ah
	db	'  - number of times sector not in buffer.............: '
m023g	db	'nnnnnnnnnn'
	db	0dh,0ah
	db	'  - number of times buffer was saved before writing..: '
m023h	db	'nnnnnnnnnn'
	db	0dh,0ah
	db	'- number of unallocated writes.......................: '
m023i	db	'nnnnnnnnnn'
	db	0dh,0ah
	db	'  - number of times sector not in buffer.............: '
m023j	db	'nnnnnnnnnn'
	db	0dh,0ah
	db	'  - number of times buffer was saved before writing..: '
m023k	db	'nnnnnnnnnn'
	db	0dh,0ah
	db	'- number of directory writes.........................: '
m023l	db	'nnnnnnnnnn'
	db	0dh,0ah
	db	'  - number of times sector not in buffer.............: '
m023m	db	'nnnnnnnnnn'
	db	0dh,0ah
	db	'  - number of times buffer was saved before writing..: '
m023n	db	'nnnnnnnnnn'
	db	0dh,0ah,'$'

m024	db	0dh,0ah
	db	'M024 - Statistics have been reset to zero.'
	db	0dh,0ah,'$'

m025	db	'M025 - The CP/M-86 system drive has been changed from '
m025a	db	'X: to '
m025b	db	'X:.'
	db	0dh,0ah,'$'

m026	db	'M026 - Sorry, the version of the CP/M-86 virtual volumes '
	db	'partition on harddisk'
	db	0dh,0ah
	db	'       '
m026a	db	'1 is '
m026b	db	'n.'
m026c	db	'n, but this program can only handle '
	db	'partitions up to version 1.0.'
	db	0dh,0ah,'$'

;------

e6parms			equ	$	;described earlier in this program
e6p_biosdk_drive	db	1	;1 = drive B:
e6p_biosdk_fdrive	db	0
e6p_data_182		db	0
e6p_biosdk_track	dw	0
e6p_biosdk_sector	dw	0
e6p_biosdk_dma_offs	dw	0
e6p_biosdk_dma_segm	dw	0
e6p_biosdk_verify	db	0

STAKSIZ	equ	256			;size of local stack in words
endstak	equ	$
	db	STAKSIZ dup('fh')	;local stack
mystack	equ	$

;----------------------------------------------------------------------
;partition table on head 0, cylinder 0, sector 1

mbrbuf	db	512 dup(?)

peTable	equ	mbrbuf + 01beh		;start of partition table within MBR

;Format of a partition table entry (MS-DOS 5.0 ... 6.2).
;There are four PARTENTRY's, starting at 01BEh in absolute sector 0.

;PARTENTRY	STRUC		;4 entries, 16 bytes each
;peBootable	db	?	;80h = bootable, 00h = nonbootable
;peBeginHead	db	?	;beginning head
;peBeginSector	db	?	;bits 5...0: beginning sector
;				;bits 7...6: beginning cylinder bits 9...8
;peBeginCylinder	db	?	;beginning cylinder bits 7...0
;peFileSystem	db	?	;name of file system
;
;peEndHead	db	?	;ending head
;peEndSector	db	?	;bits 5...0: ending sector
;				;bits 7...6: ending cylinder bits 9...8
;peEndCylinder	db	?	;ending cylinder bits 7...0
;peStartSector	dd	?	;starting sector (relative to beg. of disk)
;peSectors	dd	?	;number of sectors in partition
;PARTENTRY	ENDS

;============== end of transient data =================================

	align	128			;pad with data until 128-byte boundary

;============== MASM 5.1 epilog for a .COM file =======================

tgb1		ends
	end	r0000
