/* Bouncing Ball Demo 
    By Ross Simpson   */

/* A general set of Library Routines 
   found in any standard CP/M-86 programs */
 
mode(no)
int no;
{
#asm
 push ax
 mov al,4[bp]
 mov ah,00
 int 10h
 pop ax
#endasm
}

pixel(column,row,col)
int column,row,col;
{
#asm
 push ax
 push bx
 push cx
 push dx
 mov ah,12
 mov al,4[bp]
 mov bh,0
 mov cx,8[bp]
 mov dx,6[bp]
 int 16
 pop dx
 pop cx
 pop bx
 pop ax
#endasm
}

rtcdelay(timedel)
int timedel;
{
 #asm
  push ax
  push bx
  push cx
  push dx
  push ds
  push si
  push di
  
  ; The delay bit
  
  mov ah,00h
  int 01ah
  add dx,4[bp] ; <- value for delay
  mov bx,dx
 pozz:
  int 01ah
  cmp dx,bx
  jl pozz
  pop di
  pop si
  pop ds
  pop dx
  pop cx
  pop bx
  pop ax
 #endasm
}

keypress(result)
int result;
{
#asm
 push ax
 push bx
 push cx
 push dx
 mov cl,11
 int 224
 mov 4[bp],al
 xor ax,ax
 pop dx
 pop cx
 pop bx
 pop ax
#endasm
return result;
}

statusoff()
{
 putchar(27);
 putchar(48);
 return;
}

statuson()
{
 putchar(27);
 putchar(49);
 return;
}

/* Routines for our Bouncing Ball Demo */
 
drawbox(xpos1,ypos1)
int xpos1,ypos1;
{
 int size,length,length2,ary;
 int ball[64];
 ball[0]=0; ball[1]=0; ball[2]=0; 
 ball[3]=0; ball[4]=0; ball[5]=0; 
 ball[6]=0; ball[7]=0; ball[8]=0; 
 ball[9]=0; ball[10]=1; ball[11]=1; 
 ball[12]=1; ball[13]=1; ball[14]=0; 
 ball[15]=0; ball[16]=0; ball[17]=1; 
 ball[18]=2; ball[19]=2; ball[20]=3; 
 ball[21]=2; ball[22]=1; ball[23]=0; 
 ball[24]=0; ball[25]=1; ball[26]=2; 
 ball[27]=2; ball[28]=3; ball[29]=3; 
 ball[30]=1; ball[31]=0; ball[32]=0; 
 ball[33]=1; ball[34]=2; ball[35]=2; 
 ball[36]=2; ball[37]=2; ball[38]=1; 
 ball[39]=0; ball[40]=0; ball[41]=1; 
 ball[42]=2; ball[43]=2; ball[44]=2; 
 ball[45]=2; ball[46]=1; ball[47]=0; 
 ball[48]=0; ball[49]=0; ball[50]=1; 
 ball[51]=1; ball[52]=1; ball[53]=1; 
 ball[54]=0; ball[55]=0; ball[56]=0; 
 ball[57]=0; ball[58]=0; ball[59]=0; 
 ball[60]=0; ball[61]=0; ball[62]=0; 
 ball[63]=0;
 length2=0;
 length=0;
 size=0;
 do
 {
  ary=ball[length++];
  pixel(xpos1+length2,ypos1+size,ary);
  ++length2;
  if (length2==8)
   {
    length2=0;
    ++size;
   }
 }
  while (length!=64);
}

/* Lets make a Box (for 
   our Ball to bounce in!) */

box()
{
 int boxx,boxy;
 boxx=79;
 boxy=49;
 do
 {
  pixel(boxx,boxy,2);
  ++boxx;
 }
 while (boxx!=238);
 do
 {
  pixel(boxx,boxy,3);
  ++boxy;
 }
 while (boxy!=147);
 do
 {
 pixel(boxx,boxy,3);
 --boxx;
 }
 while (boxx!=79);
 do
 {
 pixel(boxx,boxy,2);
 --boxy;
 }
 while (boxy!=49);
}

/* And howabout some flashy
   heading to boot! */

heading(xpos1,ypos1)
int xpos1,ypos1;
{
 int size,length,length2,ary,h[560];
 h[0]=1; h[1]=1; h[2]=1; h[3]=1; h[4]=1; h[5]=1; h[6]=0; h[7]=0; h[8]=0;
 h[9]=0; h[10]=1; h[11]=1; h[12]=1; h[13]=0; h[14]=0; h[15]=0; h[16]=0;
 h[17]=1; h[18]=1; h[19]=0; h[20]=0; h[21]=1; h[22]=1; h[23]=0; h[24]=1;
 h[25]=1; h[26]=0; h[27]=0; h[28]=0; h[29]=1; h[30]=1; h[31]=0; h[32]=0;
 h[33]=0; h[34]=1; h[35]=1; h[36]=1; h[37]=1; h[38]=0; h[39]=0; h[40]=0;
 h[41]=1; h[42]=1; h[43]=0; h[44]=0; h[45]=1; h[46]=1; h[47]=0; h[48]=0;
 h[49]=0; h[50]=0; h[51]=0; h[52]=0; h[53]=0; h[54]=0; h[55]=0; h[56]=0;
 h[57]=0; h[58]=0; h[59]=0; h[60]=0; h[61]=0; h[62]=0; h[63]=0; h[64]=0;
 h[65]=0; h[66]=0; h[67]=0; h[68]=0; h[69]=0; h[70]=0; h[71]=0; h[72]=0;
 h[73]=0; h[74]=1; h[75]=1; h[76]=1; h[77]=1; h[78]=0; h[79]=0; h[80]=0;
 h[81]=1; h[82]=1; h[83]=0; h[84]=0; h[85]=1; h[86]=1; h[87]=0; h[88]=0;
 h[89]=1; h[90]=1; h[91]=0; h[92]=1; h[93]=1; h[94]=0; h[95]=0; h[96]=0; 
 h[97]=1; h[98]=1; h[99]=0; h[100]=0; h[101]=1; h[102]=1; h[103]=0; 
 h[104]=1; h[105]=1; h[106]=1; h[107]=0; h[108]=0; h[109]=1; h[110]=1; 
 h[111]=0; h[112]=0; h[113]=1; h[114]=1; h[115]=0; h[116]=0; h[117]=1; 
 h[118]=1; h[119]=0;
 h[120]=0; h[121]=1; h[122]=1; h[123]=0; h[124]=0; h[125]=1; h[126]=1;
 h[127]=0; h[128]=0; h[129]=0; h[130]=0; h[131]=0; h[132]=0; h[133]=0;
 h[134]=0; h[135]=0; h[136]=0; h[137]=0; h[138]=0; h[139]=0; h[140]=0;
 h[141]=0; h[142]=0; h[143]=0; h[144]=0; h[145]=0; h[146]=0; h[147]=0;
 h[148]=0; h[149]=0; h[150]=0; h[151]=0; h[152]=0; h[153]=1; h[154]=0;
 h[155]=0; h[156]=0; h[157]=1; h[158]=1; h[159]=0; h[160]=0; h[161]=2;
 h[162]=2; h[163]=0; h[164]=0; h[165]=2; h[166]=2; h[167]=0; h[168]=2;
 h[169]=2; h[170]=0; h[171]=0; h[172]=0; h[173]=2; h[174]=2; h[175]=0;
 h[176]=0; h[177]=2; h[178]=2; h[179]=0; h[180]=0; h[181]=2; h[182]=2;
 h[183]=0; h[184]=2; h[185]=2; h[186]=2; h[187]=2; h[188]=0; h[189]=2;
 h[190]=2; h[191]=0; h[192]=2; h[193]=2; h[194]=0; h[195]=0; h[196]=0;
 h[197]=0; h[198]=0; h[199]=0; h[200]=0; h[201]=2; h[202]=2; h[203]=0;
 h[204]=0; h[205]=2; h[206]=2; h[207]=0; h[208]=0; h[209]=0; h[210]=0;
 h[211]=0; h[212]=0; h[213]=0; h[214]=0; h[215]=0; h[216]=0; h[217]=2;
 h[218]=2; h[219]=0; h[220]=0; h[221]=2; h[222]=2; h[223]=0; h[224]=0;
 h[225]=0; h[226]=0; h[227]=0; h[228]=0; h[229]=0; h[230]=0; h[231]=0;
 h[232]=0; h[233]=0; h[234]=0; h[235]=0; h[236]=0; h[237]=2; h[238]=2;
 h[239]=0; h[240]=0; h[241]=2; h[242]=2; h[243]=2; h[244]=2; h[245]=2;
 h[246]=0; h[247]=0; h[248]=2; h[249]=2; h[250]=0; h[251]=0; h[252]=0;
 h[253]=2; h[254]=2; h[255]=0; h[256]=0; h[257]=2; h[258]=2; h[259]=0;
 h[260]=0; h[261]=2; h[262]=2; h[263]=0; h[264]=2; h[265]=2; h[266]=0;
 h[267]=2; h[268]=2; h[269]=2; h[270]=2; h[271]=0; h[272]=2; h[273]=2;
 h[274]=0; h[275]=0; h[276]=0; h[277]=0; h[278]=0; h[279]=0; h[280]=0;
 h[281]=0; h[282]=2; h[283]=2; h[283]=2; h[284]=2; h[285]=2; h[286]=0;
 h[287]=0; h[288]=0; h[289]=0; h[290]=0; h[291]=0; h[292]=0; h[293]=0;
 h[294]=0; h[295]=0; h[296]=0; h[297]=2; h[298]=2; h[299]=0; h[300]=0;
 h[301]=2; h[302]=2; h[303]=0; h[304]=0; h[305]=0; h[306]=0; h[307]=0;
 h[308]=0; h[309]=0; h[310]=0; h[311]=0; h[312]=0; h[313]=0; h[314]=0;
 h[315]=2; h[316]=2; h[317]=2; h[318]=0; h[319]=0; h[320]=0; h[321]=2;
 h[322]=2; h[323]=0; h[324]=0; h[325]=2; h[326]=2; h[327]=0; h[328]=2;
 h[329]=2; h[330]=0; h[331]=0; h[332]=0; h[333]=2; h[334]=2; h[335]=0;
 h[336]=0; h[337]=2; h[338]=2; h[339]=0; h[340]=0; h[341]=2; h[342]=2;
 h[343]=0; h[344]=2; h[345]=2; h[346]=0; h[347]=0; h[348]=2; h[349]=2;
 h[350]=2; h[351]=0; h[352]=2; h[353]=2; h[354]=0; h[355]=0; h[356]=0;
 h[357]=0; h[358]=0; h[359]=0; h[360]=0; h[361]=0; h[362]=0; h[363]=2;
 h[364]=2; h[365]=0; h[366]=0; h[367]=0; h[368]=0; h[369]=0; h[370]=0;
 h[371]=0; h[372]=0; h[373]=0; h[374]=0; h[375]=0; h[376]=0; h[377]=2;
 h[378]=2; h[379]=0; h[380]=0; h[381]=2; h[382]=2; h[383]=0; h[384]=0;
 h[385]=0; h[386]=0; h[387]=0; h[388]=0; h[389]=0; h[390]=0; h[391]=0;
 h[392]=0; h[393]=0; h[394]=0; h[395]=0; h[396]=0; h[397]=2; h[398]=2;
 h[399]=0; h[400]=0; h[401]=3; h[402]=3; h[403]=0; h[404]=0; h[405]=3;
 h[406]=3; h[407]=0; h[408]=0; h[409]=3; h[410]=3; h[411]=0; h[412]=3;
 h[413]=3; h[414]=0; h[415]=0; h[416]=0; h[417]=3; h[418]=3; h[419]=0;
 h[420]=0; h[421]=3; h[422]=3; h[423]=0; h[424]=3; h[425]=3; h[426]=0;
 h[427]=0; h[428]=0; h[429]=3; h[430]=3; h[431]=0; h[432]=0; h[433]=3;
 h[434]=3; h[435]=0; h[436]=0; h[437]=3; h[438]=3; h[439]=0; h[440]=0;
 h[441]=0; h[442]=0; h[443]=3; h[444]=3; h[445]=0; h[446]=0; h[447]=0;
 h[448]=0; h[449]=0; h[450]=0; h[451]=0; h[452]=0; h[453]=0; h[454]=0;
 h[455]=0; h[456]=0; h[457]=0; h[458]=3; h[459]=3; h[460]=3; h[461]=3;
 h[462]=0; h[463]=0; h[464]=0; h[465]=0; h[466]=0; h[467]=3; h[468]=3;
 h[469]=0; h[470]=0; h[471]=0; h[472]=0; h[473]=3; h[474]=3; h[475]=0;
 h[476]=0; h[477]=3; h[478]=3; h[479]=0; h[480]=3; h[481]=3; h[482]=3;
 h[483]=3; h[484]=3; h[485]=3; h[486]=0; h[487]=0; h[488]=0; h[489]=0;
 h[490]=3; h[491]=3; h[492]=3; h[493]=0; h[494]=0; h[495]=0; h[496]=0;
 h[497]=0; h[498]=3; h[499]=3; h[500]=3; h[501]=3; h[502]=0; h[503]=0;
 h[504]=3; h[505]=3; h[506]=0; h[507]=0; h[508]=0; h[509]=3; h[510]=3;
 h[511]=0; h[512]=0; h[513]=0; h[514]=3; h[515]=3; h[516]=3; h[517]=3;
 h[518]=0; h[519]=0; h[520]=0; h[521]=0; h[522]=3; h[523]=3; h[524]=3;
 h[525]=3; h[526]=0; h[527]=0; h[528]=0; h[529]=0; h[530]=0; h[531]=0;
 h[532]=0; h[533]=0; h[534]=0; h[535]=0; h[536]=0; h[537]=0; h[538]=0;
 h[539]=3; h[540]=3; h[541]=0; h[542]=0; h[543]=0; h[544]=0; h[545]=0;
 h[546]=0; h[547]=3; h[548]=3; h[549]=0; h[550]=0; h[551]=0; h[552]=0;
 h[553]=0; h[554]=3; h[555]=3; h[556]=3; h[557]=3; h[558]=0; h[559]=0;
 length2=0;
 length=0;
 size=0;
 do
 {
  ary=h[length++];
  pixel(xpos1+length2,ypos1+size,ary);
  ++length2;
  if (length2==80)
  {
   length2=0;
   ++size;
  }
 }
 while (length!=560);
}

main()
{ 
 int xpos,xdir,ypos,ydir,keyreslt;
 statusoff();
 mode(4);
 heading(10,10);
 box();
 xpos=80;
 ypos=50;
 xdir=1;
 ydir=1;
 do
 {
  xpos=xpos+xdir;
  ypos=ypos+ydir;
  if (xpos > 229)
    xdir=-1;
  if (xpos < 81)
    xdir=1;
  if (ypos > 138)
    ydir=-1;
  if (ypos < 51)
    ydir=1;
  rtcdelay(1);
  drawbox(xpos,ypos);
 }
  while (keypress(keyreslt)!=1);
  mode(3);
  statuson();
}