;
;		PATCH - Generic File Patcher
;
;
; IMPORTANT: The ONLY parameters that need to be altered by the
; user are those in the boxes marked by asterix (***) at the end
; of the file.
;
; Assemble using any 8086 assembler e.g.
;
;	A86 PATCHER.ASM	(if using Eric Isaacson's A86.COM)
;
;	TASM PATCHER	(if using Borland's TASM)
;	TLINK /T PATCHER
;
; NOTE:
; -----
; You can use the MSDOS file compare utility FC.EXE to generate
; the 'differences' between two files. e.g.
;
;		FC /b oldfile newfile >diff.txt
;
; DIFF.TXT provides the address offsets and difference bytes for
; cutting/pasting into this source file.
;
;---------------------------------------------------------------

; Last updated:	8-Jan-01

; ASCII control codes
;
bel	equ	7
ht	equ	9
lf	equ	10
ff	equ	12
cr	equ	13
eof	equ	26

	.8086				; assemble for 8086/88 CPU

code_seg segment public

	assume	cs:code_seg,ds:code_seg

	org	0100h

main:	mov	dx,offset hello		; startup message
	call	print

main1:	mov	word ptr abytes,offset bytes
	mov	word ptr aoffs,offset offs
	mov	word ptr afind,offset value
	mov	word ptr arepl,offset value+1

	mov	si,offset fname		; point to first filename

	xor	cx,cx
	mov	cl,byte ptr files	; get number of files to patch
	or	cx,cx
	jz	main5			; none - quit

main2:	lodsb
	mov	byte ptr filopt,al

	push	si
	push	cx
	mov	word ptr afname,si

	mov	byte ptr filpat,0	; clear file flags
	mov	byte ptr filerr,0

	mov	dx,offset chk		; pass1 msg
	cmp	byte ptr pass,1
	jnz	main3
	mov	dx,offset pat		; pass2 msg
main3:	call	print

	call	pfile			; print filename
	call	patch			; check/patch file
	call	stat			; show results

	pop	cx
	pop	si
	dec	cx
	jz	main5

	add	word ptr abytes,2	; set pointers to data for next file
	add	word ptr aoffs,4
	add	word ptr afind,2
	add	word ptr arepl,2

main4:	lodsb				; point to next filename
	or	al,al
	jnz	main4
	jmp	short main2

main5:	call	pcrlf

	cmp	byte ptr fatal,0	; skip next pass if any errors
	jnz	done
	cmp	byte ptr patched,0	; or already patched
	jz	done

	dec	byte ptr pass		; decr pass counter
	jz	done
	jmp	main1

; All done

done:	cmp	byte ptr fatal,0	; any fatal errors?
	jnz	done3

	mov	dx,offset warned	; any warnings?
	cmp	byte ptr warnn,0
	jnz	done1

	mov	dx,offset succes	; any patches done?
	cmp	byte ptr patched,0
	jz	done2

done1:	call	print

done2:	mov	al,0			; return code = 0
	jmp	short done4

done3:	mov	dx,offset failed	; error message
	call	print
	mov	al,1			; return code = 1

done4:	mov	ah,4ch			; quit to dos
	int	21h

; Display status for last file processed
;
stat:	mov	al,byte ptr filerr
	or	al,al
	jnz	stat1			; file error encountered

	mov	dx,offset apat
	cmp	byte ptr filpat,0
	jz	stat3			; already patched

	mov	dx,offset ok
	jmp	short stat3		; else ok

stat1:	mov	dx,offset err1
	dec	al
	jnz	stat2

	cmp	al,byte ptr filopt
	jz	stat3
	mov	dx,offset err0		; err1 - warning
	jmp	short stat3

stat2:	mov	dx,offset err2
	dec	al
	jz	stat3			; err 2

	mov	dx,offset err3
	dec	al
	jz	stat3			; err 3

	mov	dx,offset uerr
stat3:	jmp	print

; Check / patch one file
;
patch:	mov	si,word ptr abytes
	mov	cx,word ptr [si]
	or	cx,cx
	jz	patch5			; no bytes to patch

	push	cx
	mov	ax,3d02h		; open file for read/write
	mov	dx,word ptr afname	; filename
	int	21h
	mov	bx,ax			; save filehandle
	mov	al,1
	jc	patch7			; open error

patch1:	call	seek			; position file pointer
	mov	al,2
	jc	patch7			; seek error

	mov	ah,3fh			; read one byte from file to buffer
	mov	cx,1
	mov	dx,offset buff
	int	21h
	mov	al,2
	jc	patch7			; read error

	mov	al,byte ptr buff	; compare byte read with replace byte
	mov	di,word ptr arepl
	scasb
	jz	patch2			; already done

	mov	byte ptr filpat,1	; set patched flags
	mov	byte ptr patched,1

	mov	di,word ptr afind	; compare byte read with find byte
	scasb
	mov	al,2
	jnz	patch7			; byte not found

	call	seek			; reposition file pointer
	mov	al,2
	jc	patch7			; seek error

	cmp	byte ptr pass,1		; don't write on first pass
	jnz	patch2

	call	write			; write replacement byte
	mov	al,3
	jc	patch7			; write error

patch2:	pop	cx
	dec	cx
	jz	patch5
	call	patch6
	push	cx
	jmp	short patch1

patch3:	pop	cx
patch4:	call	sterr
patch5:	mov	ax,3e00h		; close file
	int	21h
	ret

patch6:	add	word ptr aoffs,4	; bump pointers for next patch byte
	add	word ptr afind,2
	add	word ptr arepl,2
	ret

patch7:	pop	cx			; skip to data for next file
patch8:	dec	cx
	jz	patch4
	call	patch6
	jmp	short patch8

; Set error and warning flags
;
sterr:	mov	byte ptr filerr,al
	or	al,al
	jz	sterr2

	cmp	al,1			; if file not found error
	jnz	sterr1

	cmp	al,byte ptr filopt	; AND file has optional flag
	jnz	sterr1

	mov	byte ptr warnn,1	; set warning flag
	ret

sterr1:	mov	byte ptr fatal,al	; set general error flag
sterr2:	ret

; Move file pointer
;
seek:	push	es
	mov	si,word ptr aoffs	; get offset
	les	dx,dword ptr [si]
	mov	cx,es
	mov	ax,4200h		; offset from start of file
	int	21h
	pop	es
	ret

; Write one byte to file
;
write:	mov	dx,word ptr arepl
	mov	cx,1
	mov	ax,4000h
	int	21h
	ret

; Print asciiz string
;
print:	push	si
	mov	si,dx
print1:	lodsb
	or	al,al
	jz	print2
	int	29h
	jmp	short print1

print2:	pop	si
	ret

; Print current filename
;
pfile:	mov	dx,word ptr afname
	call	print
	mov	dx,offset sep
	jmp	short print

; Print CRLF
;
pcrlf:	mov	dx,offset crlf
	jmp	short print

; Data area

filerr	db	0		; current file error flag
filpat	db	0		; current file patch ok flag
filopt	db	0		; current file optional flag
fatal	db	0		; general error flag
warnn	db	0		; general warning flag
patched	db	0		; patched ok (0=some files already patched)
pass	db	2		; pass counter
buff	db	0		; read buffer
abytes	dw	0		; ptr - num bytes to patch in file
aoffs	dw	0		; ptr - offset to byte
afind	dw	0		; ptr - byte to find
arepl	dw	0		; ptr - byte to replace
afname	dw	0		; ptr - filename

sep	db	' ... ',0
chk	db	cr,lf,'checking ',0
pat	db	cr,lf,'patching ',0
ok	db	'ok',0
apat	db	'already patched',0
succes	db	cr,lf,'Patch successfully installed'
crlf	db	cr,lf,0
warned	db	cr,lf,'*** ONE OR MORE WARNINGS OCCURRED ***',cr,lf,0
failed	db	cr,lf,'*** PATCH FAILED ***',cr,lf,0
err0	db	'warning - '
err1	db	'missing or write-protected!',0
err2	db	'pattern not found - wrong version or compressed!',0
err3	db	'write error!',0
uerr	db	'unspecified error occured!',0

;
;	THIS IS THE BEGINNING OF THE USER MODIFIED AREA -
;	DO NOT MAKE ANY CHANGES TO THE CODE BEFORE THIS POINT
;
;************************************************************************
;*									*
;*	ENTER THE STARTUP MESSAGE TO BE DISPLAYED			*
;*									*
;*	The string must end with a null character - ascii zero.		*
;*									*
hello:
	db	cr,lf
	db	'[8-Jan-2001]  Patching ...',cr,lf
	db	'----------------------------------------',cr,lf
	db	' Put details of file to be patched here ',cr,lf
	db	'----------------------------------------',cr,lf
	db	0

;*									*
;*	ENTER THE NUMBER OF FILES THAT NEED TO BE PATCHED		*
;*									*
files	db	6			; # files to patch

;*									*
;*	ENTER OPTIONAL FLAG AND FILENAME FOR EACH FILE			*
;*									*
;*	db	0			; 0 = file must be present	*
;*					; 1 = file is optional		*
;*	db	'filename.ext',0	; path\filename - must end with	*
;*					; a zero (ascii null).		*
fname:
	db	0,'FILE1.EXE',0		; file 1
	db	0,'FILE2.EXE',0		; file 2
	db	0,'FILE3.EXE',0		; file 3
	db	0,'FILE4.EXE',0		; file 4
	db	0,'FILE5.EXE',0		; file 5
	db	0,'FILE6.EXE',0		; file 6

;*									*
;*	ENTER THE NUMBER OF BYTES TO BE PATCHED FOR EACH FILE		*
;*									*
bytes:
	dw	5			; file 1
	dw	13			; file 2
	dw	5			; file 3
	dw	5			; file 4
	dw	7			; file 5
	dw	5			; file 6

;*									*
;*	ENTER THE ADDRESSES TO BE PATCHED				*
;*									*
;* For each location to be patched, enter the 32-bit offset address.	*
;* These are the addresses from the start of the file where each patch	*
;* is to be made.  Repeat for each file.				*
;*									*
;*		ADDRESS							*
offs:
	dd	0h		; file1
	dd	0h
	dd	0h
	dd	0h
	dd	0h

	dd	0h		; file2
	dd	0h
	dd	0h
	dd	0h
	dd	0h
	dd	0h
	dd	0h
	dd	0h
	dd	0h
	dd	0h
	dd	0h
	dd	0h
	dd	0h

	dd	0h		; file3
	dd	0h
	dd	0h
	dd	0h
	dd	0h

	dd	0h		; file4
	dd	0h
	dd	0h
	dd	0h
	dd	0h

	dd	0h		; file5
	dd	0h
	dd	0h
	dd	0h
	dd	0h
	dd	0h
	dd	0h

	dd	0h		; file6
	dd	0h
	dd	0h
	dd	0h
	dd	0h

;*									*
;*	ENTER THE BYTES	TO BE PATCHED					*
;*									*
;* For each address to be patched, enter the byte to be found at this	*
;* location.  This is the 'FIND' byte - if this value is not found,	*
;* the patcher will abort with an error.				*
;*									*
;* For each 'FIND' byte, enter the new value it will be replaced by.	*
;* This is the 'REPLACE' byte.						*
;*									*
;* Repeat the above for each file to be patched.			*
;*									*
;*		FIND	REPLACE						*
value:
	db	0h,	0h		; file1
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h

	db	0h,	0h		; file2
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h

	db	0h,	0h		; file3
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h

	db	0h,	0h		; file4
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h

	db	0h,	0h		; file5
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h

	db	0h,	0h		; file6
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h
	db	0h,	0h

;*									*
;************************************************************************

code_seg ends

	end	main

