PROGRAM GULPER (INPUT, OUTPUT);

{ These compiler directives are peculiar to Turbo Pascal                      }
{ $I-R+,V-,U-,K-,C-}

{ The program is written in Turbo Pascal for the IBM PC. It may be easily     }
{ converted for other Pascals or computers if account is taken of the         }
{ comments immediately below, and of the comments in the procedure            }
{ assign_value, below                                                         }
{                                                                             }
{  > KBD used as parameter of read or readln prevents echo to screen of       }
{    characters being read                                                    }
{  > The program assumes a screen at least 80 columns wide and 24 lines deep  }
{  > Procedures and functions peculiar to Turbo Pascal:                       }
{    PROCEDURES:                                                              }
{       GotoXY (x, y) - Moves cursor to column x and row y of screen; top     }
{          left corner is (1, 1)                                              }
{       ClrScr - Clears Screen                                                }
{       Sound (f) - emits tone of frequency f in hertz until the procedure    }
{          NoSound is encountered                                             }
{       Delay (t) - pauses for t milliseconds                                 }
{    FUNCTIONS:                                                               }
{       KeyPressed: BOOLEAN - returns value true if key has been pressed      }
{       Random (n: INTEGER): INTEGER - returns a 'random' integer greater or  }
{          equal to 0 and less than n                                         }
{       UpCase (c: CHAR): CHAR - returns uppercase equivalent of character c  }
{          if c is lowercase, else returns c                                  }

   CONST

   depth = 19;
   width = 47;
   indent = 16;
   header = 0;
   no_ghosts = 2;
   dot_value = 1;
   ghost_value = 100;
   bonus_value = 500;
   fastest = 100;
   acceleration = 10;
   max_comp_bonus = 300;
TYPE
   position = RECORD
                 x: INTEGER;
                 y: INTEGER;
              END;
   charstring = PACKED ARRAY [1..48] OF CHAR;
VAR
   gulper, reply, normal_gulper, super_gulper, ghost, wall, den: CHAR;
   bonus, key, square, power_pill, blank, terminal, dot: CHAR;
   gulper_pos, gulper_old_pos, choice, this_bonus_pos: position;
   i, lives, score, num_dots, wait_time, completion_bonus: INTEGER;
   this_ghost: 1..no_ghosts;
   bonuses, number_directions: 0..3;
   moves_count: 0..20;
   bonus_life: 0..50;

   distance, shortest, longest: REAL;
   grid: ARRAY [1..depth] OF ARRAY [1..width] OF CHAR;
   port: ARRAY [1..2] OF RECORD
                            entrance: position;
                            exit: position;
                         END;
   ghost_pos, ghost_old_pos: ARRAY [1..no_ghosts] OF position;
   den_pos,bonus_pos: ARRAY [1..4] OF position;
   dead, bonus_on: BOOLEAN;

PROCEDURE assign_values;

{ If your computer's character set is different from the IBM PC's you may     }
{ have to assign other characters to these variables                          }

BEGIN
   normal_gulper := chr (2);      { face }
   super_gulper := chr (234);     { square: ~ }
   ghost := chr (1);              { inverse-video face }
   wall := chr (219);             { solidly coloured rectangle: / }
   den := chr (176);              { half-tone rectangle: 0 }
   bonus := chr (3);              { heart shape }
   power_pill := chr (4);         { lozenge }
   blank := ' ';
   dot := '.';
   terminal := '$'
END; { assign_values }

PROCEDURE title_page;
   VAR
      row: 1..24;

   PROCEDURE sidescroll (slice: charstring);
      VAR
         i, j: 1..24;
   BEGIN
      FOR i :=1 TO 16 DO BEGIN
         GotoXY (1, row);
         FOR j:= 1 TO i DO
            write ('  ');
         write (slice)
      END;
      row := row + 1
  END; { sidescroll }

BEGIN
   ClrScr;
   row := 5;
   sidescroll (' GGGG   UU  UU  LL      PPPPPP   EEEEEE  RRRRRR ');
   sidescroll ('GG  GG  UU  UU  LL      PP   PP  EE      RR   RR');
   sidescroll ('GG      UU  UU  LL      PP   PP  EE      RR   RR');
   sidescroll ('GG      UU  UU  LL      PP   PP  EEEE    RR   RR');
   sidescroll ('GG  GG  UU  UU  LL      PPPPPP   EE      RRRRRR ');
   sidescroll ('GG  GG  UU  UU  LL      PP       EE      RR  RR ');
   sidescroll (' GGGGG   UUUU   LLLLLL  PP       EEEEEE  RR   RR');
  GotoXY (22, 15);
  writeln ('By    H A M I S H    B    L A W S O N ');
  Delay (2000)
END; { title page }

PROCEDURE give_instructions;
   VAR
      i: 1..26;
      indent: ARRAY [1..26] OF CHAR;
BEGIN
   ClrScr;
   FOR i :=1 TO 26 DO
      indent [i] := ' ';
   writeln (indent, 'I N S R U C T I O N S');
   writeln (indent, '=====================');
   writeln;
   write ('Move Gulper ',normal_gulper,' around the maze by means of ');
   writeln ('the numeric keypad:');
   writeln;
   writeln (indent, '        UP');
   writeln (indent, '        Q');
   writeln (indent, 'LEFT  O   P  RIGHT');
   writeln (indent, '        A');
   writeln (indent, '       DOWN');
   writeln;
   write ('Your  aim is to eat all the dots whilst  avoiding the  gho');
   write ('sts ', ghost, ' chasing you.  If');
   write ('you eat a  power pill ',power_pill, ' you can then chase t');
   write ('he  ghosts.   Your ability to  chasegho');
   write ('sts is indicated  by the gulper changing to ', super_gulper);
   write (' :  you will also hear a pipping');
   write ('tone which will stop just before  time is up for  chasing ');
   write ('the ghosts.   A caught');
   write ('ghost (worth ', ghost_value, ' points) returns to one of t');
   write ('he central squares ', den, ' .  If you enter');
   write ('one of the teleports ', terminal, ' you will be transporte');
   write ('d to the other one: but beware! you');
   write ('have a 1 in 4 chance of being teleported into hyperspace. ');
   write (' Bonuses  ', bonus, ' appear now');
   write ('and again and are worth  ', bonus_value, ' points.   Howev');
   write ('er if you wish to get them  you will');
   writeln ('have to be quick: they only appear for a short time.');
   writeln;
   write ('Don''t take too long to eat the dots as the ghosts move fa');
   writeln ('ster all the time.');
   GotoXY (24,24)
END; {Give_instructions}

PROCEDURE make_grid;
   VAR
      i, j: INTEGER;
   FUNCTION rep (symbol: CHAR): CHAR;
   BEGIN
      CASE symbol of
          'w': rep := wall;
          '.': rep := dot;
          ' ': rep := blank;
          't': rep := terminal;
          'p': rep := power_pill;
          'd': rep := den;
      END
   END; {rep}

BEGIN
   grid [ 1] := 'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww';
   grid [ 2] := 'wp...................wwwww...................pw';
   grid [ 3] := 'w.wwwww.wwwwwwww.www.wwwww.www.wwwwwwww.wwwww.w';
   grid [ 4] := 'w.wwwww.wwwwwwww.www.wwwww.www.wwwwwwww.wwwww.w';
   grid [ 5] := 'w................www.......www................w';
   grid [ 6] := 'wwwwwww.wwwww.wwwww..ww ww..wwwww.wwwww.wwwwwww';
   grid [ 7] := 'wwwwwww.wwwww.wwww..www www..wwww.wwwww.wwwwwww';
   grid [ 8] := 'w..........ww.www..www   www..www.ww..........w';
   grid [ 9] := 'w.wwwwwwww.ww.www.www  d  www.www.ww.wwwwwwww.w';
   grid [10] := 'w.  twwwww........    dwd    ........wwwwwt  .w';
   grid [11] := 'w.wwwwwwww.ww.www.www  d  www.www.ww.wwwwwwww.w';
   grid [12] := 'w..........ww.www..www   www..www.ww..........w';
   grid [13] := 'wwwwwww.wwwww.wwww..www www..wwww.wwwww.wwwwwww';
   grid [14] := 'wwwwwww.wwwww.wwwww..ww ww..wwwww.wwwww.wwwwwww';
   grid [15] := 'w................www.......www................w';
   grid [16] := 'w.wwwww.wwwwwwww.www.wwwww.www.wwwwwwww.wwwww.w';
   grid [17] := 'w.wwwww.wwwwwwww.www.wwwww.www.wwwwwwww.wwwww.w';
   grid [18] := 'wp...................wwwww...................pw';
   grid [19] := 'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww';
   port [1].entrance.x :=  5; port [1].entrance.y := 10;
   port [1].exit.x :=  4; port [1].exit.y := 10;
   port [2].entrance.x := 43; port [2].entrance.y := 10;
   port [2].exit.x := 44; port [2].exit.y := 10;
   den_pos [1].x := 23; den_pos [1].y := 10;
   den_pos [2].x := 25; den_pos [2].y := 10;
   den_pos [3].x := 24; den_pos [3].y :=  9;
   den_pos [4].x := 24; den_pos [4].y := 11;
   bonus_pos [1].x := 24; bonus_pos [1].y :=  6;
   bonus_pos [2].x := 19; bonus_pos [2].y := 10;
   bonus_pos [3].x := 29; bonus_pos [3].y := 10;
   bonus_pos [4].x := 24; bonus_pos [4].y := 14;
   num_dots := 0;
   FOR i := 1 TO depth DO
      FOR j := 1 TO width DO BEGIN
         IF grid [i, j] = '.' THEN num_dots := num_dots + 1;
         grid [i, j] := rep (grid [i, j])
      END
   END; { make grid }

PROCEDURE draw_square (pos: position; square: CHAR);
BEGIN
   WITH pos DO
      GotoXY (x + indent, y + header);
   write (square);
   GotoXY (1, 22)
END; { draw square }

PROCEDURE draw_grid;
   VAR
      i, j: INTEGER;
   BEGIN
      FOR i := 1 TO depth DO BEGIN
         GotoXY (indent + 1, i + header);
         FOR j := 1 TO width DO
            write (grid [i, j])
         END;
         FOR i := 1 TO no_ghosts DO
            draw_square (ghost_pos [i], ghost);
         draw_square (gulper_pos, normal_gulper)
      END; { draw grid }

      FUNCTION hyp_sqr (ghost_pos: position): REAL;
      BEGIN
         WITH gulper_pos DO
            hyp_sqr := sqr (x - ghost_pos.x) + sqr (y - ghost_pos.y)
      END; {hyp_sqr}

PROCEDURE teleport (VAR pos, old_pos: position);
   VAR other: 1..2;
BEGIN
   WITH port [1].entrance DO
      IF (pos.x = x) AND (pos.y = y ) THEN
         other := 2
      ELSE
         other := 1;
   pos := port [other].exit;
   old_pos := port [other].entrance
END; { teleport }

PROCEDURE move_ghost;
BEGIN
  ghost_old_pos [this_ghost] := ghost_pos [this_ghost];
  WITH ghost_old_pos [this_ghost] DO
     draw_square (ghost_old_pos [this_ghost], grid [y, x]);
  ghost_pos [this_ghost] := choice;
  WITH ghost_pos [this_ghost] DO
     IF grid [y, x] = terminal THEN
        teleport (ghost_pos [this_ghost], ghost_old_pos [this_ghost]);
  draw_square (ghost_pos [this_ghost], ghost)
END; { move ghost }

PROCEDURE move_gulper;

   PROCEDURE ghost_dead;
   BEGIN
      score := score + ghost_value;
      GotoXY (17,22);
      write ('SCORE = ', score: 6);
      draw_square (ghost_pos [i], gulper);
      ghost_pos [i] := den_pos [random (4) + 1];
      ghost_old_pos [i] := ghost_pos [i];
      draw_square (ghost_pos [i], ghost)
   END; { check_ghost_dead }

   PROCEDURE energize;
      VAR chase_time: INTEGER;

      PROCEDURE choose_ghosts_move;

         PROCEDURE check_valid_square;
         BEGIN
            WITH ghost_pos [this_ghost] DO BEGIN
               IF (x <> ghost_old_pos [this_ghost].x)
               OR (y <> ghost_old_pos [this_ghost].y) THEN
                  IF NOT (grid [y, x] IN [wall, den]) THEN BEGIN
                     distance := hyp_sqr (ghost_pos [this_ghost]);
                     IF distance > longest THEN BEGIN
                        longest := distance;
                        choice := ghost_pos [this_ghost]
                     END
                  END
            END
         END; {check_valid square}

      BEGIN
         longest := -1;
         WITH ghost_pos [this_ghost] DO BEGIN
            y := y - 1;
            check_valid_square;
            y := y + 2;
            check_valid_square;
            x := x - 1; y :=y - 1;
            check_valid_square;
            x := x + 2;
            check_valid_square;
            x := x - 1
         END
      END; { choose_ghosts_move }

BEGIN
   grid [gulper_pos.y, gulper_pos.x] := blank;
   draw_square (gulper_old_pos, blank);
   draw_square (gulper_pos, gulper);
   chase_time := 100;
   WHILE (chase_time >= 0) AND NOT dead DO BEGIN
      gulper := super_gulper;
     { IF chase_time > 10 THEN Sound (2000); }
     { NoSound; }
      FOR i := 1 TO wait_time DO
          IF KeyPressed THEN move_gulper;
      choose_ghosts_move;
      move_ghost;
      WITH ghost_pos [this_ghost] do
      IF (x = gulper_pos.x) AND (y = gulper_pos.y) THEN
         ghost_dead;

         this_ghost := this_ghost MOD no_ghosts + 1;
         chase_time := chase_time - 1
      END;
      gulper := normal_gulper;
      draw_square (gulper_old_pos, blank);
      draw_square (gulper_pos, gulper);
   END; { energize }

BEGIN
   read (KBD, key);
   IF key IN ['2', '4', '6', '8', 'Q', 'O', 'P', 'A'] THEN BEGIN
      gulper_old_pos := gulper_pos;
      WITH gulper_pos DO BEGIN
         CASE key of
            '2', 'A': y := y + 1;
            '4', 'O': x := x - 1;
            '6', 'P': x := x + 1;
            '8', 'Q': y := y - 1;
         END;
         square := grid [y, x]
      END;
      IF square IN [wall, den] THEN
         gulper_pos := gulper_old_pos
      ELSE BEGIN
         draw_square (gulper_old_pos, blank);
         FOR i := 1 TO no_ghosts DO
            WITH ghost_pos [i] DO
               IF (x= gulper_pos.x) AND (y= gulper_pos.y) THEN
                  IF gulper = normal_gulper THEN
                     dead := true
                  ELSE
                     ghost_dead;
         IF NOT dead THEN BEGIN
            IF square = dot THEN BEGIN
               score := score + dot_value;
               GotoXY (17, 22);
               write ('SCORE = ', score: 6);
               num_dots := num_dots - 1
               END
            ELSE
               IF square = terminal THEN
                  IF random (4) = 0 THEN
                     dead := true
                  ELSE
                     teleport (gulper_pos, gulper_old_pos)
               ELSE
                  IF square = bonus THEN BEGIN
                     score := score + bonus_value;
                     GotoXY (17, 22);
                     write ('SCORE = ', score: 6)

                  END
               ELSE
                  IF square = power_pill THEN energize
          END;
          IF NOT dead THEN BEGIN

            grid [gulper_pos.y, gulper_pos.x] := blank;
            draw_square (gulper_pos, gulper)
         END
      END
   END
END; { move_gulper }

PROCEDURE choose_ghosts_move;

   PROCEDURE check_valid_square;
     VAR
        allowed: BOOLEAN;
     BEGIN
        WITH ghost_pos [this_ghost] DO BEGIN
           IF (x <> ghost_old_pos [this_ghost].x)
           OR (y <> ghost_old_pos [this_ghost].y) THEN BEGIN
           allowed := true;
           FOR i := 1 TO no_ghosts DO
              IF i <> this_ghost THEN
                 allowed := allowed AND
                 NOT ((x = ghost_pos [i].x) AND (y = ghost_pos [i].y));
           IF allowed THEN
              IF NOT (grid [y, x] IN [wall, den]) THEN BEGIN
                 number_directions := number_directions + 1;
                 distance := hyp_sqr (ghost_pos [this_ghost]);
                 IF distance < shortest THEN BEGIN
                    shortest := distance;
                    choice := ghost_pos [this_ghost]
                 END
              END
        END
     END
  END; {check valid square}

BEGIN
   shortest := maxint;
   number_directions := 0;
   WITH ghost_pos [this_ghost] DO BEGIN
      y := y - 1;
      check_valid_square;
      y := y + 2;
      check_valid_square;
      x := x - 1; y := y - 1;
      check_valid_square;
      x := x + 2;
      check_valid_square;
      x := x - 1;
   END;
   IF number_directions <> 1 THEN
      IF hyp_sqr (ghost_old_pos [this_ghost]) < shortest THEN
         choice := ghost_old_pos [this_ghost]
END; { choose ghosts move }

PROCEDURE regulate_bonuses;
BEGIN
     IF NOT bonus_on THEN BEGIN
        IF bonuses > 0 THEN
           IF random (200) = 0 THEN BEGIN
              bonus_on := true;
              this_bonus_pos := bonus_pos [random (4) + 1];
              grid [this_bonus_pos.y, this_bonus_pos.x] := bonus;
              draw_square (this_bonus_pos, bonus);
              bonuses := bonuses - 1;
              GotoXY (35, 22);
              write ('BONUSES LEFT:');
              FOR i := 1 TO bonuses DO
                 write (' ', bonus);
              write ('       ');
             { Sound (1000); }
              Delay (100);
             { NoSound; }
              bonus_life := 50
            END
        END
     ELSE BEGIN
        bonus_life := bonus_life - 1;
        IF bonus_life = 0 THEN BEGIN
           bonus_on := false;
           grid [this_bonus_pos.y, this_bonus_pos.x] := blank;
           draw_square (this_bonus_pos, blank)
        END
     END;
  END; { regulate_bonuses }

BEGIN
   assign_values;
   title_page;
   REPEAT
      score := 0;
      lives := 3;
      wait_time := 800;
      make_grid;
      bonuses := 3;
      completion_bonus := max_comp_bonus;
     { NoSound; }
      give_instructions;
      WHILE lives > 0 DO BEGIN
         write ('PRESS <RETURN> TO CONTINUE ');
         readln (KBD);
         ClrScr;
         gulper_pos.x := 24;
         gulper_pos.y :=  5;
         gulper := normal_gulper;
         FOR i := 1 TO no_ghosts DO BEGIN
            ghost_pos [i] := den_pos [random (4) + 1];
            ghost_old_pos [i] := ghost_pos [i]
         END;
         gulper_old_pos := gulper_pos;

         draw_grid;
         GotoXY (17, 22);

        write ('SCORE = ', score: 6);
        write ('    BONUSES LEFT:');
        FOR i := 1 TO bonuses DO
           write (' ', bonus);
        GotoXY (60, 22);
        FOR i := 1 TO lives - 1 DO
           write (' ', gulper);
        this_ghost := 1;
        dead := false;
        moves_count := acceleration;
        REPEAT
        UNTIL KeyPressed;
        REPEAT

           regulate_bonuses;
           FOR i := 1 TO wait_time DO
              IF KeyPressed AND NOT dead THEN move_gulper;
           choose_ghosts_move;
           move_ghost;
           WITH ghost_pos [this_ghost] DO
              IF (x = gulper_pos.x) AND (y = gulper_pos.y) THEN
                 dead := true;
           this_ghost := this_ghost MOD no_ghosts + 1;
           moves_count := moves_count - 1;
           IF moves_count = 0 THEN BEGIN
              moves_count := acceleration;
              IF wait_time > fastest THEN
                 wait_time := wait_time - 1;
              IF completion_bonus > 0 THEN
                 completion_bonus := completion_bonus - 1
          END



       UNTIL dead OR (num_dots = 0);
       IF dead THEN BEGIN
          lives := lives - 1;
         { Sound (200); }
          Delay (500);
         { NoSound; }
          GotoXY (15, 24);
          write ('YOU HAVE LOST A LIFE - ');
          END
       ELSE BEGIN
          score := score + completion_bonus;
          bonuses := 3;
          completion_bonus := max_comp_bonus;
          make_grid;
          GotoXY (12, 24);
          write ('YOU HAVE EATEN ALL THE DOTS - ')
       END


    END;
    GotoXY (15,24);
    write ('G A M E    O V E R   -   Do you want another game?');
    REPEAT
       read (KBD, reply);
       reply := UpCase (reply)
    UNTIL reply IN ['Y', 'N']

 UNTIL reply = 'N'

END.
