Program StarfieldSimulation;
{ 3D Starfield 1.0                   }
{ Written by Hkon Stordahl 15.11.96 }

{$I GFX3X.pas}
{$I TERMINAL.INC}
{$I CLRCHK.INC}

Const
  VGA      = $A000;
  MaxStars = 400;
{ Antallet stjerner som skal vises p skjermen p en gang, dvs antallet      }
{ stjerner i starfielden.                                                    }

Type
  Star = RECORD
    X, Y, Z: INTEGER;
  end;
{ Hver stjerne m ha en X, Y og Z koordinat.                                 }

Var
  Starfield: ARRAY[1..MaxStars] OF Star;
{ Selve starfielden som bestr av 400 X, Y og Z koordinater.                 }

Procedure Syntax;

begin
  WriteLn('3D Starfield 1.0');
  WriteLn('Written by Hkon Stordahl 15.11.96');
  WriteLn;
  WriteLn('Syntax: 3DSTAR');
end;

Procedure InitStars;

Var
  I: INTEGER;

begin
  SetPal(1, 53, 53, 53); { Fargen til stjernene som er nrmest.              }
  SetPal(2, 43, 43, 43);
  SetPal(3, 33, 33, 33);
  SetPal(4, 23, 23, 23); { Fargen til stjernene som er lengst unna.          }
  { Setter X, Y og Z verdier til alle stjernene.                             }
  FOR I := 1 TO MaxStars DO
  begin
    Repeat
      Starfield[I].X := Random(320) - 160;
      { Setter X til et tilfeldig tall mellom -160 og +160.                  }
      Starfield[I].Y := Random(200) - 100;
      { Setter Y til et tilfeldig tall mellom -100 og +100.                  }
      Starfield[I].Z := I;
      { Setter Z til et tall fra 1 til 400, slik at alle stjernene blir      }
      { jevnt fordelt utover. Stjernene med lavest Z verdi er nrmest        }
      { skjermen, de med hyest Z verdi er lengst unna.                      }
    Until (Starfield[I].X <> 0) AND (Starfield[I].Y <> 0);
      { Dette skal gjentas helt til vi er sikre p at bde X og Y ikke       }
      { er lik 0. Hvis ikke vil stjernen g rett fram (ikke forsvinne        }
      { ut til sidene) og "kolidere" med skjermen.                           }
  end;
      { X, Y og Z korodinatene som blir lagret i denne prosedyren vil        }
      { bli oversatt til "vanlige" X (0..199) og Y (0..320) koordinater,     }
      { som du kan plotte p skjermen, i prosedyren under.                   }
      { Det kan virke litt meningslst  lage disse koordinatene for         }
      { s  regne dem om senere, men du vil se at ettersom vil ker         }
      { eller minsker Z koordinatene vil resultet av prosedyren under        }
      { bli forskjellig selv om vi har de samme uvanlige (de som du          }
      { ikke skal plotte p skjermen) X og Y koordinatene.                   }
end;

Procedure CalcStarCoord(Star1: Star; VAR X2, Y2: INTEGER);

{ Her m du se i Denthor's tutor, for mer info. Det eneste jeg kan si er at  }
{ denne prosedyren regner om X, Y og Z koordinatene til en stjerne til X og  }
{ Y koordinater som du kan plotte p skjermen.                               }

{ Star1.X SHL 8 = Star1.X * 2^8 (2 opphyd i 8) = Star1.X * 256.             }
{ SHL betyr Shift Left og skifter bitsene i et tall X plasser mot venstre.   }
{ Dette fungerer p samme mte som  gange tallet med 2 opphyd i X plasser. }
{ Denne metoden  gange p er noe raskere enn vanlig ganging.                }
{ 00000001   = 1                                                             }
{ SHL 8      * 2^8                                                           }
{ 100000000  = 256                                                           }

Const
  Xoff = 160;
  Yoff = 100;
  Zoff = 0;

begin
  X2 := ((Star1.X SHL 8) DIV (Star1.Z - Zoff)) + Xoff;  { N SHL 8 = N * 2^8 }
  Y2 := ((Star1.Y SHL 8) DIV (Star1.Z - Zoff)) + Yoff;  { N SHL 8 = N * 2^8 }
end;

Procedure MoveStars(Move: BOOLEAN; Speed: INTEGER; Where: INTEGER);
{ Denne prosedyren ker/minsker Z koordinatene med Speed. Jo hyere Speed    }
{ er, jo raskere beveger stjernene seg.                                      }
{ Move er retningen stjernene skal bevege seg i. Er Move = True vil          }
{ stjernene bevege seg mot oss. Da vil Z koordinatene minskes fordi det er   }
{ som sagt de nrmeste stjernene som har de laveste Z verdiene.              }
{ I motsatt tilfelle vil stjernene bevege seg fra oss, og Z verdien til alle }
{ stjernene vil kes.                                                        }

Var
  I   : INTEGER; { FOR-TO-DO loop kontroll variabel                          }
  X, Y: INTEGER; { X og Y koordinatene som skal plottes p skjermen.         }
  Col : INTEGER; { Fargen p den stjerna som skal vises                      }

begin
  FOR I := 1 TO MaxStars DO
  { Alle stjernene i starfielden blir gtt gjennom i denne loopen. Nummeret  }
  { til den aktuelle stjerna vil da vre I.                                  }
  begin
    CalcStarCoord(Starfield[I], X, Y);
    { Frst m vi finne de gamle X og Y koordinatene til den aktuelle        }
    { stjerna.                                                               }
    IF (X > 0) AND (X < 320) AND (Y > 0) AND (Y < 200) THEN SetPixel(X, Y, 0, Where);
    { Deretter m vi sette en pixel i X og Y for  "overskrive" de gamle     }
    { koordinatene. Ellers ville starfielden sett ut som massevis av hvite   }
    { striper eller noe snt.                                                }
    IF Move THEN { Hvis vi vil at stjernene skal komme mot oss, m vi:       }
    begin
      { Minske (decrease) Z verdien til stjerna. }
      Starfield[I].Z:=Starfield[I].Z-Speed;
      IF Starfield[I].Z < 1 THEN Starfield[I].Z := Starfield[I].Z + MaxStars;
      { Hvis Z verdien er blitt mindre enn 1 vil stjerna befinne seg helt i  }
      { kanten p skjermen, i ferd med  forsvinne ut av den. Da m vi sette }
      { Z verdien lik MaxStars (i dette tilfellet 400) slik at vi flytter    }
      { stjernen bakerst i starfielden, lengst bort fra yet.                }
    end
    ELSE
    begin { Ellers, hvis vil vi at stjernene skal g fra oss, og da m vi:   }
      { ke (increase) Z verdien til stjerna.    }
      Starfield[I].Z:=Starfield[I].Z+Speed;
      IF Starfield[I].Z > MaxStars THEN Starfield[I].Z := Starfield[I].Z - MaxStars;
      { Hvis Z verdien er strre en MaxStars (i dette tilfellet 400) vil     }
      { stjerna befinne seg lengst bak i starfielden, siden vi nsker at     }
      { starfielden skal bevege seg fra oss m vi da sette Z koordinaten til }
      { stjerna lik 1, dvs Strarfield[I].Z - MaxStars = 1.                   }
    end;
    { S regner vi ut de nye koordinatene til stjerna. (som har blitt        }
    { forandret etter at vi kte/minska Z veriden.)                          }
    CalcStarCoord(Starfield[I], X, Y);
    { Hvis Z verdien til stjerna er liten fr den lys farge, fordi den langt }
    { framme i starfielden, ellers fr den litt mrkere farge.               }
    { Disse fargene ble definert i InitStars prosedyren.                     }
         IF Starfield[I].Z <= 100 THEN Col := 1 { Lysere  }
    ELSE IF Starfield[I].Z <= 200 THEN Col := 2 { Lys     }
    ELSE IF Starfield[I].Z <= 300 THEN Col := 3 { Mrk    }
    ELSE IF Starfield[I].Z <= 400 THEN Col := 4 { Mrkere }
    ELSE Col := 4; { Alle andre tilfeller blir den satt til mrk.            }
    { (Det skulle egentlig ikke vre noen andre tilfeller.)                  }
    IF (X > 0) AND (X < 320) AND (Y > 0) AND (Y < 200) THEN SetPixel(X, Y, Col, Where);
    { Plotter stjernen p skjermen med fargen Col.                           }
  end;
end;

Var
  Ch   : CHAR;
  Move : BOOLEAN;
  Speed: INTEGER;

begin
  IF ParamCount <> 0 THEN Syntax
  { Hvis ingen parameter er gitt starter programmet.                         }
  ELSE
  begin
    CHECKVGA;
    STATUSOFF;
    SetVideoMode($13);
    InitStars; { Initierer stjerne-koordinater og farger.                    }
    Move := True; { Stjernene skal komme mot oss med en gang vi starter      }
    { programmet, men vi har mulighet for  forandre dette senere.           }
    Speed := 2; { Hastigheten til stjernene skal vre 2 nr du starter. Er   }
    { hastigheten 0, vil ikke stjernene bevege seg i det hele tatt.          }
    MoveStars(Move, Speed, VGA);
    { Beveg hele starfielden en gang fr hovedloop'en starter.               }
    Repeat
      WaitRetrace; { Venter p Verticle Retrace (eller hva pokker det heter) }
      { Dette sakker ned programmet litt, men gjr at det blit et bedre      }
      { skjermblide.                                                         }
      MoveStars(Move, Speed, VGA);
      IF KeyPressed THEN
      begin
        Ch:= ReadKey;
        CASE Ch OF
          #43: IF Speed < 30 THEN Speed:=Speed+1; {Plus-knappen ker            }
          { hastigheten.                                                     }
          #45: IF Speed > 0 THEN Speed:=Speed-1; {Minus-knappen senker          }
          { hastigheten.                                                     }
          #13: Move := NOT Move; { Hvis du trykker p enter vil starfielden  }
          { starte  bevege seg i motsatt retning enn det den gjr i         }
          { yeblikket. NOT True = False, NOT False = True.                  }
        end;
      end;
    Until Ch = #27; { Kjr hovedloopen helt til du trykker p escape. Escape }
    { har ASCII koden 27.                                                    }
    SetVideoMode($03);
    STATUSON;
    GOTOXY(1,1);
    ch:=' '; {This will stop this program exiting straight away if it is
              run a second time}
    WriteLn('3D Starfield 1.0');
    WriteLn('Written by Hkon Stordahl 15.11.96');
  end;
end.