use IO::Seekable;

%charTable = (
	      '10110000' , "\n",
	      '00001100' , '0',
	      '10001100' , '1',
	      '01001100' , '2',
	      '11001100' , '3',
	      '00101100' , '4',
	      '10101100' , '5',
	      '01101100' , '6',
	      '11101100' , '7',
	      '00011100' , '8',
	      '10011100' , '9',
	      '10000010' , 'A',
	      '01000010' , 'B',
	      '11000010' , 'C',
	      '00100010' , 'D',
              '10100010' , 'E',
	      '01100010' , 'F',
	      '11100010' , 'G',
	      '01011100' , ':',
	      '10100100' , '%',
              );

# 	      	      '00000000' , '0x00', '10000000' , '0x01', '01000000' , '0x02', '11000000' , '0x03', '00100000' , '0x04', '10100000' , '0x05', '01100000' , '0x06', '11100000' , '0x07', '00010000' , '0x08', '10010000' , '0x09',
# 	      '10001000' , 'DC1', '01001000' , 'DC2', '11001000' , 'DC3', '00101000' , 'DC3', '00000010' , '@', '00010010' , 'H',

while (@ARGV != 0) {
    my $cmdlinearg = shift (@ARGV);
    if ("$cmdlinearg" eq '-d') { $DEBUG = 1; }
    if ("$cmdlinearg" eq '-w') { $fileName   = shift @ARGV; }
    if ("$cmdlinearg" eq '-t') { $highToneChar   = shift @ARGV; }
    if ("$cmdlinearg" eq '-h') { 
	print "usage: tonedec  -w waveFile (22050 Hz, 8 bit, unsigned) \n";
	print "               [-t high tone char [[0]|1] ] \n";                   
	print "               [-h this text] \n";                   
	exit;
    }
}
#sub rm_getVars {
if ($fileName eq '') { errMsg ("usage: perl tonedec.pl -w wavFile"); exit; }
#    my $fileName = 'comx_b0.wav';
    open (FH, "$fileName") or &errMsg ("cannot open $fileName\n");
    my $fhReadable = 1;
    my $wavByte, $res, $val, $fhPointer = 0;
    my $currPolCount =  $prevPolCount = $bitCount = 0;
    my $newPolarity = $oldPolarity = 0;
    my $upperLimit = 150;
    my $lowerLimit = 110;
    my $hTone, $lTone, $bitString;
    if ($highToneChar eq '' or $highToneChar ne '1') {
        $hTone = "0";
        $lTone = "1";
    } else {
        $hTone = "1";
        $lTone = "0";
    }
    while ($fhReadable == 1) {
#        print "\n$fhPointer ";
        seek(FH, $fhPointer, SEEK_SET) or &errMsg ("error seeking $fileName\n");
	
        $res = read(FH, $wavByte, 1);
        ($val) = unpack('C', $wavByte);
        unless ($res) {
            &errMsg ("Error reading $fileName. Exiting.\n");
	    exit;
	}
	# Do not interpret header
	if ($fhPointer < 44) {
	    if ($val > 31 and $val < 128) {
		if ($DEBUG) {print $wavByte;}
	    } else {
		if ($DEBUG) {print ".";}
	    } 
	} else {
            if ($val < $lowerLimit) {
    	        #low
#	        print "0";
		$newPolarity = 0;
	    } elsif ($val > $upperLimit) {
	        #high
#	        print "1";
		$newPolarity = 1;
	    } else {
	        #mid
#	        print " ";
	    }
            if ($newPolarity eq $oldPolarity) {
		$currPolCount++;
	    } else {
#		print "Change";
		if ($prevPolCount > 3 and $prevPolCount < 9 and $currPolCount > 3 and $currPolCount < 9) { 
		    if ($DEBUG) {print $hTone;} 
		    $bitString = $bitString.$hTone;
		    $prevPolCount = 0;
		    $bitCount++;
		    
	        } elsif ($currPolCount > 12 and $prevPolCount > 12) {
		    if ($bitCount > 9) {
                        $char = &evalBits($bitString);
			print "$char";
			if ($DEBUG) {print "\n";} 
			$bitCount = 0;
			$bitString = '';
		    } 
		    if ($DEBUG) {print $lTone;}
		    $bitString = $bitString.$lTone;
		    $prevPolCount = 0;
		    $bitCount++;
		    
	        } else {
		    $prevPolCount = $currPolCount;
		}
		$currPolCount = 1;
#		if ($bitCount > 10) {print "\n"; $bitCount = 0; } 
	    }
	    $oldPolarity = $newPolarity;
        }
#	print $newPolarity;
        $fhPointer++;
    }
#}

sub errMsg {
    my ($str) = @_;
    print $str;
}

sub evalBits {
    my ($bitPatt, @d) = @_;
    my $patLen = length($bitPatt);
    if ($patLen != 10) { return ''; }
    my $charPatt = substr($bitPatt, 1, 8);
#    print " ($charPatt)";
    my $char = $charTable{$charPatt};
    return "$char";
}

